/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.text;

import org.jfree.fonts.text.Spacing;

public final class Glyph {
    private static final int[] EMPTY_EXTRA_CHARS = new int[0];
    public static final int SPACE_CHAR = 0;
    public static final int LETTER = 1;
    private int codepoint;
    private int breakWeight;
    private int classification;
    private Spacing spacing;
    private int width;
    private int height;
    private int baseLine;
    private int kerning;
    private int[] extraChars;

    public Glyph(int codepoint, int breakWeight, int classification, Spacing spacing, int width, int height, int baseLine, int kerning, int[] extraChars) {
        this.spacing = spacing == null ? Spacing.EMPTY_SPACING : spacing;
        this.extraChars = extraChars == null ? EMPTY_EXTRA_CHARS : (int[])extraChars.clone();
        this.baseLine = baseLine;
        this.codepoint = codepoint;
        this.breakWeight = breakWeight;
        this.width = width;
        this.height = height;
        this.classification = classification;
        this.kerning = kerning;
    }

    public int getClassification() {
        return this.classification;
    }

    public int[] getExtraChars() {
        return (int[])this.extraChars.clone();
    }

    public int getBaseLine() {
        return this.baseLine;
    }

    public int getCodepoint() {
        return this.codepoint;
    }

    public int getBreakWeight() {
        return this.breakWeight;
    }

    public Spacing getSpacing() {
        return this.spacing;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getKerning() {
        return this.kerning;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Glyph glyph = (Glyph)o;
        if (this.breakWeight != glyph.breakWeight) {
            return false;
        }
        if (this.codepoint != glyph.codepoint) {
            return false;
        }
        if (this.height != glyph.height) {
            return false;
        }
        if (this.kerning != glyph.kerning) {
            return false;
        }
        if (this.width != glyph.width) {
            return false;
        }
        return this.spacing.equals((Object)glyph.spacing);
    }

    public int hashCode() {
        int result = this.codepoint;
        result = 29 * result + this.breakWeight;
        result = 29 * result + this.spacing.hashCode();
        result = 29 * result + this.width;
        result = 29 * result + this.height;
        result = 29 * result + this.kerning;
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "={codepoint='" + (char)(this.codepoint & 0xFFFF) + ", extra-chars=" + this.extraChars.length + '}';
    }
}

