/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.text;

import java.util.ArrayList;
import org.jfree.fonts.registry.FontMetrics;
import org.jfree.fonts.text.ClassificationProducer;
import org.jfree.fonts.text.DefaultLanguageClassifier;
import org.jfree.fonts.text.GraphemeClusterProducer;
import org.jfree.fonts.text.LanguageClassifier;
import org.jfree.fonts.text.Spacing;
import org.jfree.fonts.text.SpacingProducer;
import org.jfree.fonts.text.StaticSpacingProducer;
import org.jfree.fonts.text.breaks.BreakOpportunityProducer;
import org.jfree.fonts.text.breaks.LineBreakProducer;
import org.jfree.fonts.text.breaks.WordBreakProducer;
import org.jfree.fonts.text.classifier.GlyphClassificationProducer;
import org.jfree.fonts.text.classifier.LinebreakClassificationProducer;
import org.jfree.fonts.text.classifier.WhitespaceClassificationProducer;
import org.jfree.fonts.text.font.FontSizeProducer;
import org.jfree.fonts.text.font.GlyphMetrics;
import org.jfree.fonts.text.font.KerningProducer;
import org.jfree.fonts.text.font.NoKerningProducer;
import org.jfree.fonts.text.font.VariableFontSizeProducer;
import org.jfree.fonts.text.whitespace.CollapseWhiteSpaceFilter;
import org.jfree.fonts.text.whitespace.DiscardWhiteSpaceFilter;
import org.jfree.fonts.text.whitespace.PreserveBreaksWhiteSpaceFilter;
import org.jfree.fonts.text.whitespace.PreserveWhiteSpaceFilter;
import org.jfree.fonts.text.whitespace.WhiteSpaceFilter;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.keys.text.TextWrap;
import org.jfree.layouting.input.style.keys.text.WhitespaceCollapse;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.model.SpacerRenderNode;
import org.jfree.layouting.renderer.text.Glyph;
import org.jfree.layouting.renderer.text.RenderableTextFactory;
import org.jfree.layouting.renderer.text.TextUtility;
import org.jfree.util.ObjectUtilities;

public class DefaultRenderableTextFactory
implements RenderableTextFactory {
    private LayoutProcess layoutProcess;
    private GraphemeClusterProducer clusterProducer;
    private boolean startText;
    private boolean produced;
    private FontSizeProducer fontSizeProducer;
    private KerningProducer kerningProducer;
    private SpacingProducer spacingProducer;
    private BreakOpportunityProducer breakOpportunityProducer;
    private WhiteSpaceFilter whitespaceFilter;
    private CSSValue whitespaceCollapseValue;
    private GlyphClassificationProducer classificationProducer;
    private LayoutContext layoutContext;
    private LanguageClassifier languageClassifier;
    private transient GlyphMetrics dims;
    private ArrayList words;
    private ArrayList glyphList;
    private long leadingMargin;
    private int lastLanguage;
    private transient FontMetrics fontMetrics;
    private static final int[] EMPTY_EXTRA_CHARS = new int[0];
    private static final RenderNode[] EMPTY_RENDER_NODE = new RenderNode[0];
    private static final RenderableText[] EMPTY_TEXT = new RenderableText[0];

    public DefaultRenderableTextFactory(LayoutProcess layoutProcess) {
        this(layoutProcess, true);
    }

    protected DefaultRenderableTextFactory(LayoutProcess layoutProcess, boolean init) {
        this.layoutProcess = layoutProcess;
        if (init) {
            this.clusterProducer = new GraphemeClusterProducer();
            this.languageClassifier = new DefaultLanguageClassifier();
            this.startText = true;
            this.words = new ArrayList();
            this.glyphList = new ArrayList();
            this.dims = new GlyphMetrics();
        }
    }

    public RenderNode[] createText(int[] text, int offset, int length, LayoutContext layoutContext) {
        if (layoutContext == null) {
            throw new NullPointerException();
        }
        this.kerningProducer = this.createKerningProducer(layoutContext);
        this.fontSizeProducer = this.createFontSizeProducer(layoutContext);
        this.spacingProducer = this.createSpacingProducer(layoutContext);
        this.breakOpportunityProducer = this.createBreakProducer(layoutContext);
        this.whitespaceFilter = this.createWhitespaceFilter(layoutContext);
        this.classificationProducer = this.createGlyphClassifier(layoutContext);
        this.layoutContext = layoutContext;
        if (this.startText) {
            this.whitespaceFilter.filter(Integer.MIN_VALUE);
            this.breakOpportunityProducer.createBreakOpportunity(Integer.MIN_VALUE);
            this.kerningProducer.getKerning(Integer.MIN_VALUE);
            this.startText = false;
            this.produced = false;
        }
        FontSpecification fontSpecification = layoutContext.getFontSpecification();
        OutputProcessorMetaData outputMetaData = this.layoutProcess.getOutputMetaData();
        this.fontMetrics = outputMetaData.getFontMetrics(fontSpecification);
        return this.processText(text, offset, length);
    }

    protected RenderNode[] processText(int[] text, int offset, int length) {
        int clusterStartIdx = -1;
        int maxLen = Math.min(length + offset, text.length);
        for (int i = offset; i < maxLen; ++i) {
            int codePoint = text[i];
            boolean clusterStarted = this.clusterProducer.createGraphemeCluster(codePoint);
            if (!clusterStarted) continue;
            if (i > offset) {
                int extraCharLength = i - clusterStartIdx - 1;
                if (extraCharLength > 0) {
                    int[] extraChars = new int[extraCharLength];
                    System.arraycopy(text, clusterStartIdx + 1, extraChars, 0, extraChars.length);
                    this.addGlyph(text[clusterStartIdx], extraChars);
                } else {
                    this.addGlyph(text[clusterStartIdx], EMPTY_EXTRA_CHARS);
                }
            }
            clusterStartIdx = i;
        }
        if (clusterStartIdx >= offset) {
            int extraCharLength = maxLen - clusterStartIdx - 1;
            if (extraCharLength > 0) {
                int[] extraChars = new int[extraCharLength];
                System.arraycopy(text, clusterStartIdx + 1, extraChars, 0, extraChars.length);
                this.addGlyph(text[clusterStartIdx], extraChars);
            } else {
                this.addGlyph(text[clusterStartIdx], EMPTY_EXTRA_CHARS);
            }
        }
        if (!this.words.isEmpty()) {
            RenderNode[] renderableTexts = this.words.toArray(new RenderNode[this.words.size()]);
            this.words.clear();
            this.produced = true;
            return renderableTexts;
        }
        return EMPTY_RENDER_NODE;
    }

    protected void addGlyph(int rawCodePoint, int[] extraChars) {
        boolean stripWhitespaces;
        if (rawCodePoint == Integer.MAX_VALUE) {
            this.whitespaceFilter.filter(rawCodePoint);
            this.classificationProducer.getClassification(rawCodePoint);
            this.kerningProducer.getKerning(rawCodePoint);
            this.breakOpportunityProducer.createBreakOpportunity(rawCodePoint);
            this.spacingProducer.createSpacing(rawCodePoint);
            this.fontSizeProducer.getCharacterSize(rawCodePoint, this.dims);
            if (this.leadingMargin != 0L || !this.glyphList.isEmpty()) {
                this.addWord(false);
            } else {
                this.glyphList.clear();
                this.leadingMargin = 0L;
            }
            return;
        }
        int codePoint = this.whitespaceFilter.filter(rawCodePoint);
        if (codePoint == -1) {
            if (extraChars.length == 0) {
                stripWhitespaces = true;
            } else {
                codePoint = 32;
                stripWhitespaces = false;
            }
        } else {
            stripWhitespaces = false;
        }
        int glyphClassification = this.classificationProducer.getClassification(codePoint);
        long kerning = this.kerningProducer.getKerning(codePoint);
        int breakweight = this.breakOpportunityProducer.createBreakOpportunity(codePoint);
        Spacing spacing = this.spacingProducer.createSpacing(codePoint);
        this.dims = this.fontSizeProducer.getCharacterSize(codePoint, this.dims);
        int width = this.dims.getWidth() & Integer.MAX_VALUE;
        int height = this.dims.getHeight() & Integer.MAX_VALUE;
        this.lastLanguage = this.languageClassifier.getScript(codePoint);
        for (int i = 0; i < extraChars.length; ++i) {
            int extraChar = extraChars[i];
            this.dims = this.fontSizeProducer.getCharacterSize(extraChar, this.dims);
            width = Math.max(width, this.dims.getWidth() & Integer.MAX_VALUE);
            height = Math.max(height, this.dims.getHeight() & Integer.MAX_VALUE);
            breakweight = this.breakOpportunityProducer.createBreakOpportunity(extraChar);
            glyphClassification = this.classificationProducer.getClassification(extraChar);
        }
        if (stripWhitespaces) {
            return;
        }
        if (0 == glyphClassification && this.isWordBreak(breakweight)) {
            boolean forceLinebreak;
            boolean bl = forceLinebreak = breakweight == 4;
            if (!this.glyphList.isEmpty() || forceLinebreak) {
                this.addWord(forceLinebreak);
            }
            this.leadingMargin += (long)width;
            return;
        }
        Glyph glyph = new Glyph(codePoint, breakweight, glyphClassification, spacing, width, height, this.dims.getBaselinePosition(), (int)kerning, extraChars);
        this.glyphList.add(glyph);
        if (this.isWordBreak(breakweight) && !this.glyphList.isEmpty()) {
            boolean forceLinebreak = breakweight == 4;
            this.addWord(forceLinebreak);
        }
    }

    protected void addWord(boolean forceLinebreak) {
        if (this.glyphList.isEmpty()) {
            if (forceLinebreak) {
                RenderableText text = new RenderableText(TextUtility.createBaselineInfo(10, this.fontMetrics), new Glyph[0], 0, 0, this.lastLanguage, forceLinebreak);
                text.appyStyle(this.layoutContext, this.layoutProcess.getOutputMetaData());
                this.words.add(text);
            } else if (this.produced) {
                SpacerRenderNode spacer = new SpacerRenderNode(this.leadingMargin, 0L, false);
                spacer.appyStyle(this.layoutContext, this.layoutProcess.getOutputMetaData());
                this.words.add(spacer);
            }
        } else {
            Glyph[] glyphs = this.glyphList.toArray(new Glyph[this.glyphList.size()]);
            if (this.leadingMargin > 0L) {
                SpacerRenderNode spacer = new SpacerRenderNode(this.leadingMargin, 0L, false);
                spacer.appyStyle(this.layoutContext, this.layoutProcess.getOutputMetaData());
                this.words.add(spacer);
            }
            int codePoint = glyphs[0].getCodepoint();
            RenderableText text = new RenderableText(TextUtility.createBaselineInfo(codePoint, this.fontMetrics), glyphs, 0, glyphs.length, this.lastLanguage, forceLinebreak);
            text.appyStyle(this.layoutContext, this.layoutProcess.getOutputMetaData());
            this.words.add(text);
            this.glyphList.clear();
        }
        this.leadingMargin = 0L;
    }

    private boolean isWordBreak(int breakOp) {
        return 3 == breakOp || 4 == breakOp;
    }

    protected WhiteSpaceFilter createWhitespaceFilter(LayoutContext layoutContext) {
        CSSValue wsColl = layoutContext.getValue(TextStyleKeys.WHITE_SPACE_COLLAPSE);
        if (ObjectUtilities.equal((Object)this.whitespaceCollapseValue, (Object)wsColl) && this.whitespaceFilter != null) {
            this.whitespaceFilter.reset();
            return this.whitespaceFilter;
        }
        this.whitespaceCollapseValue = wsColl;
        if (WhitespaceCollapse.DISCARD.equals(wsColl)) {
            return new DiscardWhiteSpaceFilter();
        }
        if (WhitespaceCollapse.PRESERVE.equals(wsColl)) {
            return new PreserveWhiteSpaceFilter();
        }
        if (WhitespaceCollapse.PRESERVE_BREAKS.equals(wsColl)) {
            return new PreserveBreaksWhiteSpaceFilter();
        }
        return new CollapseWhiteSpaceFilter();
    }

    protected GlyphClassificationProducer createGlyphClassifier(LayoutContext layoutContext) {
        CSSValue wsColl = layoutContext.getValue(TextStyleKeys.WHITE_SPACE_COLLAPSE);
        if (WhitespaceCollapse.PRESERVE.equals(wsColl)) {
            return new LinebreakClassificationProducer();
        }
        return new WhitespaceClassificationProducer();
    }

    protected BreakOpportunityProducer createBreakProducer(LayoutContext layoutContext) {
        CSSValue wordBreak = layoutContext.getValue(TextStyleKeys.TEXT_WRAP);
        if (TextWrap.NONE.equals(wordBreak)) {
            return new LineBreakProducer();
        }
        return new WordBreakProducer();
    }

    protected SpacingProducer createSpacingProducer(LayoutContext layoutContext) {
        CSSValue minValue = layoutContext.getValue(TextStyleKeys.X_MIN_LETTER_SPACING);
        CSSValue optValue = layoutContext.getValue(TextStyleKeys.X_OPTIMUM_LETTER_SPACING);
        CSSValue maxValue = layoutContext.getValue(TextStyleKeys.X_MAX_LETTER_SPACING);
        OutputProcessorMetaData outputMetaData = this.layoutProcess.getOutputMetaData();
        int minIntVal = (int)CSSValueResolverUtility.convertLengthToDouble(minValue, layoutContext, outputMetaData);
        int optIntVal = (int)CSSValueResolverUtility.convertLengthToDouble(optValue, layoutContext, outputMetaData);
        int maxIntVal = (int)CSSValueResolverUtility.convertLengthToDouble(maxValue, layoutContext, outputMetaData);
        Spacing spacing = new Spacing(minIntVal, optIntVal, maxIntVal);
        return new StaticSpacingProducer(spacing);
    }

    protected FontSizeProducer createFontSizeProducer(LayoutContext layoutContext) {
        FontSpecification fontSpecification = layoutContext.getFontSpecification();
        OutputProcessorMetaData outputMetaData = this.layoutProcess.getOutputMetaData();
        FontMetrics fontMetrics = outputMetaData.getFontMetrics(fontSpecification);
        return new VariableFontSizeProducer(fontMetrics);
    }

    protected KerningProducer createKerningProducer(LayoutContext layoutContext) {
        return new NoKerningProducer();
    }

    public RenderNode[] finishText() {
        if (this.layoutContext == null) {
            return EMPTY_TEXT;
        }
        RenderNode[] text = this.processText(new int[]{Integer.MAX_VALUE}, 0, 1);
        this.layoutContext = null;
        this.classificationProducer = null;
        this.kerningProducer = null;
        this.fontSizeProducer = null;
        this.spacingProducer = null;
        this.breakOpportunityProducer = null;
        return text;
    }

    public void startText() {
        this.startText = true;
    }

    public State saveState() throws StateException {
        return new DefaultRenderableTextFactoryState(this);
    }

    protected static class DefaultRenderableTextFactoryState
    implements State {
        private GraphemeClusterProducer clusterProducer;
        private boolean startText;
        private boolean produced;
        private FontSizeProducer fontSizeProducer;
        private KerningProducer kerningProducer;
        private SpacingProducer spacingProducer;
        private BreakOpportunityProducer breakOpportunityProducer;
        private WhiteSpaceFilter whitespaceFilter;
        private CSSValue whitespaceCollapseValue;
        private ClassificationProducer classificationProducer;
        private LanguageClassifier languageClassifier;
        private ArrayList words;
        private ArrayList glyphList;
        private long leadingMargin;
        private int lastLanguage;

        protected DefaultRenderableTextFactoryState(DefaultRenderableTextFactory factory) throws StateException {
            try {
                this.lastLanguage = factory.lastLanguage;
                this.leadingMargin = factory.leadingMargin;
                this.glyphList = (ArrayList)factory.glyphList.clone();
                this.words = (ArrayList)factory.words.clone();
                this.languageClassifier = (LanguageClassifier)factory.languageClassifier.clone();
                this.clusterProducer = (GraphemeClusterProducer)factory.clusterProducer.clone();
                this.produced = factory.produced;
                this.startText = factory.startText;
                if (factory.layoutContext != null) {
                    this.classificationProducer = (ClassificationProducer)factory.classificationProducer.clone();
                    this.whitespaceCollapseValue = factory.whitespaceCollapseValue;
                    this.whitespaceFilter = (WhiteSpaceFilter)factory.whitespaceFilter.clone();
                    this.breakOpportunityProducer = (BreakOpportunityProducer)factory.breakOpportunityProducer.clone();
                    this.spacingProducer = (SpacingProducer)factory.spacingProducer.clone();
                    this.kerningProducer = (KerningProducer)factory.kerningProducer.clone();
                    this.fontSizeProducer = (FontSizeProducer)factory.fontSizeProducer.clone();
                }
            }
            catch (CloneNotSupportedException cne) {
                throw new StateException("Failed to save state", cne);
            }
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            try {
                DefaultRenderableTextFactory factory = new DefaultRenderableTextFactory(layoutProcess, false);
                factory.dims = null;
                factory.lastLanguage = this.lastLanguage;
                factory.leadingMargin = this.leadingMargin;
                factory.glyphList = (ArrayList)this.glyphList.clone();
                factory.words = (ArrayList)this.words.clone();
                factory.languageClassifier = (LanguageClassifier)this.languageClassifier.clone();
                factory.clusterProducer = (GraphemeClusterProducer)this.clusterProducer.clone();
                factory.produced = this.produced;
                factory.startText = this.startText;
                if (factory.classificationProducer != null) {
                    factory.classificationProducer = (GlyphClassificationProducer)this.classificationProducer.clone();
                    factory.whitespaceCollapseValue = this.whitespaceCollapseValue;
                    factory.whitespaceFilter = (WhiteSpaceFilter)this.whitespaceFilter.clone();
                    factory.breakOpportunityProducer = (BreakOpportunityProducer)this.breakOpportunityProducer.clone();
                    factory.spacingProducer = (SpacingProducer)this.spacingProducer.clone();
                    factory.kerningProducer = (KerningProducer)this.kerningProducer.clone();
                    factory.fontSizeProducer = (FontSizeProducer)this.fontSizeProducer.clone();
                }
                return factory;
            }
            catch (CloneNotSupportedException cne) {
                throw new StateException("Restoring the state failed", cne);
            }
        }
    }
}

