/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process.valign;

import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.RenderableReplacedContent;
import org.jfree.layouting.renderer.process.valign.AlignContext;
import org.jfree.layouting.util.geom.StrictDimension;

public class ReplacedContentAlignContext
extends AlignContext {
    private long shift;
    private long height;

    public ReplacedContentAlignContext(RenderableReplacedContent node) {
        super(node);
        StrictDimension contentSize = node.getContentSize();
        if (RenderLength.AUTO.equals(node.getRequestedWidth())) {
            if (RenderLength.AUTO.equals(node.getRequestedHeight())) {
                this.height = contentSize.getHeight();
            } else {
                RenderLength blockContextWidth = node.getComputedLayoutProperties().getBlockContextWidth();
                this.height = node.getRequestedHeight().resolve(blockContextWidth.resolve(0L));
            }
        } else if (RenderLength.AUTO.equals(node.getRequestedHeight())) {
            if (contentSize.getWidth() > 0L) {
                RenderLength blockContextWidth = node.getComputedLayoutProperties().getBlockContextWidth();
                long computedWidth = node.getRequestedWidth().resolve(blockContextWidth.resolve(0L));
                this.height = computedWidth * contentSize.getHeight() / contentSize.getWidth();
            } else {
                this.height = 0L;
            }
        } else {
            RenderLength blockContextWidth = node.getComputedLayoutProperties().getBlockContextWidth();
            this.height = node.getRequestedHeight().resolve(blockContextWidth.resolve(0L));
        }
    }

    public long getBaselineDistance(int baseline) {
        if (baseline == 0) {
            return 0L;
        }
        if (baseline == 1) {
            return 0L;
        }
        return this.height;
    }

    public void shift(long delta) {
        this.shift += delta;
    }

    public long getAfterEdge() {
        return this.shift + this.height;
    }

    public long getBeforeEdge() {
        return this.shift;
    }
}

