/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process.layoutrules;

import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableReplacedContent;
import org.jfree.layouting.renderer.process.layoutrules.InlineSequenceElement;
import org.jfree.layouting.util.geom.StrictDimension;

public class ReplacedContentSequenceElement
implements InlineSequenceElement {
    private RenderableReplacedContent node;
    private long width;

    public ReplacedContentSequenceElement(RenderableReplacedContent node) {
        this.node = node;
        StrictDimension contentSize = node.getContentSize();
        if (RenderLength.AUTO.equals(node.getRequestedWidth())) {
            if (RenderLength.AUTO.equals(node.getRequestedHeight())) {
                this.width = contentSize.getWidth();
            } else if (contentSize.getHeight() > 0L) {
                RenderLength blockContextWidth = node.getComputedLayoutProperties().getBlockContextWidth();
                long height = node.getRequestedHeight().resolve(blockContextWidth.resolve(0L));
                this.width = height * contentSize.getWidth() / contentSize.getHeight();
            } else {
                this.width = 0L;
            }
        } else {
            RenderLength blockContextWidth = node.getComputedLayoutProperties().getBlockContextWidth();
            this.width = node.getRequestedWidth().resolve(blockContextWidth.resolve(0L));
        }
    }

    public long getMinimumWidth() {
        return this.width;
    }

    public long getMaximumWidth() {
        return Math.max(this.width, this.node.getMaximumBoxWidth());
    }

    public RenderNode getNode() {
        return this.node;
    }

    public boolean isPreserveWhitespace() {
        return false;
    }
}

