/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.NormalFlowRenderBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowInfoStructure;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.model.table.cells.TableCell;
import org.jfree.layouting.renderer.process.IterateStructuralProcessStep;

public class ValidateModelStep
extends IterateStructuralProcessStep {
    public static final int LAYOUT_OK = 0;
    public static final int NEED_MORE_DATA = 1;
    public static final int BOX_MUST_BE_CLOSED = 2;
    private Object layoutFailureNodeId;
    private int layoutFailureResolution;
    private LogicalPageBox root;

    public synchronized boolean isLayoutable(LogicalPageBox root) {
        this.layoutFailureNodeId = null;
        this.layoutFailureResolution = 0;
        this.root = root;
        this.startProcessing(root);
        this.root = null;
        return this.layoutFailureNodeId == null;
    }

    public Object getLayoutFailureNodeId() {
        return this.layoutFailureNodeId;
    }

    public int getLayoutFailureResolution() {
        return this.layoutFailureResolution;
    }

    protected void finishBlockBox(BlockRenderBox box) {
        if (this.layoutFailureNodeId != null) {
            return;
        }
        if (!box.isOpen()) {
            return;
        }
        if (box instanceof TableSectionRenderBox) {
            RenderNode node = box.getFirstChild();
            int expectedRows = 0;
            while (node != null) {
                if (!(node instanceof TableRowRenderBox)) {
                    node = node.getNext();
                    continue;
                }
                --expectedRows;
                TableRowRenderBox row = (TableRowRenderBox)node;
                TableRowInfoStructure rowInfoStructure = row.getRowInfoStructure();
                if (rowInfoStructure.isValidationDone()) {
                    int cellCount = rowInfoStructure.getCellCount();
                    for (int i = 0; i < cellCount; ++i) {
                        TableCell cellAt = rowInfoStructure.getCellAt(i);
                        expectedRows = Math.max(expectedRows, cellAt.getRowSpan() - 1);
                    }
                } else {
                    for (RenderNode nodeCell = row.getFirstChild(); nodeCell != null; nodeCell = nodeCell.getNext()) {
                        if (!(nodeCell instanceof TableCellRenderBox)) continue;
                        TableCellRenderBox cellBox = (TableCellRenderBox)nodeCell;
                        expectedRows = Math.max(expectedRows, cellBox.getRowSpan() - 1);
                    }
                }
                node = node.getNext();
            }
            if (expectedRows >= 1) {
                this.layoutFailureNodeId = box.getInstanceId();
                this.layoutFailureResolution = 1;
            }
        }
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        if (this.layoutFailureNodeId != null) {
            return false;
        }
        if (!box.isOpen()) {
            return false;
        }
        if (box instanceof TableRenderBox) {
            TableRenderBox table = (TableRenderBox)box;
            if (table.isAutoLayout()) {
                this.layoutFailureNodeId = box.getInstanceId();
                this.layoutFailureResolution = 2;
                return false;
            }
            boolean foundBodyGroup = false;
            for (RenderNode node = table.getFirstChild(); node != null; node = node.getNext()) {
                TableSectionRenderBox section;
                if (!(node instanceof TableSectionRenderBox) || !DisplayRole.TABLE_ROW_GROUP.equals((section = (TableSectionRenderBox)node).getDisplayRole())) continue;
                foundBodyGroup = true;
                boolean foundRow = false;
                for (RenderNode maybeRow = section.getVisibleFirst(); maybeRow != null; maybeRow = maybeRow.getNext()) {
                    if (!(maybeRow instanceof TableRowRenderBox)) continue;
                    if (maybeRow.isOpen()) {
                        this.layoutFailureNodeId = maybeRow.getInstanceId();
                        this.layoutFailureResolution = 2;
                        return false;
                    }
                    foundRow = true;
                }
                if (foundRow) continue;
                this.layoutFailureNodeId = box.getInstanceId();
                this.layoutFailureResolution = 1;
                return false;
            }
            if (!foundBodyGroup) {
                this.layoutFailureNodeId = box.getInstanceId();
                this.layoutFailureResolution = 1;
                return false;
            }
        } else if (box instanceof TableRowRenderBox) {
            TableRowRenderBox row = (TableRowRenderBox)box;
            TableSectionRenderBox section = (TableSectionRenderBox)row.getParent();
            if (DisplayRole.TABLE_ROW_GROUP.equals(section.getDisplayRole()) && row.getVisiblePrev() == null) {
                this.layoutFailureNodeId = box.getInstanceId();
                this.layoutFailureResolution = 2;
                return false;
            }
        } else if (box instanceof ParagraphRenderBox) {
            this.layoutFailureNodeId = box.getInstanceId();
            this.layoutFailureResolution = 2;
            return false;
        }
        return true;
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        if (this.layoutFailureNodeId != null) {
            return false;
        }
        return super.startInlineBox(box);
    }

    protected void startNormalFlow(NormalFlowRenderBox box) {
        if (this.layoutFailureNodeId != null) {
            return;
        }
        if (this.root.getContentArea() != box && box.isOpen()) {
            this.layoutFailureNodeId = box.getInstanceId();
            this.layoutFailureResolution = 2;
        }
    }
}

