/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;
import org.jfree.layouting.renderer.model.table.rows.TableRow;
import org.jfree.layouting.renderer.model.table.rows.TableRowModel;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;
import org.jfree.util.FastStack;

public class TableRowHeightStep
extends IterateVisualProcessStep {
    private FastStack tableStack = new FastStack();
    private TableInfoStructure currentTable;
    private long shiftDistance;

    public void compute(LogicalPageBox box) {
        this.tableStack.clear();
        this.currentTable = null;
        this.shiftDistance = 0L;
        this.startProcessing(box);
        this.shiftDistance = 0L;
        this.tableStack.clear();
        this.currentTable = null;
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }

    protected boolean startInlineLevelBox(RenderBox box) {
        box.setY(box.getY() + this.shiftDistance);
        return true;
    }

    protected void processInlineLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftDistance);
    }

    protected void processBlockLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftDistance);
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        box.setY(box.getY() + this.shiftDistance);
        if (box instanceof TableRenderBox) {
            TableRenderBox table = (TableRenderBox)box;
            this.currentTable = new TableInfoStructure(table);
            this.currentTable.setPosition(table.getY());
            this.tableStack.push((Object)this.currentTable);
        } else if (box instanceof TableSectionRenderBox) {
            TableSectionRenderBox sectionBox = (TableSectionRenderBox)box;
            this.currentTable.setRowModel(sectionBox.getRowModel());
        }
        return true;
    }

    protected void finishBlockLevelBox(RenderBox box) {
        if (box instanceof TableCellRenderBox) {
            TableCellRenderBox cellBox = (TableCellRenderBox)box;
            int rowSpan = cellBox.getRowSpan();
            this.currentTable.getRow().updateValidatedSize(rowSpan, 0L, cellBox.getHeight());
        } else if (box instanceof TableRowRenderBox) {
            this.currentTable.increaseRowNumber();
        } else if (box instanceof TableSectionRenderBox) {
            this.finishSection((TableSectionRenderBox)box);
            this.currentTable.setRowModel(null);
        } else if (box instanceof TableRenderBox) {
            long oldHeight = box.getHeight();
            long newHeight = this.currentTable.getPosition() - box.getY();
            box.setHeight(newHeight);
            this.tableStack.pop();
            if (!this.tableStack.isEmpty()) {
                this.currentTable = (TableInfoStructure)this.tableStack.peek();
            }
            long shift = newHeight - oldHeight;
            this.shiftDistance += shift;
        }
    }

    protected void finishSection(TableSectionRenderBox section) {
        TableRowModel rowModel = section.getRowModel();
        rowModel.validateActualSizes();
        long position = this.currentTable.getPosition();
        TableRow[] rows = rowModel.getRows();
        RenderNode rowNode = section.getFirstChild();
        boolean firstRow = true;
        while (rowNode != null) {
            if (!(rowNode instanceof TableRowRenderBox)) {
                rowNode = rowNode.getNext();
                continue;
            }
            if (!rowNode.isDirty()) {
                throw new IllegalStateException("The row is not dirty?");
            }
            TableRowRenderBox rowBox = (TableRowRenderBox)rowNode;
            int rowNumber = rowBox.getRowInfoStructure().getRowNumber();
            TableRow row = rows[rowNumber];
            long validatedRowHeight = row.getValidateSize();
            if (firstRow) {
                firstRow = false;
            } else {
                position += rowModel.getRowSpacing();
            }
            long oldPosition = rowBox.getY();
            long shift = position - oldPosition;
            if (shift < 0L) {
                throw new IllegalStateException("Shift-back is not allowed.");
            }
            this.shift(rowBox, shift);
            this.shiftDistance += shift;
            RenderNode cellNode = rowBox.getFirstChild();
            while (cellNode != null) {
                if (!(cellNode instanceof TableCellRenderBox)) {
                    cellNode = cellNode.getNext();
                    continue;
                }
                TableCellRenderBox cellBox = (TableCellRenderBox)cellNode;
                long cellShift = position - cellBox.getY();
                if (cellShift != 0L) {
                    this.shift(cellBox, cellShift);
                }
                cellBox.setHeight(validatedRowHeight);
                cellNode = cellNode.getNext();
            }
            rowBox.setHeight(validatedRowHeight);
            rowBox.setDirty(false);
            position += validatedRowHeight;
            rowNode = rowNode.getNext();
        }
        long newHeight = position - section.getY();
        long extendedHeight = newHeight - section.getHeight();
        section.setHeight(newHeight);
        if (extendedHeight != 0L) {
            for (RenderBox parent = section.getParent(); parent != null; parent = parent.getParent()) {
                parent.setHeight(parent.getHeight() + extendedHeight);
            }
            this.shiftDistance += extendedHeight;
        }
        this.currentTable.setPosition(position);
    }

    private void shift(RenderNode node, long shift) {
        if (shift == 0L) {
            return;
        }
        long y = node.getY();
        node.setY(y + shift);
        if (!(node instanceof RenderBox)) {
            return;
        }
        RenderBox box = (RenderBox)node;
        for (RenderNode child = box.getFirstChild(); child != null; child = child.getNext()) {
            this.shift(child, shift);
        }
    }

    public static class TableInfoStructure {
        private TableRenderBox table;
        private TableColumnModel columnModel;
        private TableRowModel rowModel;
        private int rowNumber;
        private long position;

        public TableInfoStructure(TableRenderBox table) {
            this.table = table;
            this.columnModel = table.getColumnModel();
        }

        public TableRow getRow() {
            return this.rowModel.getRow(this.rowNumber);
        }

        public long getPosition() {
            return this.position;
        }

        public void setPosition(long position) {
            this.position = position;
        }

        public TableRenderBox getTable() {
            return this.table;
        }

        public TableColumnModel getColumnModel() {
            return this.columnModel;
        }

        public TableRowModel getRowModel() {
            return this.rowModel;
        }

        public void setRowModel(TableRowModel rowModel) {
            this.rowModel = rowModel;
            this.rowNumber = 0;
        }

        public int getRowNumber() {
            return this.rowNumber;
        }

        public void increaseRowNumber() {
            ++this.rowNumber;
        }
    }
}

