/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.renderer.model.PageAreaRenderBox;
import org.jfree.layouting.renderer.model.ParagraphPoolBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableColumnGroupNode;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.process.BoxShifter;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;

public class SimplePaginationStep
extends IterateVisualProcessStep {
    private long shift;
    private long stickyMarker;
    private BoxShifter boxShifter = new BoxShifter();
    private long footerHeight;
    private long headerHeight;

    public void performPagebreak(LogicalPageBox pageBox) {
        this.stickyMarker = pageBox.getChangeTracker();
        this.shift = 0L;
        this.startRootProcessing(pageBox);
    }

    private void startRootProcessing(LogicalPageBox pageBox) {
        PageAreaRenderBox headerArea = pageBox.getHeaderArea();
        this.headerHeight = headerArea.getHeight();
        PageAreaRenderBox footerArea = pageBox.getFooterArea();
        this.footerHeight = footerArea.getHeight();
        this.startProcessing(pageBox);
    }

    protected boolean startInlineLevelBox(RenderBox box) {
        return false;
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        for (RenderNode node = box.getVisibleFirst(); node != null; node = node.getVisibleNext()) {
            if (!(node instanceof ParagraphPoolBox)) {
                throw new IllegalStateException("Encountered " + node.getClass());
            }
            ParagraphPoolBox inlineRenderBox = (ParagraphPoolBox)node;
            if (this.startLine(inlineRenderBox)) {
                this.processBoxChilds(inlineRenderBox);
            }
            this.finishLine(inlineRenderBox);
        }
    }

    private boolean isNodeProcessable(RenderNode node) {
        if (node.getStickyMarker() == this.stickyMarker) {
            return false;
        }
        return !node.isIgnorableForRendering();
    }

    protected void processBlockLevelNode(RenderNode node) {
        if (!this.isNodeProcessable(node)) {
            return;
        }
        node.setY(node.getY() + this.shift);
        node.setY(node.getY() + this.shift);
        node.setStickyMarker(this.stickyMarker);
    }

    protected void processTable(TableRenderBox table) {
        long originalShift = this.shift;
        long height = table.getHeight();
        long y = table.getY();
        long y2 = this.shift + y + height;
        if (table.isIgnorableForRendering()) {
            return;
        }
        table.setY(table.getY() + this.shift);
        table.setStickyMarker(this.stickyMarker);
        this.processTableSection(table, DisplayRole.TABLE_HEADER_GROUP);
        this.processTableSection(table, DisplayRole.TABLE_ROW_GROUP);
        this.processTableSection(table, DisplayRole.TABLE_FOOTER_GROUP);
        long finalHeight = table.getHeight();
        long delta = finalHeight - height;
        if (delta < 0L) {
            throw new IllegalStateException("A table can/must not shrink!");
        }
    }

    private void processTableSection(TableRenderBox box, CSSConstant role) {
        RenderNode rowGroupNode = box.getFirstChild();
        while (rowGroupNode != null) {
            if (!(rowGroupNode instanceof TableSectionRenderBox)) {
                rowGroupNode = rowGroupNode.getNext();
                continue;
            }
            TableSectionRenderBox sectionBox = (TableSectionRenderBox)rowGroupNode;
            if (!role.equals(sectionBox.getDisplayRole())) {
                rowGroupNode = rowGroupNode.getNext();
                continue;
            }
            this.startProcessing(rowGroupNode);
            rowGroupNode = rowGroupNode.getNext();
        }
    }

    protected void processBlockLevelChild(RenderNode node) {
        if (node instanceof TableRenderBox) {
            TableRenderBox table = (TableRenderBox)node;
            this.processTable(table);
        } else {
            super.processBlockLevelChild(node);
        }
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        if (!this.isNodeProcessable(box)) {
            return false;
        }
        long y = box.getY();
        if (box instanceof TableCellRenderBox) {
            box.setY(y + this.shift);
            box.setStickyMarker(this.stickyMarker);
            return true;
        }
        if (box instanceof TableColumnGroupNode) {
            throw new IllegalArgumentException("This is not expected here");
        }
        box.setY(box.getY() + this.shift);
        box.setStickyMarker(this.stickyMarker);
        return true;
    }

    protected boolean startLine(ParagraphPoolBox box) {
        if (!this.isNodeProcessable(box)) {
            return false;
        }
        this.boxShifter.shiftBox(box, this.shift);
        return false;
    }

    protected void finishLine(ParagraphPoolBox inlineRenderBox) {
    }
}

