/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import java.util.Stack;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.process.IterateStructuralProcessStep;
import org.jfree.util.FastStack;

public class ParagraphLineBreakStep
extends IterateStructuralProcessStep {
    private FastStack paragraphNesting = new FastStack();
    private ParagraphLineBreakState breakState;

    public void compute(LogicalPageBox root) {
        this.startProcessing(root);
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        if (box instanceof ParagraphRenderBox) {
            boolean unchanged;
            ParagraphRenderBox paragraphBox = (ParagraphRenderBox)box;
            boolean bl = unchanged = paragraphBox.getPool().getChangeTracker() == paragraphBox.getLineBoxAge();
            if (unchanged) {
                ParagraphRenderBox derivedParagraph = (ParagraphRenderBox)box.derive(true);
                this.breakState.getInsertationPoint().addGeneratedChild(derivedParagraph);
                ParagraphLineBreakState item = new ParagraphLineBreakState(derivedParagraph, true);
                this.paragraphNesting.push((Object)item);
                this.breakState = item;
                return false;
            }
            if (this.breakState != null) {
                if (!this.breakState.isDirty()) {
                    throw new IllegalStateException("A child cannot be dirty, if the parent is clean");
                }
                RenderBox child = (RenderBox)box.deriveFrozen(false);
                this.breakState.getInsertationPoint().addGeneratedChild(child);
                paragraphBox = (ParagraphRenderBox)child;
            }
            ParagraphLineBreakState item = new ParagraphLineBreakState(paragraphBox, false);
            this.paragraphNesting.push((Object)item);
            this.breakState = item;
        } else if (this.breakState != null && this.breakState.isDirty()) {
            RenderBox child = (RenderBox)box.deriveFrozen(false);
            this.breakState.getInsertationPoint().addGeneratedChild(child);
            this.breakState.setInsertationPoint(child);
            if (this.breakState.getSuspendItem() == null) {
                this.breakState.setSuspendItem(box.getInstanceId());
            }
        }
        return true;
    }

    protected void finishBlockBox(BlockRenderBox box) {
        if (box instanceof ParagraphRenderBox) {
            ParagraphRenderBox paraBox = (ParagraphRenderBox)box;
            paraBox.setLineBoxAge(paraBox.getPool().getChangeTracker());
            this.paragraphNesting.pop();
            this.breakState = this.paragraphNesting.isEmpty() ? null : (ParagraphLineBreakState)this.paragraphNesting.peek();
        } else if (this.breakState != null && this.breakState.isDirty()) {
            RenderBox parent = this.breakState.getInsertationPoint().getParent();
            this.breakState.setInsertationPoint(parent);
            Object suspender = this.breakState.getSuspendItem();
            if (box.getInstanceId() == suspender) {
                this.breakState.setSuspendItem(null);
            }
        }
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        if (this.breakState == null || !this.breakState.isDirty()) {
            return true;
        }
        RenderBox child = (RenderBox)box.deriveFrozen(false);
        this.breakState.getInsertationPoint().addGeneratedChild(child);
        this.breakState.setInsertationPoint(child);
        return true;
    }

    protected void finishInlineBox(InlineRenderBox box) {
        if (this.breakState == null || !this.breakState.isDirty()) {
            return;
        }
        RenderBox parent = this.breakState.getInsertationPoint().getParent();
        this.breakState.setInsertationPoint(parent);
        if (this.breakState.isBreakRequested() && box.getNext() != null) {
            this.performBreak();
        }
    }

    protected void startOtherNode(RenderNode node) {
        if (this.breakState == null || !this.breakState.isDirty()) {
            return;
        }
        if (this.breakState.getSuspendItem() != null || !(node instanceof RenderableText)) {
            RenderNode child = node.deriveFrozen(false);
            this.breakState.getInsertationPoint().addGeneratedChild(child);
            return;
        }
        RenderableText text = (RenderableText)node;
        RenderNode child = text.deriveFrozen(false);
        this.breakState.getInsertationPoint().addGeneratedChild(child);
        if (!text.isForceLinebreak()) {
            return;
        }
        if (node.getNext() == null) {
            boolean endOfLine = true;
            for (RenderBox parent = node.getParent(); parent != null && parent instanceof InlineRenderBox; parent = parent.getParent()) {
                if (parent.getNext() == null) continue;
                endOfLine = false;
                break;
            }
            if (endOfLine) {
                return;
            }
            this.breakState.setBreakRequested(true);
            return;
        }
        this.performBreak();
    }

    private void performBreak() {
        Stack<RenderBox> contexts = new Stack<RenderBox>();
        BlockRenderBox lines = this.breakState.getLines();
        for (RenderBox context = this.breakState.getInsertationPoint(); context != lines; context = context.getParent()) {
            if (!(context instanceof InlineRenderBox)) {
                throw new IllegalStateException("Confused: I expect InlineBoxes ..");
            }
            InlineRenderBox inline = (InlineRenderBox)context;
            contexts.push(inline.split(0));
        }
        this.breakState.setInsertationPoint(lines);
        while (!contexts.isEmpty()) {
            RenderBox box = (RenderBox)contexts.pop();
            this.breakState.getInsertationPoint().addGeneratedChild(box);
            this.breakState.setInsertationPoint(box);
        }
        this.breakState.setBreakRequested(false);
    }

    protected boolean startOtherBox(RenderBox box) {
        if (this.breakState == null) {
            return false;
        }
        if (!this.breakState.isDirty()) {
            return false;
        }
        if (this.breakState.getSuspendItem() == null) {
            this.breakState.setSuspendItem(box.getInstanceId());
        }
        RenderBox child = (RenderBox)box.deriveFrozen(false);
        this.breakState.getInsertationPoint().addGeneratedChild(child);
        this.breakState.setInsertationPoint(child);
        return true;
    }

    protected void finishOtherBox(RenderBox box) {
        if (this.breakState != null && this.breakState.isDirty()) {
            Object suspender = this.breakState.getSuspendItem();
            if (box.getInstanceId() == suspender) {
                this.breakState.setSuspendItem(null);
            }
            RenderBox parent = this.breakState.getInsertationPoint().getParent();
            this.breakState.setInsertationPoint(parent);
        }
    }

    private static class ParagraphLineBreakState {
        private Object suspendItem;
        private BlockRenderBox lines;
        private RenderBox insertationPoint;
        private boolean breakRequested;

        private ParagraphLineBreakState(ParagraphRenderBox paragraph, boolean readOnly) {
            if (paragraph == null) {
                throw new NullPointerException();
            }
            this.lines = paragraph.getLineboxContainer();
            if (readOnly) {
                this.insertationPoint = null;
            } else {
                this.insertationPoint = (RenderBox)paragraph.getPool().deriveFrozen(false);
                this.lines.clear();
                this.lines.addGeneratedChild(this.insertationPoint);
            }
        }

        public BlockRenderBox getLines() {
            return this.lines;
        }

        public Object getSuspendItem() {
            return this.suspendItem;
        }

        public void setSuspendItem(Object suspendItem) {
            this.suspendItem = suspendItem;
        }

        public RenderBox getInsertationPoint() {
            return this.insertationPoint;
        }

        public boolean isDirty() {
            return this.insertationPoint != null;
        }

        public void setInsertationPoint(RenderBox insertationPoint) {
            this.insertationPoint = insertationPoint;
        }

        public boolean isBreakRequested() {
            return this.breakRequested;
        }

        public void setBreakRequested(boolean breakRequested) {
            this.breakRequested = breakRequested;
        }
    }
}

