/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.NormalFlowRenderBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;

public abstract class IterateVisualProcessStep {
    protected IterateVisualProcessStep() {
    }

    protected final void startProcessing(RenderNode node) {
        RenderBox parent = node.getParent();
        if (parent == null || parent instanceof BlockRenderBox) {
            this.processBlockLevelChild(node);
        } else if (parent instanceof InlineRenderBox) {
            this.processInlineLevelChild(node);
        } else {
            this.processOtherLevelChild(node);
        }
    }

    protected void processOtherLevelChild(RenderNode node) {
    }

    protected void processInlineLevelNode(RenderNode node) {
    }

    protected boolean startInlineLevelBox(RenderBox box) {
        return true;
    }

    protected void finishInlineLevelBox(RenderBox box) {
    }

    protected void processInlineLevelChild(RenderNode node) {
        if (node instanceof ParagraphRenderBox) {
            ParagraphRenderBox box = (ParagraphRenderBox)node;
            if (this.startInlineLevelBox(box)) {
                this.processParagraphChilds(box);
            }
            this.finishInlineLevelBox(box);
        } else if (node instanceof RenderBox) {
            RenderBox box = (RenderBox)node;
            if (this.startInlineLevelBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishInlineLevelBox(box);
        } else {
            this.processInlineLevelNode(node);
        }
    }

    protected void processBlockLevelNode(RenderNode node) {
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        return true;
    }

    protected void finishBlockLevelBox(RenderBox box) {
    }

    protected void processBlockLevelChild(RenderNode node) {
        if (node instanceof LogicalPageBox) {
            LogicalPageBox box = (LogicalPageBox)node;
            if (this.startBlockLevelBox(box)) {
                this.startProcessing(box.getHeaderArea());
                this.processBoxChilds(box);
                this.startProcessing(box.getFooterArea());
            }
            this.finishBlockLevelBox(box);
        } else if (node instanceof NormalFlowRenderBox) {
            NormalFlowRenderBox box = (NormalFlowRenderBox)node;
            NormalFlowRenderBox[] flows = box.getFlows();
            for (int i = 0; i < flows.length; ++i) {
                NormalFlowRenderBox flow = flows[i];
                this.processFlow(flow);
            }
            this.processFlow(box);
        } else if (node instanceof ParagraphRenderBox) {
            ParagraphRenderBox box = (ParagraphRenderBox)node;
            if (this.startBlockLevelBox(box)) {
                this.processParagraphChilds(box);
            }
            this.finishBlockLevelBox(box);
        } else if (node instanceof RenderBox) {
            RenderBox box = (RenderBox)node;
            if (this.startBlockLevelBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishBlockLevelBox(box);
        } else {
            this.processBlockLevelNode(node);
        }
    }

    protected void processFlow(NormalFlowRenderBox flow) {
        if (this.startBlockLevelBox(flow)) {
            this.processBoxChilds(flow);
        }
        this.finishBlockLevelBox(flow);
    }

    protected abstract void processParagraphChilds(ParagraphRenderBox var1);

    protected void processBoxChilds(RenderBox box) {
        for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
            this.startProcessing(node);
        }
    }
}

