/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.NormalFlowRenderBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;

public abstract class IterateStructuralProcessStep {
    protected IterateStructuralProcessStep() {
    }

    protected void startProcessing(RenderNode node) {
        if (node instanceof InlineRenderBox) {
            InlineRenderBox box = (InlineRenderBox)node;
            if (this.startInlineBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishInlineBox(box);
        } else if (node instanceof NormalFlowRenderBox) {
            NormalFlowRenderBox box = (NormalFlowRenderBox)node;
            this.startNormalFlow(box);
            NormalFlowRenderBox[] flows = box.getFlows();
            for (int i = 0; i < flows.length; ++i) {
                NormalFlowRenderBox flow = flows[i];
                this.startProcessing(flow);
            }
            this.processBoxChilds(box);
            this.finishNormalFlow(box);
        } else if (node instanceof ParagraphRenderBox) {
            ParagraphRenderBox box = (ParagraphRenderBox)node;
            if (this.startBlockBox(box)) {
                this.processParagraphChilds(box);
            }
            this.finishBlockBox(box);
        } else if (node instanceof LogicalPageBox) {
            LogicalPageBox box = (LogicalPageBox)node;
            if (this.startBlockBox(box)) {
                this.startProcessing(box.getHeaderArea());
                this.processBoxChilds(box);
                this.startProcessing(box.getFooterArea());
            }
            this.finishBlockBox(box);
        } else if (node instanceof BlockRenderBox) {
            BlockRenderBox box = (BlockRenderBox)node;
            if (this.startBlockBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishBlockBox(box);
        } else if (node instanceof RenderBox) {
            RenderBox box = (RenderBox)node;
            this.startOtherBox(box);
            this.processBoxChilds(box);
            this.finishOtherBox(box);
        } else {
            this.startOtherNode(node);
            this.finishOtherNode(node);
        }
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box.getPool());
    }

    protected void finishNormalFlow(NormalFlowRenderBox box) {
    }

    protected void startNormalFlow(NormalFlowRenderBox box) {
    }

    protected void processBoxChilds(RenderBox box) {
        for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
            this.startProcessing(node);
        }
    }

    protected void startOtherNode(RenderNode node) {
    }

    protected void finishOtherNode(RenderNode node) {
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        return true;
    }

    protected void finishBlockBox(BlockRenderBox box) {
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        return true;
    }

    protected void finishInlineBox(InlineRenderBox box) {
    }

    protected boolean startOtherBox(RenderBox box) {
        return true;
    }

    protected void finishOtherBox(RenderBox box) {
    }
}

