/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.input.style.keys.text.TextAlign;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.FinishedRenderNode;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.ParagraphPoolBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.PlaceholderRenderNode;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableReplacedContent;
import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.model.SpacerRenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.cols.TableColumn;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;
import org.jfree.layouting.renderer.process.CenterAlignmentProcessor;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;
import org.jfree.layouting.renderer.process.LeftAlignmentProcessor;
import org.jfree.layouting.renderer.process.ParagraphBreakState;
import org.jfree.layouting.renderer.process.RightAlignmentProcessor;
import org.jfree.layouting.renderer.process.TextAlignmentProcessor;
import org.jfree.layouting.renderer.process.layoutrules.EndSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.InlineBoxSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.InlineNodeSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.InlineSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.ReplacedContentSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.SpacerSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.StartSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.TextSequenceElement;
import org.jfree.util.Log;

public class InfiniteMinorAxisLayoutStep
extends IterateVisualProcessStep {
    private ParagraphBreakState breakState;
    private PageGrid pageGrid;
    private RenderBox continuedElement;

    public void compute(LogicalPageBox root) {
        this.breakState = null;
        this.pageGrid = root.getPageGrid();
        this.startProcessing(root);
        this.pageGrid = null;
        this.breakState = null;
    }

    public void continueComputation(PageGrid pageGrid, RenderBox box) {
        if (box.getContentAreaX2() == 0L || box.getWidth() == 0L) {
            throw new IllegalStateException("Box must be layouted a bit ..");
        }
        this.pageGrid = pageGrid;
        this.breakState = null;
        this.continuedElement = box;
        this.startProcessing(box);
        this.continuedElement = null;
        this.pageGrid = null;
        this.breakState = null;
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        if (this.breakState == null) {
            if (box instanceof ParagraphRenderBox) {
                this.computeContentArea(box);
                ParagraphRenderBox paragraphBox = (ParagraphRenderBox)box;
                if (this.continuedElement == null) {
                    boolean unchanged;
                    BlockRenderBox lineboxContainer = paragraphBox.getLineboxContainer();
                    boolean bl = unchanged = lineboxContainer.getChangeTracker() == paragraphBox.getMinorLayoutAge();
                    if (unchanged) {
                        return false;
                    }
                }
                paragraphBox.clearLayout();
                this.breakState = new ParagraphBreakState(paragraphBox);
            } else if (box instanceof TableCellRenderBox) {
                this.computeCellArea((TableCellRenderBox)box);
            } else {
                this.computeContentArea(box);
                if (box instanceof TableRenderBox) {
                    this.computeCellPositions((TableRenderBox)box);
                }
            }
            return true;
        }
        if (!this.breakState.isSuspended()) {
            throw new IllegalStateException("This cannot be.");
        }
        return false;
    }

    protected void finishBlockLevelBox(RenderBox box) {
        this.verifyContentWidth(box);
        if (this.breakState != null) {
            Object suspender = this.breakState.getSuspendItem();
            if (box.getInstanceId() == suspender) {
                this.breakState.setSuspendItem(null);
                return;
            }
            if (suspender != null) {
                return;
            }
            if (box instanceof ParagraphRenderBox) {
                ParagraphRenderBox paraBox = (ParagraphRenderBox)box;
                paraBox.setMinorLayoutAge(paraBox.getLineboxContainer().getChangeTracker());
                this.breakState = null;
            }
        }
    }

    private void computeCellPositions(TableRenderBox tableBox) {
        TableColumnModel model = tableBox.getColumnModel();
        long position = 0L;
        int columnCount = model.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = model.getColumn(i);
            column.setEffectiveCellPosition(position);
            position += column.getEffectiveSize() + model.getBorderSpacing();
        }
    }

    private void computeCellArea(TableCellRenderBox cellRenderBox) {
        int columnIndex = cellRenderBox.getColumnIndex();
        TableRenderBox table = cellRenderBox.getTable();
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn column = columnModel.getColumn(columnIndex);
        long effectiveSize = column.getEffectiveSize();
        int colSpan = cellRenderBox.getColSpan();
        if (colSpan > 1) {
            for (int i = 1; i < colSpan; ++i) {
                TableColumn spannedColumn = columnModel.getColumn(columnIndex + i);
                effectiveSize += spannedColumn.getEffectiveSize();
                effectiveSize += columnModel.getBorderSpacing();
            }
        }
        long effectiveCellPosition = column.getEffectiveCellPosition();
        cellRenderBox.setX(effectiveCellPosition);
        cellRenderBox.setWidth(effectiveSize);
        ComputedLayoutProperties blp = cellRenderBox.getComputedLayoutProperties();
        long leftPadding = blp.getBorderLeft();
        cellRenderBox.setContentAreaX1(effectiveCellPosition + (leftPadding += blp.getPaddingLeft()));
        long rightPadding = blp.getBorderRight();
        long contentWidth = effectiveSize - (rightPadding += blp.getPaddingRight());
        cellRenderBox.setContentAreaX2(effectiveCellPosition + contentWidth);
    }

    private void computeContentArea(RenderBox box) {
        if (box == this.continuedElement) {
            return;
        }
        ComputedLayoutProperties blp = box.getComputedLayoutProperties();
        long x = this.computeX(box) + blp.getMarginLeft();
        box.setX(x);
        long leftPadding = blp.getBorderLeft();
        box.setContentAreaX1(x + (leftPadding += blp.getPaddingLeft()));
        RenderLength computedWidth = box.getComputedLayoutProperties().getComputedWidth();
        if (computedWidth == RenderLength.AUTO) {
            RenderBox parent = box.getParent();
            if (parent instanceof BlockRenderBox) {
                long rightPadding = blp.getMarginRight();
                rightPadding += blp.getBorderRight();
                BlockRenderBox blockParent = (BlockRenderBox)parent;
                box.setContentAreaX2(blockParent.getContentAreaX2() - (rightPadding += blp.getPaddingRight()));
            } else {
                box.setContentAreaX2(x + leftPadding + box.getMinimumChunkWidth());
            }
        } else {
            long contentWidth = computedWidth.resolve(0L);
            box.setContentAreaX2(x + leftPadding + contentWidth);
        }
    }

    private long computeX(RenderNode node) {
        RenderBox parent = node.getParent();
        if (parent == null) {
            return 0L;
        }
        return parent.getContentAreaX1();
    }

    private void verifyContentWidth(RenderBox box) {
        long x = box.getX();
        long contentEnd = box.getContentAreaX2();
        ComputedLayoutProperties blp = box.getComputedLayoutProperties();
        long boxEnd = contentEnd + blp.getBorderRight() + blp.getPaddingRight();
        box.setWidth(boxEnd - x);
    }

    protected boolean startInlineLevelBox(RenderBox box) {
        if (this.breakState == null) {
            return true;
        }
        if (this.breakState.isSuspended()) {
            return false;
        }
        if (box instanceof InlineRenderBox) {
            this.breakState.add(new StartSequenceElement((InlineRenderBox)box));
            return true;
        }
        this.computeContentArea(box);
        this.breakState.add(new InlineBoxSequenceElement(box));
        this.breakState.setSuspendItem(box.getInstanceId());
        return false;
    }

    protected void finishInlineLevelBox(RenderBox box) {
        if (this.breakState == null) {
            return;
        }
        if (this.breakState.getSuspendItem() == box.getInstanceId()) {
            this.breakState.setSuspendItem(null);
            return;
        }
        if (box instanceof InlineRenderBox) {
            this.breakState.add(new EndSequenceElement((InlineRenderBox)box));
            return;
        }
        Object suspender = this.breakState.getSuspendItem();
        if (box.getInstanceId() == suspender) {
            this.breakState.setSuspendItem(null);
            return;
        }
        if (suspender != null) {
            return;
        }
        if (box instanceof ParagraphRenderBox) {
            throw new IllegalStateException("This cannot be.");
        }
    }

    protected void processInlineLevelNode(RenderNode node) {
        if (this.breakState == null || this.breakState.isSuspended()) {
            return;
        }
        if (node instanceof FinishedRenderNode) {
            FinishedRenderNode finNode = (FinishedRenderNode)node;
            node.setWidth(finNode.getLayoutedWidth());
        }
        if (node instanceof RenderableText) {
            this.breakState.add(new TextSequenceElement((RenderableText)node));
        } else if (node instanceof RenderableReplacedContent) {
            this.breakState.add(new ReplacedContentSequenceElement((RenderableReplacedContent)node));
        } else if (node instanceof PlaceholderRenderNode) {
            this.breakState.add(new InlineNodeSequenceElement(node));
        } else if (node instanceof SpacerRenderNode) {
            if (this.breakState.isContainsContent()) {
                this.breakState.add(new SpacerSequenceElement((SpacerRenderNode)node));
            }
        } else {
            this.breakState.add(new InlineNodeSequenceElement(node));
        }
    }

    protected void processBlockLevelNode(RenderNode node) {
        long x = this.computeX(node);
        node.setX(x);
        if (node instanceof FinishedRenderNode) {
            FinishedRenderNode finNode = (FinishedRenderNode)node;
            node.setWidth(finNode.getLayoutedWidth());
        } else {
            node.setWidth(node.getComputedLayoutProperties().getComputedWidth().resolve(0L));
        }
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        BlockRenderBox lineboxContainer = box.getLineboxContainer();
        for (RenderNode node = lineboxContainer.getVisibleFirst(); node != null; node = node.getVisibleNext()) {
            if (!(node instanceof ParagraphPoolBox)) {
                throw new IllegalStateException("Expected ParagraphPoolBox elements.");
            }
            InlineRenderBox inlineRenderBox = (InlineRenderBox)node;
            this.startLine(inlineRenderBox);
            this.processBoxChilds(inlineRenderBox);
            this.finishLine(inlineRenderBox);
        }
    }

    protected void startLine(InlineRenderBox inlineRenderBox) {
        if (this.breakState == null) {
            return;
        }
        if (this.breakState.isSuspended()) {
            return;
        }
        this.breakState.clear();
        this.breakState.add(new StartSequenceElement(inlineRenderBox));
    }

    protected void finishLine(InlineRenderBox inlineRenderBox) {
        if (this.breakState == null || this.breakState.isSuspended()) {
            return;
        }
        this.breakState.add(new EndSequenceElement(inlineRenderBox));
        ParagraphRenderBox paragraph = this.breakState.getParagraph();
        CSSValue lastLineAlignment = paragraph.getLastLineAlignment();
        CSSValue textAlignment = paragraph.getTextAlignment();
        TextAlignmentProcessor processor = this.create(textAlignment, lastLineAlignment);
        InlineSequenceElement[] sequence = this.breakState.getSequence();
        if (sequence.length == 0) {
            return;
        }
        long lineStart = paragraph.getContentAreaX1();
        long lineEnd = paragraph.getContentAreaX2();
        if (lineEnd - lineStart <= 0L) {
            long minimumChunkWidth = paragraph.getMinimumChunkWidth();
            processor.initialize(sequence, lineStart, lineStart + minimumChunkWidth, this.pageGrid);
            Log.warn((Object)"Auto-Corrected zero-width linebox.");
        } else {
            processor.initialize(sequence, lineStart, lineEnd, this.pageGrid);
        }
        while (processor.hasNext()) {
            RenderNode linebox = processor.next();
            if (!(linebox instanceof ParagraphPoolBox)) {
                throw new NullPointerException("Line must not be null");
            }
            paragraph.addGeneratedChild(linebox);
        }
    }

    protected TextAlignmentProcessor create(CSSValue alignment, CSSValue lastLine) {
        if (TextAlign.CENTER.equals(alignment)) {
            return new CenterAlignmentProcessor();
        }
        if (TextAlign.RIGHT.equals(alignment)) {
            return new RightAlignmentProcessor();
        }
        return new LeftAlignmentProcessor();
    }
}

