/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.FinishedRenderNode;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.ParagraphPoolBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableReplacedContent;
import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.model.SpacerRenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;
import org.jfree.layouting.renderer.process.valign.BoxAlignContext;
import org.jfree.layouting.renderer.process.valign.InlineBlockAlignContext;
import org.jfree.layouting.renderer.process.valign.NodeAlignContext;
import org.jfree.layouting.renderer.process.valign.ReplacedContentAlignContext;
import org.jfree.layouting.renderer.process.valign.TextElementAlignContext;
import org.jfree.layouting.renderer.process.valign.VerticalAlignmentProcessor;
import org.jfree.util.FastStack;

public class InfiniteMajorAxisLayoutStep
extends IterateVisualProcessStep {
    private ParagraphBreakState breakState;
    private RenderBox continuedElement;

    public void compute(LogicalPageBox pageBox) {
        this.breakState = null;
        this.continuedElement = null;
        this.startProcessing(pageBox);
        this.breakState = null;
        this.continuedElement = null;
    }

    public void continueComputation(RenderBox box) {
        if (box.getContentAreaX2() == 0L || box.getWidth() == 0L) {
            throw new IllegalStateException("Box must be layouted a bit ..");
        }
        this.breakState = null;
        this.continuedElement = box;
        this.startProcessing(box);
        this.continuedElement = null;
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        if (box.isIgnorableForRendering()) {
            return false;
        }
        if (box != this.continuedElement) {
            this.computeYPosition(box);
        }
        if (this.breakState == null) {
            if (box instanceof ParagraphRenderBox) {
                ParagraphRenderBox paragraphBox = (ParagraphRenderBox)box;
                this.breakState = new ParagraphBreakState(paragraphBox);
            }
            return true;
        }
        if (!this.breakState.isSuspended()) {
            throw new IllegalStateException("This cannot be.");
        }
        return false;
    }

    private void computeYPosition(RenderNode node) {
        long marginTop = node.getEffectiveMarginTop();
        RenderBox parent = node.getParent();
        if (parent instanceof TableRowRenderBox) {
            node.setDirty(true);
            node.setY(parent.getY());
        } else if (parent instanceof BlockRenderBox) {
            RenderNode prev = node.getVisiblePrev();
            if (prev != null) {
                node.setDirty(true);
                node.setY(marginTop + prev.getY() + prev.getHeight());
            } else {
                ComputedLayoutProperties blp = parent.getComputedLayoutProperties();
                long insetTop = blp.getBorderTop() + blp.getPaddingTop();
                node.setDirty(true);
                node.setY(marginTop + insetTop + parent.getY());
            }
        } else if (parent != null) {
            ComputedLayoutProperties blp = parent.getComputedLayoutProperties();
            long insetTop = blp.getBorderTop() + blp.getPaddingTop();
            node.setDirty(true);
            node.setY(marginTop + insetTop + parent.getY());
        } else {
            node.setDirty(true);
            node.setY(marginTop);
        }
    }

    protected void finishBlockLevelBox(RenderBox box) {
        ComputedLayoutProperties clp = box.getComputedLayoutProperties();
        RenderLength computedWidth = clp.getComputedWidth();
        RenderLength preferredHeight = box.getBoxDefinition().getPreferredHeight();
        long computedHeight = preferredHeight.resolve(computedWidth.resolve(0L));
        ComputedLayoutProperties blp = box.getComputedLayoutProperties();
        long insetBottom = blp.getBorderBottom() + blp.getPaddingBottom();
        RenderNode lastChildNode = box.getLastChild();
        if (lastChildNode != null) {
            long childY2 = lastChildNode.getY() + lastChildNode.getHeight() + lastChildNode.getEffectiveMarginBottom();
            long effectiveHeight = childY2 - box.getY() + insetBottom;
            long height = Math.max(effectiveHeight, computedHeight);
            box.setHeight(height);
        } else {
            long insetTop = blp.getBorderTop() + blp.getBorderTop();
            box.setHeight(Math.max(computedHeight, insetTop + insetBottom));
        }
        if (this.breakState != null) {
            Object suspender = this.breakState.getSuspendItem();
            if (box.getInstanceId() == suspender) {
                this.breakState.setSuspendItem(null);
                return;
            }
            if (suspender != null) {
                return;
            }
            if (box instanceof ParagraphRenderBox) {
                ParagraphRenderBox paraBox = (ParagraphRenderBox)box;
                paraBox.setMajorLayoutAge(paraBox.getLineboxContainer().getChangeTracker());
                this.breakState = null;
            }
        }
    }

    protected boolean startInlineLevelBox(RenderBox box) {
        this.computeYPosition(box);
        this.computeBaselineInfo(box);
        if (this.breakState == null) {
            return true;
        }
        if (this.breakState.isSuspended()) {
            return false;
        }
        if (box instanceof InlineRenderBox) {
            this.breakState.openContext(new BoxAlignContext(box));
            return true;
        }
        this.breakState.getCurrentLine().addChild(new InlineBlockAlignContext(box));
        this.breakState.setSuspendItem(box.getInstanceId());
        return false;
    }

    private void computeBaselineInfo(RenderBox box) {
        for (RenderNode node = box.getVisibleFirst(); node != null; node = node.getVisibleNext()) {
            if (!(node instanceof RenderableText)) continue;
            RenderableText text = (RenderableText)node;
            box.setBaselineInfo(text.getBaselineInfo());
            break;
        }
        if (box.getBaselineInfo() == null) {
            box.setBaselineInfo(box.getNominalBaselineInfo());
        }
    }

    protected void finishInlineLevelBox(RenderBox box) {
        if (this.breakState == null) {
            return;
        }
        if (box instanceof InlineRenderBox) {
            this.breakState.closeContext();
            return;
        }
        Object suspender = this.breakState.getSuspendItem();
        if (box.getInstanceId() == suspender) {
            this.breakState.setSuspendItem(null);
            return;
        }
        if (suspender != null) {
            return;
        }
        if (box instanceof ParagraphRenderBox) {
            throw new IllegalStateException("This cannot be.");
        }
    }

    protected void processInlineLevelNode(RenderNode node) {
        this.computeYPosition(node);
        if (this.breakState == null || this.breakState.isSuspended()) {
            return;
        }
        if (node instanceof RenderableText) {
            this.breakState.getCurrentLine().addChild(new TextElementAlignContext((RenderableText)node));
        } else if (node instanceof RenderableReplacedContent) {
            this.breakState.getCurrentLine().addChild(new ReplacedContentAlignContext((RenderableReplacedContent)node));
        } else if (node instanceof SpacerRenderNode) {
            this.breakState.getCurrentLine().addChild(new NodeAlignContext(node));
        } else {
            this.breakState.getCurrentLine().addChild(new NodeAlignContext(node));
        }
    }

    protected void processBlockLevelNode(RenderNode node) {
        this.computeYPosition(node);
        if (node instanceof FinishedRenderNode) {
            FinishedRenderNode fnode = (FinishedRenderNode)node;
            node.setHeight(fnode.getLayoutedHeight());
        }
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        for (RenderNode node = box.getVisibleFirst(); node != null; node = node.getVisibleNext()) {
            if (!(node instanceof ParagraphPoolBox)) {
                throw new IllegalStateException("Encountered " + node.getClass());
            }
            ParagraphPoolBox inlineRenderBox = (ParagraphPoolBox)node;
            this.startLine(inlineRenderBox);
            this.processBoxChilds(inlineRenderBox);
            this.finishLine(inlineRenderBox);
        }
    }

    protected void startLine(ParagraphPoolBox box) {
        this.computeYPosition(box);
        if (this.breakState == null) {
            return;
        }
        if (this.breakState.isSuspended()) {
            return;
        }
        this.breakState.openContext(new BoxAlignContext(box));
    }

    protected void finishLine(ParagraphPoolBox inlineRenderBox) {
        if (this.breakState == null || this.breakState.isSuspended()) {
            return;
        }
        BoxAlignContext boxAlignContext = this.breakState.closeContext();
        VerticalAlignmentProcessor processor = new VerticalAlignmentProcessor();
        ComputedLayoutProperties blp = inlineRenderBox.getComputedLayoutProperties();
        long insetTop = blp.getBorderTop() + blp.getPaddingTop();
        long contentAreaY1 = inlineRenderBox.getY() + insetTop;
        RenderLength lineHeight = inlineRenderBox.getLineHeight();
        ComputedLayoutProperties clp = inlineRenderBox.getComputedLayoutProperties();
        RenderLength bcw = clp.getBlockContextWidth();
        processor.align(boxAlignContext, contentAreaY1, lineHeight.resolve(bcw.resolve(0L)));
    }

    protected void finishOtherBox(RenderBox box) {
        if (this.breakState != null) {
            Object suspender = this.breakState.getSuspendItem();
            if (box.getInstanceId() == suspender) {
                this.breakState.setSuspendItem(null);
            }
        }
    }

    public static class ParagraphBreakState {
        private Object suspendItem;
        private FastStack contexts;
        private ParagraphRenderBox paragraph;

        public ParagraphBreakState(ParagraphRenderBox paragraph) {
            if (paragraph == null) {
                throw new NullPointerException();
            }
            this.paragraph = paragraph;
            this.contexts = new FastStack();
        }

        public ParagraphRenderBox getParagraph() {
            return this.paragraph;
        }

        public Object getSuspendItem() {
            return this.suspendItem;
        }

        public void setSuspendItem(Object suspendItem) {
            this.suspendItem = suspendItem;
        }

        public boolean isSuspended() {
            return this.suspendItem != null;
        }

        public BoxAlignContext getCurrentLine() {
            if (this.contexts.isEmpty()) {
                return null;
            }
            return (BoxAlignContext)this.contexts.peek();
        }

        public void openContext(BoxAlignContext context) {
            if (!this.contexts.isEmpty()) {
                BoxAlignContext boxAlignContext = (BoxAlignContext)this.contexts.peek();
                boxAlignContext.addChild(context);
            }
            this.contexts.push((Object)context);
        }

        public BoxAlignContext closeContext() {
            return (BoxAlignContext)this.contexts.pop();
        }
    }
}

