/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.model.PageAreaRenderBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.process.BoxShifter;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;

public class FillPhysicalPagesStep
extends IterateVisualProcessStep {
    private long contentEnd;
    private long contentStart;

    public LogicalPageBox compute(LogicalPageBox pagebox, long pageStart, long pageEnd) {
        this.contentStart = pagebox.getHeaderArea().getHeight();
        this.contentEnd = pageEnd - pageStart + this.contentStart;
        LogicalPageBox derived = (LogicalPageBox)pagebox.derive(true);
        BoxShifter boxShifter = new BoxShifter();
        boxShifter.shiftBoxUnchecked(derived, -pageStart + this.contentStart);
        if (this.startBlockLevelBox(derived)) {
            this.processBoxChilds(derived);
        }
        this.finishBlockLevelBox(derived);
        PageAreaRenderBox footerArea = derived.getFooterArea();
        long footerPosition = pagebox.getPageHeight() - (footerArea.getY() + footerArea.getHeight());
        long footerShift = footerPosition - footerArea.getY();
        boxShifter.shiftBoxUnchecked(footerArea, footerShift);
        return derived;
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        RenderNode node = box.getFirstChild();
        while (node != null) {
            RenderNode next;
            if (node.isIgnorableForRendering()) {
                node = node.getNext();
            }
            if (node.getY() + node.getHeight() <= this.contentStart) {
                next = node.getNext();
                box.remove(node);
                node = next;
                continue;
            }
            if (node.getY() >= this.contentEnd) {
                next = node.getNext();
                box.remove(node);
                node = next;
                continue;
            }
            node = node.getNext();
        }
        return true;
    }
}

