/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.model.FinishedRenderNode;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;

public class CleanPaginatedBoxesStep
extends IterateVisualProcessStep {
    private long pageOffset;

    public void compute(LogicalPageBox pageBox) {
        this.pageOffset = pageBox.getPageOffset();
        if (this.startBlockLevelBox(pageBox)) {
            this.processBoxChilds(pageBox);
        }
        this.finishBlockLevelBox(pageBox);
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        RenderNode next;
        if (box instanceof ParagraphRenderBox) {
            return false;
        }
        if (box instanceof TableSectionRenderBox) {
            return true;
        }
        if (box instanceof TableRowRenderBox) {
            return this.startTableRow((TableRowRenderBox)box);
        }
        RenderNode node = box.getVisibleFirst();
        if (node == null) {
            return false;
        }
        if (node.isOpen()) {
            return true;
        }
        long nodeY = node.getY();
        if (nodeY + node.getHeight() > this.pageOffset) {
            return nodeY <= this.pageOffset;
        }
        RenderNode last = node;
        while ((next = last.getVisibleNext()) != null && !next.isOpen() && next.getY() + next.getHeight() <= this.pageOffset) {
            last = next;
        }
        long width = box.getContentAreaX2() - box.getContentAreaX1();
        long height = last.getY() + last.getHeight() - nodeY;
        long marginsTop = node.getEffectiveMarginTop();
        long marginsBottom = last.getEffectiveMarginBottom();
        FinishedRenderNode replacement = new FinishedRenderNode(width, height, marginsTop, marginsBottom);
        RenderNode removeNode = node;
        while (removeNode != last) {
            RenderNode next2 = removeNode.getNext();
            if (removeNode.isOpen()) {
                throw new IllegalStateException();
            }
            box.remove(removeNode);
            removeNode = next2;
        }
        if (last.isOpen()) {
            throw new IllegalStateException();
        }
        box.replaceChild(last, replacement);
        if (replacement.getParent() != box) {
            throw new IllegalStateException();
        }
        return box.getLastChild() != replacement;
    }

    private boolean startTableRow(TableRowRenderBox box) {
        return true;
    }
}

