/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.input.style.keys.line.VerticalAlign;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.process.layoutrules.EndSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.InlineSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.StartSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.TextSequenceElement;
import org.jfree.layouting.renderer.text.ExtendedBaselineInfo;

public class AlignmentCollector {
    private long offset;
    private long height;
    private long[] baselinePositions;
    private int dominantBaseline;
    private long baselineShift;

    public AlignmentCollector(long lineheight) {
        this.height = lineheight;
    }

    public long getHeight() {
        return this.height;
    }

    public long add(InlineSequenceElement sequenceElement) {
        int localBase;
        int nodeBase;
        ExtendedBaselineInfo baselineInfo;
        if (sequenceElement instanceof StartSequenceElement) {
            RenderBox box = (RenderBox)sequenceElement.getNode();
            ComputedLayoutProperties blp = box.getComputedLayoutProperties();
            this.offset = blp.getBorderTop() + blp.getPaddingTop();
            this.height = this.offset + blp.getBorderBottom() + blp.getPaddingBottom();
            return this.offset;
        }
        if (sequenceElement instanceof EndSequenceElement) {
            return this.offset;
        }
        RenderNode node = sequenceElement.getNode();
        if (sequenceElement instanceof TextSequenceElement) {
            RenderableText text = (RenderableText)node;
            baselineInfo = text.getBaselineInfo();
        } else {
            baselineInfo = null;
        }
        long preferredSize = 0L;
        if (this.baselinePositions == null) {
            this.height = Math.max(this.height, 0L);
            long delta = this.height - 0L;
            if (baselineInfo == null) {
                return delta;
            }
            this.dominantBaseline = baselineInfo.getDominantBaseline();
            this.baselinePositions = baselineInfo.getBaselines();
            if (delta > 0L) {
                this.baselineShift += delta;
            }
            return delta;
        }
        CSSValue verticalAlignment = null;
        if (baselineInfo == null || VerticalAlign.TOP.equals(verticalAlignment) || VerticalAlign.BOTTOM.equals(verticalAlignment) || VerticalAlign.MIDDLE.equals(verticalAlignment)) {
            return this.alignSimple(verticalAlignment, 0L);
        }
        if (VerticalAlign.CENTRAL.equals(verticalAlignment)) {
            nodeBase = 3;
            localBase = 3;
        } else if (VerticalAlign.TEXT_BOTTOM.equals(verticalAlignment)) {
            nodeBase = 8;
            localBase = 8;
        } else if (VerticalAlign.TEXT_TOP.equals(verticalAlignment)) {
            nodeBase = 1;
            localBase = 1;
        } else if (VerticalAlign.SUB.equals(verticalAlignment)) {
            nodeBase = 5;
            localBase = this.dominantBaseline;
        } else if (VerticalAlign.SUPER.equals(verticalAlignment)) {
            nodeBase = baselineInfo.getDominantBaseline();
            localBase = 5;
        } else if (VerticalAlign.BASELINE.equals(verticalAlignment)) {
            nodeBase = 6;
            localBase = 6;
        } else {
            nodeBase = baselineInfo.getDominantBaseline();
            localBase = baselineInfo.getDominantBaseline();
        }
        long[] baselines = baselineInfo.getBaselines();
        long myAscent = this.baselinePositions[localBase] + this.baselineShift;
        long nodeAscent = baselines[nodeBase];
        if (nodeAscent > myAscent) {
            long delta = nodeAscent - myAscent;
            this.baselineShift += delta;
        }
        if (0L > this.height) {
            this.height = 0L;
        }
        if (nodeAscent > myAscent) {
            return 0L;
        }
        return myAscent - nodeAscent;
    }

    private long alignSimple(CSSValue verticalAlignment, long preferredSize) {
        if (VerticalAlign.TOP.equals(verticalAlignment)) {
            long delta = preferredSize - this.height;
            if (delta > 0L) {
                this.baselineShift += delta;
                this.height += delta;
            }
            return 0L;
        }
        if (VerticalAlign.BOTTOM.equals(verticalAlignment)) {
            long delta = preferredSize - this.height;
            if (delta > 0L) {
                this.height += delta;
                return 0L;
            }
            return -delta;
        }
        if (VerticalAlign.MIDDLE.equals(verticalAlignment)) {
            long delta = preferredSize - this.height;
            if (delta > 0L) {
                long deltaHalf = delta / 2L;
                this.baselineShift -= deltaHalf;
                this.height += delta;
                return 0L;
            }
            return -delta / 2L;
        }
        long baselineDelta = preferredSize - (this.baselinePositions[this.dominantBaseline] + this.baselineShift);
        if (baselineDelta > 0L) {
            this.baselineShift += baselineDelta;
            this.height += baselineDelta;
            return 0L;
        }
        return -baselineDelta;
    }
}

