/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.page;

import java.util.Iterator;
import java.util.Map;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.CounterStore;
import org.jfree.layouting.renderer.StringStore;
import org.jfree.layouting.renderer.model.page.DefaultPageGrid;
import org.jfree.layouting.renderer.model.page.PageGrid;

public class RenderPageContext
implements StatefullComponent {
    private PageContext pageContext;
    private CounterStore counterStore;
    private StringStore stringStore;

    public RenderPageContext(LayoutProcess layoutProcess, PageContext pageContext) {
        if (pageContext == null) {
            throw new NullPointerException();
        }
        if (layoutProcess == null) {
            throw new NullPointerException();
        }
        this.pageContext = pageContext;
        this.counterStore = new CounterStore();
        this.stringStore = new StringStore();
        this.counterStore.add("page", new Integer(layoutProcess.getOutputProcessor().getPageCursor() + 1));
        this.counterStore.add("pages", new Integer(layoutProcess.getOutputProcessor().getLogicalPageCount()));
    }

    protected RenderPageContext() {
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public RenderPageContext update(PageContext pageContext, OutputProcessor outputProcessor) {
        RenderPageContext renderPageContext = new RenderPageContext();
        renderPageContext.pageContext = pageContext;
        renderPageContext.counterStore = (CounterStore)this.counterStore.derive();
        renderPageContext.stringStore = (StringStore)this.stringStore.derive();
        renderPageContext.counterStore.add("page", new Integer(outputProcessor.getPageCursor() + 1));
        return renderPageContext;
    }

    public RenderPageContext update(LayoutContext layoutContext) {
        Map counters = layoutContext.getCounters();
        Map strings = layoutContext.getStrings();
        Iterator counterIt = counters.entrySet().iterator();
        while (counterIt.hasNext()) {
            Map.Entry entry = counterIt.next();
            String name = (String)entry.getKey();
            Integer value = (Integer)entry.getValue();
            this.counterStore.add(name, value);
        }
        Iterator stringsIt = strings.entrySet().iterator();
        while (stringsIt.hasNext()) {
            Map.Entry entry = stringsIt.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.stringStore.add(name, value);
        }
        return this;
    }

    public PageGrid createPageGrid(OutputProcessorMetaData outputMetaData) {
        return new DefaultPageGrid(this.pageContext, outputMetaData);
    }

    public String getString(String name, CSSValue pagePolicy) {
        return this.stringStore.get(name, pagePolicy);
    }

    public Integer getCounter(String name, CSSValue pagePolicy) {
        return this.counterStore.get(name, pagePolicy);
    }

    public Object clone() {
        try {
            RenderPageContext pg = (RenderPageContext)super.clone();
            pg.counterStore = (CounterStore)this.counterStore.clone();
            pg.stringStore = (StringStore)this.stringStore.clone();
            return pg;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("Clone must be supported.");
        }
    }

    public State saveState() throws StateException {
        return new RenderPageContextState(this);
    }

    private static class RenderPageContextState
    implements State {
        private CounterStore counterStore;
        private StringStore stringStore;
        private PageContext pageContext;

        private RenderPageContextState(RenderPageContext context) throws StateException {
            try {
                this.pageContext = context.pageContext;
                this.counterStore = (CounterStore)context.counterStore.clone();
                this.stringStore = (StringStore)context.stringStore.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new StateException("Clone failed.");
            }
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            try {
                RenderPageContext rpc = new RenderPageContext();
                rpc.pageContext = this.pageContext;
                rpc.counterStore = (CounterStore)this.counterStore.clone();
                rpc.stringStore = (StringStore)this.stringStore.clone();
                rpc.counterStore.add("pages", new Integer(layoutProcess.getOutputProcessor().getLogicalPageCount()));
                return rpc;
            }
            catch (CloneNotSupportedException e) {
                throw new StateException("Clone failed.");
            }
        }
    }
}

