/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table.rows;

import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.model.table.rows.AbstractRowModel;
import org.jfree.layouting.renderer.model.table.rows.TableRow;

public class SeparateRowModel
extends AbstractRowModel {
    private long preferredSize;
    private boolean validatedSize;
    private long rowSpacing;

    public SeparateRowModel(TableSectionRenderBox tableSection) {
        super(tableSection);
    }

    public long getPreferredSize() {
        this.validateSizes();
        return this.preferredSize;
    }

    public long getRowSpacing() {
        return this.rowSpacing;
    }

    public void validateSizes() {
        if (this.validatedSize) {
            return;
        }
        int maxRowSpan = 0;
        TableRow[] rows = this.getRows();
        int rowCount = rows.length;
        for (int i = 0; i < rowCount; ++i) {
            TableRow row = rows[i];
            int cs = row.getMaximumRowSpan();
            if (cs <= maxRowSpan) continue;
            maxRowSpan = cs;
        }
        TableRenderBox table = this.getTableSection().getTable();
        this.rowSpacing = table.getRowSpacing().resolve(0L);
        this.preferredSize = (long)(rowCount - 1) * this.rowSpacing;
        long[] preferredSizes = new long[rowCount];
        for (int rowspan = 1; rowspan <= maxRowSpan; ++rowspan) {
            for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
                TableRow row = rows[rowIdx];
                long preferredSize = row.getPreferredSize(rowspan);
                this.distribute(preferredSize, preferredSizes, rowIdx, rowspan);
            }
        }
        for (int i = 0; i < rowCount; ++i) {
            this.preferredSize += preferredSizes[i];
            TableRow row = rows[i];
            row.setPreferredSize(preferredSizes[i]);
        }
        this.validatedSize = true;
    }

    public void validateActualSizes() {
        this.validateSizes();
        int maxRowSpan = 0;
        TableRow[] rows = this.getRows();
        int rowCount = rows.length;
        for (int i = 0; i < rowCount; ++i) {
            TableRow row = rows[i];
            int cs = row.getMaxValidatedRowSpan();
            if (cs <= maxRowSpan) continue;
            maxRowSpan = cs;
        }
        long[] trailingSizes = new long[rowCount];
        for (int rowspan = 1; rowspan <= maxRowSpan; ++rowspan) {
            for (int rowIdx = 0; rowIdx < trailingSizes.length; ++rowIdx) {
                TableRow row = rows[rowIdx];
                long size = row.getValidatedTrailingSize(rowspan);
                this.distribute(size, trailingSizes, rowIdx, rowspan);
            }
        }
        for (int i = 0; i < trailingSizes.length; ++i) {
            TableRow row = rows[i];
            long validateSize = trailingSizes[i] + row.getValidatedLeadingSize();
            row.setValidateSize(Math.max(row.getPreferredSize(), validateSize));
        }
    }

    private void distribute(long usedSpace, long[] allSpaces, int colIdx, int colspanX) {
        int maxColspan = Math.min(colIdx + colspanX, allSpaces.length) - colIdx;
        long usedPrev = 0L;
        int maxSize = Math.min(allSpaces.length, colIdx + maxColspan);
        for (int i = colIdx; i < maxSize; ++i) {
            usedPrev += allSpaces[i];
        }
        if (usedSpace <= usedPrev) {
            return;
        }
        long distSpace = usedSpace - usedPrev;
        long delta = distSpace / (long)maxColspan;
        for (int i = 0; i < maxColspan - 1; ++i) {
            allSpaces[colIdx + i] = delta;
        }
        allSpaces[colIdx + maxColspan - 1] = distSpace - (long)(maxColspan - 1) * delta;
    }

    public void clear() {
        TableRow[] rows = this.getRows();
        int rowCount = rows.length;
        for (int i = 0; i < rowCount; ++i) {
            TableRow row = rows[i];
            row.clear();
        }
    }
}

