/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table.cols;

import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.util.LongList;

public class TableColumn {
    private Border border;
    private RenderLength definedWidth;
    private long computedMinChunkSize;
    private long computedMaximumWidth;
    private long computedPreferredSize;
    private long effectiveSize;
    private long effectiveCellPosition;
    private LongList minimumChunkSizes;
    private LongList maximumBoxWidths;
    private LongList preferredSizes;
    private boolean autoGenerated;
    private boolean validated;

    public TableColumn(Border border, RenderLength definedWidth, boolean autoGenerated) {
        if (border == null) {
            throw new NullPointerException();
        }
        if (definedWidth == null) {
            throw new NullPointerException();
        }
        this.definedWidth = definedWidth;
        this.border = border;
        this.autoGenerated = autoGenerated;
        this.minimumChunkSizes = new LongList(10);
        this.maximumBoxWidths = new LongList(10);
        this.preferredSizes = new LongList(10);
    }

    public RenderLength getDefinedWidth() {
        return this.definedWidth;
    }

    public Border getBorder() {
        return this.border;
    }

    public long getComputedPreferredSize() {
        return this.computedPreferredSize;
    }

    public void setComputedPreferredSize(long computedPreferredSize) {
        this.computedPreferredSize = computedPreferredSize;
    }

    public long getComputedMinChunkSize() {
        return this.computedMinChunkSize;
    }

    public void setComputedMinChunkSize(long computedMinChunkSize) {
        if (this.isValidated()) {
            throw new IllegalStateException();
        }
        this.computedMinChunkSize = computedMinChunkSize;
    }

    public long getComputedMaximumWidth() {
        return this.computedMaximumWidth;
    }

    public void setComputedMaximumWidth(long computedMaximumWidth) {
        if (this.isValidated()) {
            throw new IllegalStateException();
        }
        this.computedMaximumWidth = computedMaximumWidth;
    }

    public long getEffectiveSize() {
        return this.effectiveSize;
    }

    public void setEffectiveSize(long effectiveSize) {
        this.effectiveSize = effectiveSize;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public long getMinimumChunkSize(int colspan) {
        int idx = colspan - 1;
        if (idx < this.minimumChunkSizes.size()) {
            return this.minimumChunkSizes.get(colspan - 1);
        }
        return 0L;
    }

    public long getMaximumBoxWidth(int colspan) {
        int idx = colspan - 1;
        if (idx < this.maximumBoxWidths.size()) {
            return this.maximumBoxWidths.get(colspan - 1);
        }
        return 0L;
    }

    public long getPreferredWidth(int colspan) {
        int idx = colspan - 1;
        if (idx < this.preferredSizes.size()) {
            return this.preferredSizes.get(colspan - 1);
        }
        return 0L;
    }

    public void updateMinimumChunkSize(int colspan, long chunkSize) {
        int idx = colspan - 1;
        if (this.minimumChunkSizes.size() <= idx) {
            this.minimumChunkSizes.set(idx, chunkSize);
        } else if (this.minimumChunkSizes.get(idx) < chunkSize) {
            this.minimumChunkSizes.set(idx, chunkSize);
        }
    }

    public void updateMaxBoxSize(int colspan, long colSize) {
        int idx = colspan - 1;
        if (this.maximumBoxWidths.size() <= idx) {
            this.maximumBoxWidths.set(idx, colSize);
        } else if (this.maximumBoxWidths.get(idx) < colSize) {
            this.maximumBoxWidths.set(idx, colSize);
        }
    }

    public void updatePreferredSize(int colspan, long colSize) {
        int idx = colspan - 1;
        if (this.preferredSizes.size() <= idx) {
            this.preferredSizes.set(idx, colSize);
        } else if (this.preferredSizes.get(idx) < colSize) {
            this.preferredSizes.set(idx, colSize);
        }
    }

    public int getMaxColspan() {
        return this.maximumBoxWidths.size();
    }

    public long getEffectiveCellPosition() {
        return this.effectiveCellPosition;
    }

    public void setEffectiveCellPosition(long effectiveCellPosition) {
        this.effectiveCellPosition = effectiveCellPosition;
    }
}

