/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table.cols;

import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.cols.AbstractColumnModel;
import org.jfree.layouting.renderer.model.table.cols.TableColumn;

public class SpearateColumnModel
extends AbstractColumnModel {
    private long validationTrack;
    private long preferredSize;
    private long maxBoxSize;
    private long minimumChunkSize;
    private long borderSpacing;

    public void validateSizes(TableRenderBox table) {
        long totalBorderSpacing;
        if (this.isValidated() && this.validationTrack == table.getChangeTracker()) {
            return;
        }
        int maxColSpan = 0;
        TableColumn[] columns = this.getColumns();
        int colCount = columns.length;
        for (int i = 0; i < colCount; ++i) {
            TableColumn column = columns[i];
            int cs = column.getMaxColspan();
            if (cs <= maxColSpan) continue;
            maxColSpan = cs;
        }
        if (colCount == 0) {
            this.validationTrack = table.getChangeTracker();
            return;
        }
        ComputedLayoutProperties nlp = table.getComputedLayoutProperties();
        RenderLength blockContextWidth = nlp.getBlockContextWidth();
        long bcw = blockContextWidth.resolve(0L);
        RenderLength borderSpacingLength = table.getBorderSpacing();
        this.borderSpacing = borderSpacingLength.resolve(bcw);
        this.minimumChunkSize = totalBorderSpacing = (long)(colCount - 1) * this.borderSpacing;
        this.maxBoxSize = totalBorderSpacing;
        this.preferredSize = totalBorderSpacing;
        long[] minChunkSizes = new long[colCount];
        long[] maxBoxSizes = new long[colCount];
        long[] preferredSizes = new long[colCount];
        for (int colIdx = 0; colIdx < minChunkSizes.length; ++colIdx) {
            TableColumn column = columns[colIdx];
            long minimumChunkSize = column.getMinimumChunkSize(1);
            long maxBoxSize = column.getMaximumBoxWidth(1);
            long resolvedColWidth = column.getDefinedWidth().resolve(bcw);
            long preferredSize = Math.max(resolvedColWidth, column.getPreferredWidth(1));
            minChunkSizes[colIdx] = minimumChunkSize;
            maxBoxSizes[colIdx] = maxBoxSize;
            preferredSizes[colIdx] = preferredSize;
        }
        for (int colspan = 2; colspan <= maxColSpan; ++colspan) {
            for (int colIdx = 0; colIdx < minChunkSizes.length; ++colIdx) {
                TableColumn column = columns[colIdx];
                long minimumChunkSize = column.getMinimumChunkSize(colspan);
                long maxBoxSize = column.getMaximumBoxWidth(colspan);
                long preferredSize = column.getPreferredWidth(colspan);
                this.distribute(minimumChunkSize, minChunkSizes, colIdx, colspan);
                this.distribute(preferredSize, preferredSizes, colIdx, colspan);
                this.distribute(maxBoxSize, maxBoxSizes, colIdx, colspan);
            }
        }
        for (int i = 0; i < minChunkSizes.length; ++i) {
            TableColumn column = columns[i];
            long cmin = minChunkSizes[i];
            long cpref = preferredSizes[i];
            long cmax = maxBoxSizes[i];
            long width = Math.max(cmin, cpref);
            this.minimumChunkSize += cmin;
            this.preferredSize += width;
            this.maxBoxSize += cmax;
            if (column.isValidated()) continue;
            column.setComputedPreferredSize(cpref);
            column.setComputedMinChunkSize(cmin);
            column.setComputedMaximumWidth(cmax);
            column.setEffectiveSize(width);
            column.setValidated(true);
        }
        RenderLength tableCWidth = table.getComputedLayoutProperties().getComputedWidth();
        if (tableCWidth != RenderLength.AUTO) {
            long tableSize = Math.max(tableCWidth.resolve(0L), this.minimumChunkSize);
            long extraSpace = tableSize - this.preferredSize;
            long extraSpacePerCol = extraSpace / (long)minChunkSizes.length;
            for (int i = 0; i < minChunkSizes.length; ++i) {
                TableColumn column = columns[i];
                long colSize = column.getEffectiveSize() + extraSpacePerCol;
                column.setEffectiveSize(colSize);
            }
            this.preferredSize = tableSize;
        }
        this.validationTrack = table.getChangeTracker();
    }

    public long getPreferredSize() {
        return this.preferredSize;
    }

    public long getMaximumBoxSize() {
        return this.maxBoxSize;
    }

    public long getMinimumChunkSize() {
        return this.minimumChunkSize;
    }

    private void distribute(long usedSpace, long[] allSpaces, int colIdx, int colspan) {
        int maxColspan = Math.min(colIdx + colspan, allSpaces.length) - colIdx;
        int maxSize = Math.min(allSpaces.length, colIdx + maxColspan);
        long usedPrev = 0L;
        for (int i = colIdx; i < maxSize; ++i) {
            usedPrev += allSpaces[i];
        }
        if (usedSpace <= usedPrev) {
            return;
        }
        long distSpace = usedSpace - usedPrev;
        long delta = distSpace / (long)maxColspan;
        for (int i = 0; i < maxColspan - 1; ++i) {
            allSpaces[colIdx + i] = delta;
        }
        allSpaces[colIdx + maxColspan - 1] = distSpace - (long)(maxColspan - 1) * delta;
    }

    public long getBorderSpacing() {
        return this.borderSpacing;
    }
}

