/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table.cols;

import java.util.ArrayList;
import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.table.cols.TableColumn;
import org.jfree.layouting.renderer.model.table.cols.TableColumnGroup;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;

public abstract class AbstractColumnModel
implements TableColumnModel {
    private boolean validated;
    private boolean incrementalModeSupported = true;
    private ArrayList columnGroups = new ArrayList();
    private TableColumn[] columns = null;

    public void addColumnGroup(TableColumnGroup column) {
        this.columnGroups.add(column);
        column.freeze();
        this.validated = false;
    }

    public void addAutoColumn() {
        TableColumnGroup autoGroup = new TableColumnGroup();
        TableColumn column = new TableColumn(Border.createEmptyBorder(), RenderLength.AUTO, true);
        autoGroup.addColumn(column);
        autoGroup.freeze();
        this.columnGroups.add(autoGroup);
        this.validated = false;
    }

    public boolean isIncrementalModeSupported() {
        return this.incrementalModeSupported;
    }

    public int getColumnGroupCount() {
        return this.columnGroups.size();
    }

    public int getColumnCount() {
        this.buildColumns();
        return this.columns.length;
    }

    private void buildColumns() {
        if (this.validated) {
            return;
        }
        ArrayList<TableColumn> cols = new ArrayList<TableColumn>();
        for (int i = 0; i < this.columnGroups.size(); ++i) {
            TableColumnGroup node = (TableColumnGroup)this.columnGroups.get(i);
            int count = node.getColumnCount();
            for (int x = 0; x < count; ++x) {
                TableColumn column = node.getColumn(x);
                cols.add(column);
            }
        }
        this.columns = cols.toArray(new TableColumn[cols.size()]);
        this.validated = true;
    }

    public TableColumnGroup getColumnGroup(int i) {
        return (TableColumnGroup)this.columnGroups.get(i);
    }

    public TableColumn getColumn(int i) {
        this.buildColumns();
        return this.columns[i];
    }

    public TableColumn[] getColumns() {
        this.buildColumns();
        return this.columns;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public long getBorderSpacing() {
        return 0L;
    }

    public TableColumnGroup getGroupForIndex(int idx) {
        int offset = 0;
        for (int j = 0; j < this.columnGroups.size(); ++j) {
            TableColumnGroup group = (TableColumnGroup)this.columnGroups.get(j);
            if (offset + group.getColumnCount() <= idx) {
                offset += group.getColumnCount();
                continue;
            }
            return group;
        }
        throw new IndexOutOfBoundsException("No such group");
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractColumnModel cm = (AbstractColumnModel)super.clone();
        cm.columns = null;
        cm.validated = false;
        cm.columnGroups = (ArrayList)this.columnGroups.clone();
        return cm;
    }
}

