/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table;

import org.jfree.layouting.input.style.keys.table.BorderCollapse;
import org.jfree.layouting.input.style.keys.table.EmptyCells;
import org.jfree.layouting.input.style.keys.table.TableLayout;
import org.jfree.layouting.input.style.keys.table.TableStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.DefaultBoxDefinitionFactory;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.table.TableLayoutInfo;
import org.jfree.layouting.renderer.model.table.cols.SpearateColumnModel;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;

public class TableRenderBox
extends BlockRenderBox {
    private TableColumnModel columnModel = new SpearateColumnModel();
    private boolean needsPruning;
    private TableLayoutInfo tableInfo = new TableLayoutInfo();
    private boolean structureValidated;
    private boolean predefinedColumnsValidated;

    public TableRenderBox(BoxDefinition boxDefinition) {
        super(boxDefinition);
        this.tableInfo.setBorderSpacing(RenderLength.EMPTY);
    }

    public void appyStyle(LayoutContext layoutContext, OutputProcessorMetaData metaData) {
        super.appyStyle(layoutContext, metaData);
        CSSValue emptyCellsVal = layoutContext.getValue(TableStyleKeys.EMPTY_CELLS);
        this.tableInfo.setDisplayEmptyCells(EmptyCells.SHOW.equals(emptyCellsVal));
        CSSValue borderModel = layoutContext.getValue(TableStyleKeys.BORDER_COLLAPSE);
        this.tableInfo.setCollapsingBorderModel(BorderCollapse.COLLAPSE.equals(borderModel));
        CSSValue layoutModel = layoutContext.getValue(TableStyleKeys.TABLE_LAYOUT);
        this.tableInfo.setAutoLayout(TableLayout.AUTO.equals(layoutModel));
        CSSValue borderSpacingVal = layoutContext.getValue(TableStyleKeys.BORDER_SPACING);
        if (borderSpacingVal instanceof CSSValuePair) {
            CSSValuePair borderSpacingPair = (CSSValuePair)borderSpacingVal;
            this.tableInfo.setRowSpacing(DefaultBoxDefinitionFactory.computeWidth(borderSpacingPair.getFirstValue(), layoutContext, metaData, false, false));
            this.tableInfo.setBorderSpacing(DefaultBoxDefinitionFactory.computeWidth(borderSpacingPair.getSecondValue(), layoutContext, metaData, false, false));
        } else {
            this.tableInfo.setBorderSpacing(RenderLength.EMPTY);
            this.tableInfo.setRowSpacing(RenderLength.EMPTY);
        }
    }

    public boolean isPredefinedColumnsValidated() {
        return this.predefinedColumnsValidated;
    }

    public void setPredefinedColumnsValidated(boolean predefinedColumnsValidated) {
        this.predefinedColumnsValidated = predefinedColumnsValidated;
    }

    public boolean isStructureValidated() {
        return this.structureValidated;
    }

    public void setStructureValidated(boolean structureValidated) {
        this.structureValidated = structureValidated;
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public void addChild(RenderNode child) {
        super.addChild(child);
        this.needsPruning = true;
    }

    public boolean isLayoutable() {
        return this.columnModel.isIncrementalModeSupported();
    }

    public RenderLength getBorderSpacing() {
        return this.tableInfo.getBorderSpacing();
    }

    public RenderLength getRowSpacing() {
        return this.tableInfo.getRowSpacing();
    }

    public boolean isDisplayEmptyCells() {
        return this.tableInfo.isDisplayEmptyCells();
    }

    public boolean isCollapsingBorderModel() {
        return this.tableInfo.isCollapsingBorderModel();
    }

    public boolean isAutoLayout() {
        return this.tableInfo.isAutoLayout();
    }

    public Object clone() {
        try {
            TableRenderBox box = (TableRenderBox)super.clone();
            if (!box.isStructureValidated()) {
                box.columnModel = (TableColumnModel)this.columnModel.clone();
            }
            return box;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed for some reason.");
        }
    }
}

