/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.page;

import org.jfree.layouting.input.style.PageAreaType;
import org.jfree.layouting.input.style.keys.page.PageStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.jfree.layouting.renderer.model.page.PhysicalPageBox;

public class DefaultPageGrid
implements PageGrid {
    private int rows;
    private int columns;
    private PhysicalPageBox[] pages;

    public DefaultPageGrid(PageContext pageContext, OutputProcessorMetaData metaData) {
        LayoutStyle areaDefinition = pageContext.getAreaDefinition(PageAreaType.CONTENT);
        CSSValue hspanValue = areaDefinition.getValue(PageStyleKeys.HORIZONTAL_PAGE_SPAN);
        CSSValue vspanValue = areaDefinition.getValue(PageStyleKeys.VERTICAL_PAGE_SPAN);
        this.columns = Math.max(1, (int)CSSValueResolverUtility.getNumericValue(hspanValue, metaData.getHorizontalPageSpan()));
        this.rows = Math.max(1, (int)CSSValueResolverUtility.getNumericValue(vspanValue, metaData.getVerticalPageSpan()));
        this.pages = new PhysicalPageBox[this.rows * this.columns];
        long globalY = 0L;
        for (int row = 0; row < this.rows; ++row) {
            long globalX = 0L;
            long lastHeight = 0L;
            for (int col = 0; col < this.columns; ++col) {
                PhysicalPageBox ppb;
                this.pages[row * this.columns + col] = ppb = new PhysicalPageBox(pageContext, metaData, globalX, globalY);
                globalX += ppb.getImageableWidth();
                lastHeight = ppb.getImageableHeight();
            }
            globalY += lastHeight;
        }
    }

    public PhysicalPageBox getPage(int row, int col) {
        return this.pages[row * this.rows + col];
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    public Object clone() {
        try {
            DefaultPageGrid o = (DefaultPageGrid)super.clone();
            o.pages = (PhysicalPageBox[])this.pages.clone();
            for (int i = 0; i < this.pages.length; ++i) {
                PhysicalPageBox page = this.pages[i];
                o.pages[i] = (PhysicalPageBox)page.clone();
            }
            return o;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }
}

