/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model;

import org.jfree.fonts.registry.FontMetrics;
import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.keys.page.PageBreak;
import org.jfree.layouting.input.style.keys.page.PageStyleKeys;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.keys.text.WhitespaceCollapse;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.BoxLayoutProperties;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.StaticBoxLayoutProperties;
import org.jfree.layouting.renderer.text.ExtendedBaselineInfo;
import org.jfree.layouting.renderer.text.TextUtility;

public abstract class RenderBox
extends RenderNode {
    public static final boolean LOG_PRUNE = false;
    private RenderNode firstChild;
    private RenderNode lastChild;
    private boolean open;
    private PageContext pageContext;
    private BoxLayoutProperties boxLayoutProperties;
    private StaticBoxLayoutProperties staticBoxLayoutProperties;
    private long contentAreaX1;
    private long contentAreaX2;
    private BoxDefinition boxDefinition;
    private int lineCount;
    private ExtendedBaselineInfo baselineInfo;
    private long widowsSize;
    private long orphansSize;

    public RenderBox(BoxDefinition boxDefinition) {
        if (boxDefinition == null) {
            throw new NullPointerException("BoxDefinition must not be null");
        }
        this.boxDefinition = boxDefinition;
        this.open = true;
        this.staticBoxLayoutProperties = new StaticBoxLayoutProperties();
    }

    public StaticBoxLayoutProperties getStaticBoxLayoutProperties() {
        return this.staticBoxLayoutProperties;
    }

    public void appyStyle(LayoutContext context, OutputProcessorMetaData metaData) {
        super.appyStyle(context, metaData);
        this.staticBoxLayoutProperties.setPreserveSpace(WhitespaceCollapse.PRESERVE.equals(context.getValue(TextStyleKeys.WHITE_SPACE_COLLAPSE)));
        this.staticBoxLayoutProperties.setDominantBaseline(context.getValue(LineStyleKeys.DOMINANT_BASELINE));
        FontSpecification fontSpecification = context.getFontSpecification();
        FontMetrics fontMetrics = metaData.getFontMetrics(fontSpecification);
        this.staticBoxLayoutProperties.setNominalBaselineInfo(TextUtility.createBaselineInfo(120, fontMetrics));
        CSSValue widowsValue = context.getValue(PageStyleKeys.WIDOWS);
        this.staticBoxLayoutProperties.setWidows(Math.max(1, (int)CSSValueResolverUtility.getNumericValue(widowsValue, 0.0)));
        CSSValue orphansValue = context.getValue(PageStyleKeys.ORPHANS);
        this.staticBoxLayoutProperties.setOrphans(Math.max(1, (int)CSSValueResolverUtility.getNumericValue(orphansValue, 0.0)));
        CSSValue pageBreak = context.getValue(PageStyleKeys.PAGE_BREAK_INSIDE);
        this.staticBoxLayoutProperties.setAvoidPagebreakInside(PageBreak.AVOID.equals(pageBreak));
    }

    public long getWidowsSize() {
        return this.widowsSize;
    }

    public void setWidowsSize(long widowsSize) {
        this.widowsSize = widowsSize;
    }

    public long getOrphansSize() {
        return this.orphansSize;
    }

    public void setOrphansSize(long orphansSize) {
        this.orphansSize = orphansSize;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    public int getWidows() {
        return this.staticBoxLayoutProperties.getWidows();
    }

    public int getOrphans() {
        return this.staticBoxLayoutProperties.getOrphans();
    }

    public boolean isAvoidPagebreakInside() {
        return this.staticBoxLayoutProperties.isAvoidPagebreakInside();
    }

    public ExtendedBaselineInfo getBaselineInfo() {
        return this.baselineInfo;
    }

    public void setBaselineInfo(ExtendedBaselineInfo baselineInfo) {
        this.baselineInfo = baselineInfo;
    }

    public ExtendedBaselineInfo getNominalBaselineInfo() {
        return this.staticBoxLayoutProperties.getNominalBaselineInfo();
    }

    public CSSValue getDominantBaseline() {
        return this.staticBoxLayoutProperties.getDominantBaseline();
    }

    public boolean isPreserveSpace() {
        return this.staticBoxLayoutProperties.isPreserveSpace();
    }

    public BoxDefinition getBoxDefinition() {
        return this.boxDefinition;
    }

    public RenderNode getFirstChild() {
        return this.firstChild;
    }

    protected void setFirstChild(RenderNode firstChild) {
        this.firstChild = firstChild;
    }

    public RenderNode getLastChild() {
        return this.lastChild;
    }

    protected void setLastChild(RenderNode lastChild) {
        this.lastChild = lastChild;
    }

    public void addGeneratedChild(RenderNode child) {
        if (child == null) {
            throw new NullPointerException("Child to be added must not be null.");
        }
        if (this.isHibernated()) {
            throw new IllegalStateException("Check your state management, you've messed with an hibernated element.");
        }
        if (this.lastChild != null) {
            this.lastChild.setNext(child);
        }
        child.setPrev(this.lastChild);
        child.setNext(null);
        this.lastChild = child;
        if (this.firstChild == null) {
            this.firstChild = child;
        }
        child.setParent(this);
        if (this.isFrozen()) {
            child.freeze();
        }
        child.updateChangeTracker();
    }

    public void addChild(RenderNode child) {
        if (child == null) {
            throw new NullPointerException("Child to be added must not be null.");
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Adding content to an already closed element.");
        }
        if (this.isHibernated()) {
            throw new IllegalStateException("Check your state management. You tried to modify a hibernated element.");
        }
        if (this.lastChild != null) {
            this.lastChild.setNext(child);
        }
        child.setPrev(this.lastChild);
        child.setNext(null);
        this.lastChild = child;
        if (this.firstChild == null) {
            this.firstChild = child;
        }
        child.setParent(this);
        if (this.isFrozen()) {
            child.freeze();
        }
        child.updateChangeTracker();
    }

    protected void insertAfter(RenderNode node, RenderNode target) {
        if (node == null) {
            RenderNode firstChild = this.getFirstChild();
            if (firstChild == null) {
                this.setLastChild(target);
                this.setFirstChild(target);
                target.setParent(this);
                target.setPrev(null);
                target.setNext(null);
                target.updateChangeTracker();
                return;
            }
            firstChild.setPrev(target);
            this.setFirstChild(target);
            target.setParent(this);
            target.setPrev(null);
            target.setNext(firstChild);
            target.updateChangeTracker();
            return;
        }
        if (node.getParent() != this) {
            throw new IllegalStateException("You made a big boo");
        }
        RenderNode next = node.getNext();
        node.setNext(target);
        target.setPrev(node);
        target.setParent(this);
        target.setNext(next);
        if (next != null) {
            next.setPrev(target);
        } else {
            this.setLastChild(target);
        }
        target.updateChangeTracker();
    }

    protected void insertBefore(RenderNode node, RenderNode target) {
        if (node == null) {
            RenderNode lastChild = this.getLastChild();
            if (lastChild == null) {
                target.setParent(this);
                target.setPrev(null);
                target.setNext(null);
                this.setFirstChild(target);
                this.setLastChild(target);
                target.updateChangeTracker();
                return;
            }
            this.setLastChild(target);
            target.setParent(this);
            target.setPrev(lastChild);
            target.setNext(null);
            lastChild.setNext(target);
            target.updateChangeTracker();
            return;
        }
        if (node.getParent() != this) {
            throw new IllegalStateException("You made a big boo");
        }
        RenderNode prev = node.getPrev();
        node.setPrev(target);
        target.setNext(node);
        target.setParent(this);
        target.setPrev(prev);
        if (prev != null) {
            prev.setNext(target);
        } else {
            this.setFirstChild(target);
        }
        target.updateChangeTracker();
    }

    public void replaceChild(RenderNode old, RenderNode replacement) {
        if (old.getParent() != this) {
            throw new IllegalArgumentException("None of my childs.");
        }
        if (old == replacement) {
            return;
        }
        boolean changed = false;
        if (old == this.firstChild) {
            replacement.setNext(this.firstChild.getNext());
            replacement.setPrev(null);
            this.firstChild.setNext(null);
            this.firstChild.setPrev(null);
            this.firstChild = replacement;
            replacement.setParent(this);
            changed = true;
        }
        if (old == this.lastChild) {
            replacement.setPrev(this.lastChild.getPrev());
            replacement.setNext(null);
            this.lastChild.setNext(null);
            this.lastChild.setPrev(null);
            this.lastChild = replacement;
            replacement.setParent(this);
            changed = true;
        }
        if (changed) {
            old.updateChangeTracker();
            replacement.updateChangeTracker();
            return;
        }
        RenderNode prev = old.getPrev();
        RenderNode next = old.getNext();
        replacement.setPrev(prev);
        replacement.setNext(next);
        if (prev != null) {
            prev.setNext(replacement);
        }
        if (next != null) {
            next.setPrev(replacement);
        }
        replacement.setParent(this);
        old.updateChangeTracker();
        replacement.updateChangeTracker();
    }

    public void replaceChilds(RenderNode old, RenderNode[] replacement) {
        int i;
        if (old.getParent() != this) {
            throw new IllegalArgumentException("None of my childs.");
        }
        if (replacement.length == 0) {
            throw new IndexOutOfBoundsException("Array is empty ..");
        }
        if (old == replacement[0]) {
            if (replacement.length == 1) {
                return;
            }
            throw new IllegalArgumentException("Thou shall not use the replace method to insert new elements!");
        }
        RenderNode first = null;
        RenderNode last = null;
        for (i = 0; i < replacement.length; ++i) {
            if (last == null) {
                last = replacement[i];
                if (last == null) continue;
                first = last;
                first.setParent(this);
                continue;
            }
            RenderNode node = replacement[i];
            last.setNext(node);
            node.setPrev(last);
            node.setParent(this);
            last = node;
        }
        if (first == null) {
            throw new IndexOutOfBoundsException("Array is empty (NullValues stripped)..");
        }
        if (old == this.firstChild) {
            RenderNode second = this.firstChild.getNext();
            last.setNext(second);
            first.setPrev(null);
            if (second != null) {
                second.setPrev(last);
            } else {
                this.lastChild = last;
            }
            this.firstChild.setNext(null);
            this.firstChild.setPrev(null);
            this.firstChild = first;
            old.updateChangeTracker();
            for (int i2 = 0; i2 < replacement.length; ++i2) {
                RenderNode renderNode = replacement[i2];
                renderNode.updateChangeTracker();
            }
            return;
        }
        if (old == this.lastChild) {
            first.setPrev(this.lastChild.getPrev());
            last.setNext(null);
            this.lastChild.setNext(null);
            this.lastChild.setPrev(null);
            this.lastChild = last;
            for (i = 0; i < replacement.length; ++i) {
                RenderNode renderNode = replacement[i];
                renderNode.updateChangeTracker();
            }
            return;
        }
        RenderNode prev = old.getPrev();
        RenderNode next = old.getNext();
        first.setPrev(prev);
        last.setNext(next);
        if (prev != null) {
            prev.setNext(first);
        }
        if (next != null) {
            next.setPrev(last);
        }
        for (int i3 = 0; i3 < replacement.length; ++i3) {
            RenderNode renderNode = replacement[i3];
            renderNode.updateChangeTracker();
        }
    }

    public Object clone() {
        try {
            RenderBox renderBox = (RenderBox)super.clone();
            if (this.boxLayoutProperties != null) {
                renderBox.boxLayoutProperties = (BoxLayoutProperties)this.boxLayoutProperties.clone();
            }
            return renderBox;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public RenderNode derive(boolean deepDerive) {
        RenderBox box = (RenderBox)super.derive(deepDerive);
        if (deepDerive) {
            RenderNode currentNode = null;
            for (RenderNode node = this.firstChild; node != null; node = node.getNext()) {
                RenderNode previous = currentNode;
                currentNode = node.derive(true);
                currentNode.setParent(box);
                if (previous == null) {
                    box.firstChild = currentNode;
                    currentNode.setPrev(null);
                    continue;
                }
                previous.setNext(currentNode);
                currentNode.setPrev(previous);
            }
            box.lastChild = currentNode;
            if (this.lastChild != null) {
                box.lastChild.setNext(null);
            }
        } else {
            box.firstChild = null;
            box.lastChild = null;
        }
        return box;
    }

    public RenderNode hibernate() {
        RenderBox box = (RenderBox)super.hibernate();
        RenderNode currentNode = null;
        for (RenderNode node = this.firstChild; node != null; node = node.getNext()) {
            RenderNode previous = currentNode;
            currentNode = node.hibernate();
            currentNode.setParent(box);
            if (previous == null) {
                box.firstChild = currentNode;
                currentNode.setPrev(null);
                continue;
            }
            previous.setNext(currentNode);
            currentNode.setPrev(previous);
        }
        box.lastChild = currentNode;
        if (this.lastChild != null) {
            box.lastChild.setNext(null);
        }
        return box;
    }

    public RenderNode deriveFrozen(boolean deepDerive) {
        RenderBox box = (RenderBox)super.deriveFrozen(deepDerive);
        if (deepDerive) {
            RenderNode currentNode = null;
            for (RenderNode node = this.firstChild; node != null; node = node.getNext()) {
                RenderNode previous = currentNode;
                currentNode = node.deriveFrozen(true);
                currentNode.setParent(box);
                if (previous == null) {
                    box.firstChild = currentNode;
                    currentNode.setPrev(null);
                    continue;
                }
                previous.setNext(currentNode);
                currentNode.setPrev(previous);
            }
            box.lastChild = currentNode;
            if (this.lastChild != null) {
                box.lastChild.setNext(null);
            }
        } else {
            box.firstChild = null;
            box.lastChild = null;
        }
        return box;
    }

    public void addChilds(RenderNode[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            this.addChild(nodes[i]);
        }
    }

    public RenderNode findNodeById(Object instanceId) {
        if (instanceId == this.getInstanceId()) {
            return this;
        }
        for (RenderNode child = this.getLastChild(); child != null; child = child.getPrev()) {
            RenderNode nodeById = child.findNodeById(instanceId);
            if (nodeById == null) continue;
            return nodeById;
        }
        return null;
    }

    public boolean isAppendable() {
        return this.isOpen();
    }

    public RenderBox getInsertationPoint() {
        RenderBox lcBox;
        if (!this.isAppendable()) {
            throw new IllegalStateException("Already closed");
        }
        RenderNode lastChild = this.getLastChild();
        if (lastChild instanceof RenderBox && (lcBox = (RenderBox)lastChild).isAppendable()) {
            return lcBox.getInsertationPoint();
        }
        return this;
    }

    public Border getBorder() {
        return this.boxDefinition.getBorder();
    }

    public void clear() {
        RenderNode child = this.getFirstChild();
        while (child != null) {
            RenderNode nextChild = child.getNext();
            if (child != this.getFirstChild()) {
                child.getPrev().setNext(null);
            }
            child.setPrev(null);
            child.setParent(null);
            child = nextChild;
        }
        this.setFirstChild(null);
        this.setLastChild(null);
        this.updateChangeTracker();
    }

    public RenderNode getVisibleFirst() {
        for (RenderNode firstChild = this.getFirstChild(); firstChild != null; firstChild = firstChild.getNext()) {
            if (firstChild.isIgnorableForRendering()) continue;
            return firstChild;
        }
        return null;
    }

    public RenderNode getVisibleLast() {
        for (RenderNode lastChild = this.getLastChild(); lastChild != null; lastChild = lastChild.getPrev()) {
            if (lastChild.isIgnorableForRendering()) continue;
            return lastChild;
        }
        return null;
    }

    private RenderNode getFirstNonEmpty() {
        for (RenderNode firstChild = this.getFirstChild(); firstChild != null; firstChild = firstChild.getNext()) {
            if (firstChild.isEmpty()) continue;
            return firstChild;
        }
        return null;
    }

    public boolean isEmpty() {
        if (!this.getBoxDefinition().isEmpty()) {
            return false;
        }
        RenderNode node = this.getFirstNonEmpty();
        return node == null;
    }

    public boolean isDiscardable() {
        if (!this.getBoxDefinition().isEmpty()) {
            return false;
        }
        for (RenderNode node = this.getFirstChild(); node != null; node = node.getNext()) {
            if (node.isDiscardable()) continue;
            return false;
        }
        return true;
    }

    public void close() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Double close..");
        }
        if (this.isHibernated()) {
            throw new IllegalStateException("Check your state management. You tried to mess with an hibernated element.");
        }
        this.open = false;
        if (this.isDiscardable()) {
            if (this.getParent() != null) {
                this.getParent().remove(this);
            }
        } else {
            RenderNode lastChild = this.getLastChild();
            while (lastChild != null && lastChild.isDiscardable()) {
                this.remove(lastChild);
                lastChild = this.getLastChild();
            }
        }
    }

    public void remove(RenderNode child) {
        RenderBox parent = child.getParent();
        if (parent != this) {
            throw new IllegalArgumentException("None of my childs");
        }
        child.setParent(null);
        RenderNode prev = child.getPrev();
        RenderNode next = child.getNext();
        if (prev != null) {
            prev.setNext(next);
        }
        if (next != null) {
            next.setPrev(prev);
        }
        if (this.firstChild == child) {
            this.firstChild = next;
        }
        if (this.lastChild == child) {
            this.lastChild = prev;
        }
        child.updateChangeTracker();
        this.updateChangeTracker();
    }

    public boolean isOpen() {
        return this.open;
    }

    public PageContext getPageContext() {
        if (this.pageContext != null) {
            return this.pageContext;
        }
        return super.getPageContext();
    }

    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public void freeze() {
        if (this.isFrozen()) {
            return;
        }
        super.freeze();
        for (RenderNode node = this.getFirstChild(); node != null; node = node.getNext()) {
            node.freeze();
        }
    }

    public BoxLayoutProperties getBoxLayoutProperties() {
        if (this.boxLayoutProperties == null) {
            this.boxLayoutProperties = new BoxLayoutProperties();
        }
        return this.boxLayoutProperties;
    }

    public long getContentAreaX1() {
        return this.contentAreaX1;
    }

    public void setContentAreaX1(long contentAreaX1) {
        this.contentAreaX1 = contentAreaX1;
    }

    public long getContentAreaX2() {
        return this.contentAreaX2;
    }

    public void setContentAreaX2(long contentAreaX2) {
        if (contentAreaX2 < 0L) {
            throw new IllegalStateException("Failure here: " + contentAreaX2);
        }
        this.contentAreaX2 = contentAreaX2;
    }

    public RenderBox split(int axis) {
        RenderBox otherBox = (RenderBox)this.derive(false);
        BoxDefinition[] boxDefinitions = this.boxDefinition.split(axis);
        this.boxDefinition = boxDefinitions[0];
        otherBox.boxDefinition = boxDefinitions[1];
        return otherBox;
    }

    public long getEffectiveMarginTop() {
        return this.getBoxLayoutProperties().getEffectiveMarginTop();
    }

    public long getEffectiveMarginBottom() {
        return this.getBoxLayoutProperties().getEffectiveMarginBottom();
    }
}

