/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model;

import org.jfree.layouting.input.style.keys.text.TextAlign;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.EmptyBoxDefinition;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.ParagraphPoolBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;

public class ParagraphRenderBox
extends BlockRenderBox {
    private ParagraphPoolBox pool = new ParagraphPoolBox(EmptyBoxDefinition.getInstance());
    private LineBoxRenderBox lineboxContainer;
    private CSSValue textAlignment;
    private CSSValue lastLineAlignment;
    private long lineBoxAge;
    private long minorLayoutAge;
    private long majorLayoutAge;

    public ParagraphRenderBox(BoxDefinition boxDefinition) {
        super(boxDefinition);
        this.pool.setParent(this);
        this.lineboxContainer = new LineBoxRenderBox(EmptyBoxDefinition.getInstance());
        this.lineboxContainer.setParent(this);
    }

    public void appyStyle(LayoutContext context, OutputProcessorMetaData metaData) {
        super.appyStyle(context, metaData);
        CSSValue alignVal = context.getValue(TextStyleKeys.TEXT_ALIGN);
        CSSValue alignLastVal = context.getValue(TextStyleKeys.TEXT_ALIGN_LAST);
        this.textAlignment = this.createAlignment(alignVal);
        this.lastLineAlignment = this.textAlignment == TextAlign.JUSTIFY ? this.createAlignment(alignLastVal) : this.textAlignment;
        this.pool.appyStyle(context, metaData);
        this.lineboxContainer.appyStyle(context, metaData);
    }

    public RenderNode derive(boolean deepDerive) {
        ParagraphRenderBox box = (ParagraphRenderBox)super.derive(deepDerive);
        box.pool = (ParagraphPoolBox)this.pool.derive(deepDerive);
        box.pool.setParent(box);
        box.lineboxContainer = (LineBoxRenderBox)this.lineboxContainer.derive(deepDerive);
        box.lineboxContainer.setParent(box);
        if (!deepDerive) {
            box.lineBoxAge = 0L;
        }
        return box;
    }

    public RenderNode hibernate() {
        ParagraphRenderBox box = (ParagraphRenderBox)super.derive(false);
        box.setHibernated(true);
        box.pool = (ParagraphPoolBox)this.pool.hibernate();
        box.pool.setParent(box);
        box.lineboxContainer = (LineBoxRenderBox)this.lineboxContainer.hibernate();
        box.lineBoxAge = 0L;
        return box;
    }

    private CSSValue createAlignment(CSSValue value) {
        if (TextAlign.LEFT.equals(value) || TextAlign.START.equals(value)) {
            return TextAlign.LEFT;
        }
        if (TextAlign.RIGHT.equals(value) || TextAlign.END.equals(value)) {
            return TextAlign.RIGHT;
        }
        if (TextAlign.CENTER.equals(value)) {
            return TextAlign.CENTER;
        }
        if (TextAlign.JUSTIFY.equals(value)) {
            return TextAlign.JUSTIFY;
        }
        return TextAlign.LEFT;
    }

    public final void addChild(RenderNode child) {
        this.pool.addChild(child);
    }

    protected void addDirectly(RenderNode child) {
        if (child instanceof ParagraphPoolBox) {
            ParagraphPoolBox poolBox = (ParagraphPoolBox)child;
            poolBox.trim();
        }
        super.addGeneratedChild(child);
    }

    public final void clear() {
        this.pool.clear();
        this.lineboxContainer.clear();
        super.clear();
        this.lineBoxAge = 0L;
    }

    public final void clearLayout() {
        super.clear();
        this.lineBoxAge = 0L;
    }

    public RenderBox getInsertationPoint() {
        return this.pool.getInsertationPoint();
    }

    public boolean isAppendable() {
        return this.pool.isAppendable();
    }

    public RenderNode findNodeById(Object instanceId) {
        return super.findNodeById(instanceId);
    }

    public boolean isEmpty() {
        return this.pool.isEmpty();
    }

    public boolean isDiscardable() {
        return this.pool.isDiscardable();
    }

    public CSSValue getLastLineAlignment() {
        return this.lastLineAlignment;
    }

    public CSSValue getTextAlignment() {
        return this.textAlignment;
    }

    public BlockRenderBox getLineboxContainer() {
        return this.lineboxContainer;
    }

    public InlineRenderBox getPool() {
        return this.pool;
    }

    public long getLineBoxAge() {
        return this.lineBoxAge;
    }

    public void setLineBoxAge(long lineBoxAge) {
        this.lineBoxAge = lineBoxAge;
    }

    public long getMinorLayoutAge() {
        return this.minorLayoutAge;
    }

    public void setMinorLayoutAge(long minorLayoutAge) {
        this.minorLayoutAge = minorLayoutAge;
    }

    public long getMajorLayoutAge() {
        return this.majorLayoutAge;
    }

    public void setMajorLayoutAge(long majorLayoutAge) {
        this.majorLayoutAge = majorLayoutAge;
    }

    public Object getInstanceId() {
        return this.pool.getInstanceId();
    }

    private static class LineBoxRenderBox
    extends BlockRenderBox {
        private LineBoxRenderBox(BoxDefinition boxDefinition) {
            super(boxDefinition);
        }
    }
}

