/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model;

import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;

public class ParagraphPoolBox
extends InlineRenderBox {
    private RenderLength lineHeight;

    public ParagraphPoolBox(BoxDefinition boxDefinition) {
        super(boxDefinition);
    }

    public void appyStyle(LayoutContext context, OutputProcessorMetaData metaData) {
        super.appyStyle(context, metaData);
        CSSValue lineHeightValue = context.getValue(LineStyleKeys.LINE_HEIGHT);
        this.lineHeight = RenderLength.convertToInternal(lineHeightValue, context, metaData);
    }

    public RenderLength getLineHeight() {
        return this.lineHeight;
    }

    public void close() {
        if (!this.isOpen()) {
            return;
        }
        RenderBox parent = this.getParent();
        super.close();
        if (parent != null) {
            parent.close();
        }
    }

    public void trim() {
        RenderNode node = this.getFirstChild();
        while (node != null && node.isIgnorableForRendering()) {
            this.remove(node);
            node = this.getFirstChild();
        }
        node = this.getLastChild();
        while (node != null && node.isIgnorableForRendering()) {
            this.remove(node);
            node = this.getLastChild();
        }
    }

    public void setParent(RenderBox parent) {
        super.setParent(parent);
    }
}

