/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model;

import java.util.ArrayList;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.NodeLayoutProperties;
import org.jfree.layouting.renderer.model.PlaceholderRenderNode;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;

public class NormalFlowRenderBox
extends BlockRenderBox {
    private Object placeHolderId;
    private PlaceholderRenderNode placeHolder = new PlaceholderRenderNode();
    private ArrayList subFlows;

    public NormalFlowRenderBox(BoxDefinition boxDefinition) {
        super(boxDefinition);
        this.placeHolderId = this.getPlaceHolder().getInstanceId();
        this.subFlows = new ArrayList();
        NodeLayoutProperties nodeLayoutProperties = this.getNodeLayoutProperties();
        nodeLayoutProperties.setNamespace("http://jfreereport.sourceforge.net/namespaces/layout");
        nodeLayoutProperties.setTagName("normal-flow");
    }

    public void appyStyle(LayoutContext context, OutputProcessorMetaData metaData) {
        super.appyStyle(context, metaData);
        NodeLayoutProperties nodeLayoutProperties = this.getNodeLayoutProperties();
        nodeLayoutProperties.setNamespace("http://jfreereport.sourceforge.net/namespaces/layout");
        nodeLayoutProperties.setTagName("normal-flow");
    }

    public PlaceholderRenderNode getPlaceHolder() {
        return this.placeHolder;
    }

    public void addChild(RenderNode child) {
        if (!(child instanceof BlockRenderBox)) {
            throw new IllegalStateException("This cannot be.");
        }
        super.addChild(child);
    }

    public void addFlow(NormalFlowRenderBox flow) {
        this.subFlows.add(flow);
    }

    public NormalFlowRenderBox[] getFlows() {
        return this.subFlows.toArray(new NormalFlowRenderBox[this.subFlows.size()]);
    }

    public NormalFlowRenderBox getFlow(int i) {
        return (NormalFlowRenderBox)this.subFlows.get(i);
    }

    public int getFlowCount() {
        return this.subFlows.size();
    }

    public RenderNode hibernate() {
        NormalFlowRenderBox renderBox = (NormalFlowRenderBox)super.hibernate();
        renderBox.subFlows = new ArrayList(this.subFlows.size());
        for (int i = 0; i < this.subFlows.size(); ++i) {
            NormalFlowRenderBox box = (NormalFlowRenderBox)this.subFlows.get(i);
            renderBox.subFlows.add(box.derive(true));
            box.placeHolder = (PlaceholderRenderNode)this.findNodeById(box.placeHolderId);
        }
        renderBox.placeHolder = null;
        return renderBox;
    }

    public RenderNode derive(boolean deepDerive) {
        NormalFlowRenderBox renderBox = (NormalFlowRenderBox)super.derive(deepDerive);
        if (deepDerive) {
            renderBox.subFlows = new ArrayList(this.subFlows.size());
            for (int i = 0; i < this.subFlows.size(); ++i) {
                NormalFlowRenderBox box = (NormalFlowRenderBox)this.subFlows.get(i);
                renderBox.subFlows.add(box.derive(true));
                box.placeHolder = (PlaceholderRenderNode)this.findNodeById(box.placeHolderId);
            }
            renderBox.placeHolder = null;
        } else {
            renderBox.placeHolder = (PlaceholderRenderNode)this.placeHolder.derive(true);
            renderBox.subFlows = new ArrayList();
        }
        return renderBox;
    }

    public RenderNode deriveFrozen(boolean deepDerive) {
        NormalFlowRenderBox renderBox = (NormalFlowRenderBox)super.deriveFrozen(deepDerive);
        if (deepDerive) {
            renderBox.subFlows = new ArrayList(this.subFlows.size());
            for (int i = 0; i < this.subFlows.size(); ++i) {
                NormalFlowRenderBox box = (NormalFlowRenderBox)this.subFlows.get(i);
                renderBox.subFlows.add(box.deriveFrozen(true));
                box.placeHolder = (PlaceholderRenderNode)this.findNodeById(box.placeHolderId);
            }
            renderBox.placeHolder = null;
        } else {
            renderBox.placeHolder = (PlaceholderRenderNode)this.placeHolder.deriveFrozen(true);
            renderBox.subFlows = new ArrayList();
        }
        return renderBox;
    }

    public RenderBox getInsertationPoint() {
        for (int i = 0; i < this.subFlows.size(); ++i) {
            NormalFlowRenderBox box = (NormalFlowRenderBox)this.subFlows.get(i);
            if (!box.isOpen()) continue;
            return box.getInsertationPoint();
        }
        return super.getInsertationPoint();
    }

    public NormalFlowRenderBox getNormalFlow() {
        return this;
    }

    public RenderNode findNodeById(Object instanceId) {
        for (int i = 0; i < this.subFlows.size(); ++i) {
            RenderNode node = (RenderNode)this.subFlows.get(i);
            RenderNode nodeById = node.findNodeById(instanceId);
            if (nodeById == null) continue;
            return nodeById;
        }
        return super.findNodeById(instanceId);
    }
}

