/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.border;

import org.jfree.layouting.input.style.keys.border.BorderStyle;
import org.jfree.layouting.input.style.keys.border.BorderStyleKeys;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.border.BorderCorner;
import org.jfree.layouting.renderer.border.BorderEdge;
import org.jfree.layouting.renderer.border.EmptyBorderCorner;
import org.jfree.layouting.renderer.border.EmptyBorderEdge;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.border.RoundedBorderCorner;
import org.jfree.layouting.renderer.border.StyledBorderEdge;

public class BorderFactory {
    public Border createBorder(LayoutContext layoutContext, OutputProcessorMetaData metaData) {
        CSSValue borderTopStyle = layoutContext.getValue(BorderStyleKeys.BORDER_TOP_STYLE);
        CSSValue borderTopWidth = layoutContext.getValue(BorderStyleKeys.BORDER_TOP_WIDTH);
        CSSValue borderTopColor = layoutContext.getValue(BorderStyleKeys.BORDER_TOP_COLOR);
        BorderEdge topEdge = this.createEdge(borderTopStyle, borderTopWidth, borderTopColor, layoutContext, metaData);
        CSSValue borderLeftStyle = layoutContext.getValue(BorderStyleKeys.BORDER_LEFT_STYLE);
        CSSValue borderLeftWidth = layoutContext.getValue(BorderStyleKeys.BORDER_LEFT_WIDTH);
        CSSValue borderLeftColor = layoutContext.getValue(BorderStyleKeys.BORDER_LEFT_COLOR);
        BorderEdge leftEdge = this.createEdge(borderLeftStyle, borderLeftWidth, borderLeftColor, layoutContext, metaData);
        CSSValue borderBottomStyle = layoutContext.getValue(BorderStyleKeys.BORDER_BOTTOM_STYLE);
        CSSValue borderBottomWidth = layoutContext.getValue(BorderStyleKeys.BORDER_BOTTOM_WIDTH);
        CSSValue borderBottomColor = layoutContext.getValue(BorderStyleKeys.BORDER_BOTTOM_COLOR);
        BorderEdge bottomEdge = this.createEdge(borderBottomStyle, borderBottomWidth, borderBottomColor, layoutContext, metaData);
        CSSValue borderRightStyle = layoutContext.getValue(BorderStyleKeys.BORDER_RIGHT_STYLE);
        CSSValue borderRightWidth = layoutContext.getValue(BorderStyleKeys.BORDER_RIGHT_WIDTH);
        CSSValue borderRightColor = layoutContext.getValue(BorderStyleKeys.BORDER_RIGHT_COLOR);
        BorderEdge rightEdge = this.createEdge(borderRightStyle, borderRightWidth, borderRightColor, layoutContext, metaData);
        CSSValue borderBreakStyle = layoutContext.getValue(BorderStyleKeys.BORDER_BREAK_STYLE);
        CSSValue borderBreakWidth = layoutContext.getValue(BorderStyleKeys.BORDER_BREAK_WIDTH);
        CSSValue borderBreakColor = layoutContext.getValue(BorderStyleKeys.BORDER_BREAK_COLOR);
        BorderEdge breakEdge = this.createEdge(borderBreakStyle, borderBreakWidth, borderBreakColor, layoutContext, metaData);
        CSSValue topLeftRadius = layoutContext.getValue(BorderStyleKeys.BORDER_TOP_LEFT_RADIUS);
        CSSValue topRightRadius = layoutContext.getValue(BorderStyleKeys.BORDER_TOP_RIGHT_RADIUS);
        CSSValue bottomLeftRadius = layoutContext.getValue(BorderStyleKeys.BORDER_BOTTOM_LEFT_RADIUS);
        CSSValue bottomRightRadius = layoutContext.getValue(BorderStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS);
        BorderCorner topLeftCorner = this.createCorner(topLeftRadius, layoutContext, metaData);
        BorderCorner topRightCorner = this.createCorner(topRightRadius, layoutContext, metaData);
        BorderCorner bottomLeftCorner = this.createCorner(bottomLeftRadius, layoutContext, metaData);
        BorderCorner bottomRightCorner = this.createCorner(bottomRightRadius, layoutContext, metaData);
        return new Border(topEdge, leftEdge, bottomEdge, rightEdge, breakEdge, topLeftCorner, topRightCorner, bottomLeftCorner, bottomRightCorner);
    }

    private BorderCorner createCorner(CSSValue value, LayoutContext layoutContext, OutputProcessorMetaData metaData) {
        if (!(value instanceof CSSValuePair)) {
            return EmptyBorderCorner.getInstance();
        }
        CSSValuePair vp = (CSSValuePair)value;
        CSSValue first = vp.getFirstValue();
        CSSValue second = vp.getSecondValue();
        RenderLength width = RenderLength.convertToInternal(first, layoutContext, metaData);
        RenderLength height = RenderLength.convertToInternal(second, layoutContext, metaData);
        if (width.getValue() > 0L && height.getValue() > 0L) {
            return new RoundedBorderCorner(width, height);
        }
        return EmptyBorderCorner.getInstance();
    }

    private BorderEdge createEdge(CSSValue style, CSSValue widthVal, CSSValue color, LayoutContext layoutContext, OutputProcessorMetaData metaData) {
        if (!(style instanceof CSSConstant)) {
            return EmptyBorderEdge.getInstance();
        }
        if (!(color instanceof CSSColorValue)) {
            return EmptyBorderEdge.getInstance();
        }
        if (BorderStyle.NONE.equals(style)) {
            return EmptyBorderEdge.getInstance();
        }
        RenderLength width = RenderLength.convertToInternal(widthVal, layoutContext, metaData);
        if (width.getValue() <= 0L) {
            return EmptyBorderEdge.getInstance();
        }
        return new StyledBorderEdge(style, (CSSColorValue)color, width);
    }

    public static BorderEdge merge(BorderEdge first, BorderEdge second, long computedParentWidth) {
        int secondStyleWeight;
        long secondWidth;
        CSSValue firstStyle = first.getBorderStyle();
        if (BorderStyle.HIDDEN.equals(firstStyle)) {
            return first;
        }
        CSSValue secondStyle = second.getBorderStyle();
        if (BorderStyle.HIDDEN.equals(secondStyle)) {
            return second;
        }
        if (BorderStyle.NONE.equals(first)) {
            return second;
        }
        if (BorderStyle.NONE.equals(second)) {
            return first;
        }
        long firstWidth = first.getWidth().resolve(computedParentWidth);
        if (firstWidth < (secondWidth = second.getWidth().resolve(computedParentWidth))) {
            return second;
        }
        if (secondWidth < firstWidth) {
            return first;
        }
        int firstStyleWeight = BorderFactory.getStylePreferrence(firstStyle);
        if (firstStyleWeight > (secondStyleWeight = BorderFactory.getStylePreferrence(secondStyle))) {
            return first;
        }
        return second;
    }

    private static int getStylePreferrence(CSSValue value) {
        if (BorderStyle.DOUBLE.equals(value)) {
            return 10;
        }
        if (BorderStyle.SOLID.equals(value)) {
            return 9;
        }
        if (BorderStyle.DASHED.equals(value)) {
            return 8;
        }
        if (BorderStyle.DOT_DASH.equals(value)) {
            return 7;
        }
        if (BorderStyle.DOT_DOT_DASH.equals(value)) {
            return 6;
        }
        if (BorderStyle.DOTTED.equals(value)) {
            return 5;
        }
        if (BorderStyle.RIDGE.equals(value)) {
            return 4;
        }
        if (BorderStyle.OUTSET.equals(value)) {
            return 3;
        }
        if (BorderStyle.GROOVE.equals(value)) {
            return 2;
        }
        if (BorderStyle.INSET.equals(value)) {
            return 1;
        }
        return 0;
    }
}

