/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.border;

import org.jfree.layouting.renderer.border.BorderCorner;
import org.jfree.layouting.renderer.border.BorderEdge;
import org.jfree.layouting.renderer.border.EmptyBorderCorner;
import org.jfree.layouting.renderer.border.EmptyBorderEdge;

public class Border
implements Cloneable {
    private static Border emptyBorder;
    private BorderEdge top;
    private BorderEdge left;
    private BorderEdge bottom;
    private BorderEdge right;
    private BorderEdge splittingEdge;
    private BorderCorner topLeft;
    private BorderCorner topRight;
    private BorderCorner bottomLeft;
    private BorderCorner bottomRight;
    private Boolean empty;

    public Border(BorderEdge top, BorderEdge left, BorderEdge bottom, BorderEdge right, BorderEdge splittingEdge, BorderCorner topLeft, BorderCorner topRight, BorderCorner bottomLeft, BorderCorner bottomRight) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.splittingEdge = splittingEdge;
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
    }

    public BorderEdge getTop() {
        return this.top;
    }

    public BorderEdge getLeft() {
        return this.left;
    }

    public BorderEdge getBottom() {
        return this.bottom;
    }

    public BorderEdge getRight() {
        return this.right;
    }

    public BorderEdge getSplittingEdge() {
        return this.splittingEdge;
    }

    public BorderCorner getTopLeft() {
        return this.topLeft;
    }

    public BorderCorner getTopRight() {
        return this.topRight;
    }

    public BorderCorner getBottomLeft() {
        return this.bottomLeft;
    }

    public BorderCorner getBottomRight() {
        return this.bottomRight;
    }

    public Border[] splitVertically(Border[] borders) {
        if (borders == null || borders.length < 2) {
            borders = new Border[2];
        }
        borders[0] = (Border)this.clone();
        borders[0].empty = null;
        borders[0].right = borders[0].splittingEdge;
        borders[1] = (Border)this.clone();
        borders[1].empty = null;
        borders[1].left = borders[1].splittingEdge;
        return borders;
    }

    public Border[] splitHorizontally(Border[] borders) {
        if (borders == null || borders.length < 2) {
            borders = new Border[2];
        }
        borders[0] = (Border)this.clone();
        borders[0].empty = null;
        borders[0].bottom = borders[0].splittingEdge;
        borders[1] = (Border)this.clone();
        borders[1].empty = null;
        borders[1].top = borders[1].splittingEdge;
        return borders;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Borders not supporting clone is evil!");
        }
    }

    public static synchronized Border createEmptyBorder() {
        if (emptyBorder == null) {
            BorderEdge edge = EmptyBorderEdge.getInstance();
            EmptyBorderCorner corner = EmptyBorderCorner.getInstance();
            emptyBorder = new Border(edge, edge, edge, edge, edge, corner, corner, corner, corner);
        }
        return emptyBorder;
    }

    public boolean isEmpty() {
        if (this.empty != null) {
            return this.empty;
        }
        if (this.top.getWidth().getValue() != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.left.getWidth().getValue() != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.bottom.getWidth().getValue() != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.right.getWidth().getValue() != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        this.empty = Boolean.TRUE;
        return true;
    }
}

