/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.util.Log;

public class PrintingRenderer
implements Renderer {
    private Renderer parent;

    public PrintingRenderer(Renderer parent) {
        this.parent = parent;
    }

    public void startedDocument(PageContext pageContext) {
        Log.debug((Object)"<document>");
        this.parent.startedDocument(pageContext);
    }

    public void startedFlow(LayoutContext context) throws NormalizationException {
        Log.debug((Object)("<flow tag='" + context.getTagName() + "' namespace='" + context.getNamespace() + "'>"));
        this.parent.startedFlow(context);
    }

    public void startedTable(LayoutContext context) throws NormalizationException {
        Log.debug((Object)("<table tag='" + context.getTagName() + "' namespace='" + context.getNamespace() + "'>"));
        this.parent.startedTable(context);
    }

    public void startedTableSection(LayoutContext layoutContext) throws NormalizationException {
        Log.debug((Object)("<table-section tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>"));
        this.parent.startedTableSection(layoutContext);
    }

    public void startedTableRow(LayoutContext layoutContext) throws NormalizationException {
        Log.debug((Object)("<table-row tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>"));
        this.parent.startedTableRow(layoutContext);
    }

    public void startedTableCell(LayoutContext layoutContext) throws NormalizationException {
        Log.debug((Object)("<table-cell tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>"));
        this.parent.startedTableCell(layoutContext);
    }

    public void startedBlock(LayoutContext context) throws NormalizationException {
        Log.debug((Object)("<block tag='" + context.getTagName() + "' namespace='" + context.getNamespace() + "'>"));
        this.parent.startedBlock(context);
    }

    public void startedMarker(LayoutContext context) throws NormalizationException {
        Log.debug((Object)("<marker tag='" + context.getTagName() + "' namespace='" + context.getNamespace() + "'>"));
        this.parent.startedMarker(context);
    }

    public void startedRootInline(LayoutContext context) throws NormalizationException {
        Log.debug((Object)("<paragraph tag='" + context.getTagName() + "' namespace='" + context.getNamespace() + "'>"));
        this.parent.startedRootInline(context);
    }

    public void startedInline(LayoutContext context) throws NormalizationException {
        Log.debug((Object)("<inline tag='" + context.getTagName() + "' namespace='" + context.getNamespace() + "'>"));
        this.parent.startedInline(context);
    }

    public void addContent(LayoutContext context, ContentToken content) throws NormalizationException {
        Log.debug((Object)("<content>" + content + "</content>"));
        this.parent.addContent(context, content);
    }

    public void finishedInline() throws NormalizationException {
        Log.debug((Object)"</inline>");
        this.parent.finishedInline();
    }

    public void finishedRootInline() throws NormalizationException {
        Log.debug((Object)"</paragraph>");
        this.parent.finishedRootInline();
    }

    public void finishedMarker() throws NormalizationException {
        Log.debug((Object)"</marker>");
        this.parent.finishedMarker();
    }

    public void finishedBlock() throws NormalizationException {
        Log.debug((Object)"</block>");
        this.parent.finishedBlock();
    }

    public void finishedTableCell() throws NormalizationException {
        Log.debug((Object)"</table-cell>");
        this.parent.finishedTableCell();
    }

    public void finishedTableRow() throws NormalizationException {
        Log.debug((Object)"</table-row>");
        this.parent.finishedTableRow();
    }

    public void finishedTableSection() throws NormalizationException {
        Log.debug((Object)"</table-section>");
        this.parent.finishedTableSection();
    }

    public void finishedTable() throws NormalizationException {
        Log.debug((Object)"</table>");
        this.parent.finishedTable();
    }

    public void finishedFlow() throws NormalizationException {
        Log.debug((Object)"</flow>");
        this.parent.finishedFlow();
    }

    public void finishedDocument() throws NormalizationException {
        Log.debug((Object)"</document>");
        this.parent.finishedDocument();
    }

    public void startedTableColumnGroup(LayoutContext context) throws NormalizationException {
        Log.debug((Object)"<table-column-group>");
        this.parent.startedTableColumnGroup(context);
    }

    public void startedTableColumn(LayoutContext context) throws NormalizationException {
        Log.debug((Object)"<table-column>");
        this.parent.startedTableColumn(context);
    }

    public void finishedTableColumnGroup() throws NormalizationException {
        Log.debug((Object)"</table-column-group>");
        this.parent.finishedTableColumnGroup();
    }

    public void finishedTableColumn() throws NormalizationException {
        Log.debug((Object)"</table-column>");
        this.parent.finishedTableColumn();
    }

    public void handlePageBreak(PageContext pageContext) {
        Log.debug((Object)"<!-- PAGEBREAK ENCOUNTERED -->");
        this.parent.handlePageBreak(pageContext);
    }

    public void startedPassThrough(LayoutContext context) throws NormalizationException {
        Log.debug((Object)"<pass-through>");
        this.parent.startedPassThrough(context);
    }

    public void addPassThroughContent(LayoutContext context, ContentToken content) throws NormalizationException {
        Log.debug((Object)("<pass-through-content>" + content + "</pass-through-content>"));
        this.parent.addPassThroughContent(context, content);
    }

    public void finishedPassThrough() throws NormalizationException {
        Log.debug((Object)"</pass-through>");
        this.parent.finishedPassThrough();
    }

    public State saveState() throws StateException {
        return new PrintingRendererState(this.parent);
    }

    public void startedTableCaption(LayoutContext context) throws NormalizationException {
        Log.debug((Object)"<table-caption>");
        this.parent.startedTableCaption(context);
    }

    public void finishedTableCaption() throws NormalizationException {
        Log.debug((Object)"</table-caption>");
        this.parent.finishedTableCaption();
    }

    private static class PrintingRendererState
    implements State {
        private State parentState;

        private PrintingRendererState(Renderer parent) throws StateException {
            this.parentState = parent.saveState();
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            return new PrintingRenderer((Renderer)this.parentState.restore(layoutProcess));
        }
    }
}

