/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer;

import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowInfoStructure;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.cells.TableCell;
import org.jfree.layouting.renderer.model.table.cols.TableColumn;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;
import org.jfree.util.Log;

public class ModelPrinter {
    private ModelPrinter() {
    }

    public static void printParents(RenderNode node) {
        while (node != null) {
            StringBuffer b = new StringBuffer();
            b.append(node.getClass().getName());
            b.append('[');
            b.append(Integer.toHexString(System.identityHashCode(node)));
            b.append(']');
            Log.debug((Object)b);
            node = node.getParent();
        }
    }

    public static void print(RenderBox box) {
        ModelPrinter.printBox(box, 0);
    }

    public static void printBox(RenderBox box, int level) {
        int i;
        StringBuffer b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append(box.getClass().getName());
        b.append('[');
        b.append(Integer.toHexString(System.identityHashCode(box)));
        b.append(']');
        b.append("={x=");
        b.append(box.getX());
        b.append(", y=");
        b.append(box.getY());
        b.append(", width=");
        b.append(box.getWidth());
        b.append(", height=");
        b.append(box.getHeight());
        b.append('}');
        Log.debug((Object)b.toString());
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- nodeLayoutProperties=");
        b.append(box.getNodeLayoutProperties());
        Log.debug((Object)b.toString());
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- boxLayoutProperties=");
        b.append(box.getBoxLayoutProperties());
        Log.debug((Object)b.toString());
        if (box instanceof TableRowRenderBox) {
            TableRowRenderBox row = (TableRowRenderBox)box;
            TableRowInfoStructure rowInfoStructure = row.getRowInfoStructure();
            for (int i2 = 0; i2 < rowInfoStructure.getCellCount(); ++i2) {
                TableCell cell = rowInfoStructure.getCellAt(i2);
                Log.debug((Object)("CELL: " + i2 + " = " + cell.getRowSpan() + ' ' + cell.getColSpan() + ' ' + cell));
            }
        } else if (box instanceof TableRenderBox) {
            TableRenderBox table = (TableRenderBox)box;
            TableColumnModel columnModel = table.getColumnModel();
            for (int i3 = 0; i3 < columnModel.getColumnCount(); ++i3) {
                TableColumn col = columnModel.getColumn(i3);
                Log.debug((Object)("COLUMN: EffectiveSize: " + col.getEffectiveSize() + " Computed Max Width: " + col.getComputedMaximumWidth() + " Computed ChunkSize: " + col.getComputedMinChunkSize()));
            }
        } else if (box instanceof TableCellRenderBox) {
            TableCellRenderBox cellBox = (TableCellRenderBox)box;
            Log.debug((Object)("CELL: Position: " + cellBox.getColumnIndex()));
        } else if (box instanceof ParagraphRenderBox) {
            ParagraphRenderBox paraBox = (ParagraphRenderBox)box;
            Log.debug((Object)"-----------------------------------------------------");
            ModelPrinter.printBox(paraBox.getLineboxContainer(), level + 1);
            Log.debug((Object)"-----------------------------------------------------");
        }
        ModelPrinter.printChilds(box, level);
    }

    private static void printChilds(RenderBox box, int level) {
        for (RenderNode childs = box.getFirstChild(); childs != null; childs = childs.getNext()) {
            if (childs instanceof RenderBox) {
                ModelPrinter.printBox((RenderBox)childs, level + 1);
                continue;
            }
            if (childs instanceof RenderableText) {
                ModelPrinter.printText((RenderableText)childs, level + 1);
                continue;
            }
            ModelPrinter.printNode(childs, level + 1);
        }
    }

    private static void printNode(RenderNode node, int level) {
        int i;
        StringBuffer b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append(node.getClass().getName());
        b.append('[');
        b.append(Integer.toHexString(System.identityHashCode(node)));
        b.append(']');
        b.append("={x=");
        b.append(node.getX());
        b.append(", y=");
        b.append(node.getY());
        b.append(", width=");
        b.append(node.getWidth());
        b.append(", height=");
        b.append(node.getHeight());
        b.append('}');
        Log.debug((Object)b.toString());
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- nodeLayoutProperties=");
        b.append(node.getNodeLayoutProperties());
        Log.debug((Object)b.toString());
    }

    private static void printText(RenderableText text, int level) {
        int i;
        StringBuffer b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("Text");
        b.append('[');
        b.append(Integer.toHexString(System.identityHashCode(text)));
        b.append(']');
        b.append("={x=");
        b.append(text.getX());
        b.append(", y=");
        b.append(text.getY());
        b.append(", width=");
        b.append(text.getWidth());
        b.append(", height=");
        b.append(text.getHeight());
        b.append(", text='");
        b.append(text.getRawText());
        b.append("'}");
        Log.debug((Object)b.toString());
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- nodeLayoutProperties=");
        b.append(text.getNodeLayoutProperties());
        Log.debug((Object)b.toString());
    }
}

