/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer;

import java.io.Serializable;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.renderer.model.NormalFlowRenderBox;
import org.jfree.layouting.renderer.text.RenderableTextFactory;

public final class FlowContext {
    private RenderableTextFactory textFactory;
    private NormalFlowRenderBox currentFlow;

    public FlowContext(RenderableTextFactory textFactory, NormalFlowRenderBox currentFlow) {
        if (textFactory == null) {
            throw new NullPointerException();
        }
        if (currentFlow == null) {
            throw new NullPointerException();
        }
        this.textFactory = textFactory;
        this.currentFlow = currentFlow;
    }

    public RenderableTextFactory getTextFactory() {
        return this.textFactory;
    }

    public NormalFlowRenderBox getCurrentFlow() {
        return this.currentFlow;
    }

    public FlowContextState saveState() throws StateException {
        FlowContextState flowContextState = new FlowContextState(this.textFactory.saveState(), this.currentFlow.getInstanceId());
        return flowContextState;
    }

    public static class FlowContextState
    implements Serializable {
        private State textFactoryState;
        private Object currentFlowId;

        public FlowContextState(State textFactoryState, Object currentFlowId) {
            if (textFactoryState == null) {
                throw new NullPointerException();
            }
            if (currentFlowId == null) {
                throw new NullPointerException();
            }
            this.textFactoryState = textFactoryState;
            this.currentFlowId = currentFlowId;
        }

        public State getTextFactoryState() {
            return this.textFactoryState;
        }

        public Object getCurrentFlowId() {
            return this.currentFlowId;
        }
    }
}

