/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer;

import org.jfree.layouting.input.style.keys.page.PagePolicy;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.renderer.AbstractStore;
import org.jfree.layouting.renderer.model.RenderNode;

public class ContentStore
extends AbstractStore {
    public void add(String name, RenderNode[] value) {
        super.addInternal(name, value);
    }

    public RenderNode[] get(String name) {
        return this.get(name, PagePolicy.LAST);
    }

    public RenderNode[] get(String name, CSSValue pagePolicy) {
        if (PagePolicy.START.equals(pagePolicy)) {
            RenderNode[] initial = (RenderNode[])this.getInitialInternal(name);
            if (initial == null) {
                return null;
            }
            return this.deriveRetval(initial);
        }
        if (PagePolicy.FIRST.equals(pagePolicy)) {
            RenderNode[] first = (RenderNode[])this.getFirstInternal(name);
            if (first == null) {
                return null;
            }
            return this.deriveRetval(first);
        }
        RenderNode[] last = (RenderNode[])this.getLastInternal(name);
        if (last == null) {
            return null;
        }
        return this.deriveRetval(last);
    }

    private RenderNode[] deriveRetval(RenderNode[] val) {
        if (val == null) {
            return new RenderNode[0];
        }
        RenderNode[] reval = new RenderNode[val.length];
        for (int i = 0; i < val.length; ++i) {
            RenderNode node = val[i];
            reval[i] = node.derive(true);
        }
        return val;
    }
}

