/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractStore
implements Cloneable,
Serializable {
    private Map initialSet = new HashMap();
    private HashMap firstSet = new HashMap();
    private HashMap lastSet = new HashMap();

    protected void addInternal(String name, Object contents) {
        if (!this.firstSet.containsKey(name)) {
            this.firstSet.put(name, contents);
        }
        this.lastSet.put(name, contents);
    }

    protected Object getLastInternal(String name) {
        Object lastObject = this.lastSet.get(name);
        if (lastObject != null) {
            return this.lastSet.get(name);
        }
        return this.initialSet.get(name);
    }

    protected Object getFirstInternal(String name) {
        Object firstVal = this.firstSet.get(name);
        if (firstVal != null) {
            return this.firstSet.get(name);
        }
        return this.initialSet.get(name);
    }

    protected Object getInitialInternal(String name) {
        return this.initialSet.get(name);
    }

    public AbstractStore derive() {
        try {
            AbstractStore contentStore = (AbstractStore)this.clone();
            contentStore.initialSet = Collections.unmodifiableMap(this.lastSet);
            return contentStore;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Must not happen");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractStore store = (AbstractStore)super.clone();
        store.firstSet = (HashMap)this.firstSet.clone();
        store.lastSet = (HashMap)this.lastSet.clone();
        store.initialSet = this.initialSet;
        return store;
    }
}

