/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer;

import java.awt.Dimension;
import java.awt.Image;
import org.jfree.fonts.encoding.CodePointBuffer;
import org.jfree.fonts.encoding.manual.Utf16LE;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.keys.positioning.PositioningStyleKeys;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.computed.ComputedToken;
import org.jfree.layouting.layouter.content.computed.VariableToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedCounterToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedStringToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedToken;
import org.jfree.layouting.layouter.content.type.GenericType;
import org.jfree.layouting.layouter.content.type.ResourceType;
import org.jfree.layouting.layouter.content.type.TextType;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.renderer.ContentStore;
import org.jfree.layouting.renderer.FlowContext;
import org.jfree.layouting.renderer.ModelPrinter;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.renderer.border.BorderFactory;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.BoxDefinitionFactory;
import org.jfree.layouting.renderer.model.DefaultBoxDefinitionFactory;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.MarkerRenderBox;
import org.jfree.layouting.renderer.model.NormalFlowRenderBox;
import org.jfree.layouting.renderer.model.PageAreaRenderBox;
import org.jfree.layouting.renderer.model.ParagraphPoolBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableReplacedContent;
import org.jfree.layouting.renderer.model.RenderableTextBox;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableColumnGroupNode;
import org.jfree.layouting.renderer.model.table.TableColumnNode;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.page.RenderPageContext;
import org.jfree.layouting.renderer.process.CheckHibernationLayoutStep;
import org.jfree.layouting.renderer.text.DefaultRenderableTextFactory;
import org.jfree.layouting.renderer.text.RenderableTextFactory;
import org.jfree.layouting.util.geom.StrictDimension;
import org.jfree.layouting.util.geom.StrictGeomUtility;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.ui.Drawable;
import org.jfree.ui.ExtendedDrawable;
import org.jfree.util.FastStack;
import org.jfree.util.WaitingImageObserver;

public abstract class AbstractRenderer
implements Renderer {
    private LayoutProcess layoutProcess;
    private LogicalPageBox logicalPageBox;
    private ContentStore elementsStore;
    private ContentStore pendingStore;
    private FastStack flowContexts;
    private CodePointBuffer buffer;
    private RenderPageContext pageContext;
    private BoxDefinitionFactory boxDefinitionFactory;
    private Object layoutFailureNodeId;
    private int layoutFailureReason;

    protected AbstractRenderer(LayoutProcess layoutProcess, boolean init) {
        if (layoutProcess == null) {
            throw new NullPointerException();
        }
        this.layoutProcess = layoutProcess;
        this.flowContexts = new FastStack();
        if (init) {
            this.elementsStore = new ContentStore();
            this.pendingStore = new ContentStore();
            this.boxDefinitionFactory = new DefaultBoxDefinitionFactory(new BorderFactory());
        }
    }

    public LogicalPageBox getLogicalPageBox() {
        return this.logicalPageBox;
    }

    public LayoutProcess getLayoutProcess() {
        return this.layoutProcess;
    }

    public RenderPageContext getRenderPageContext() {
        return this.pageContext;
    }

    public void setLayoutFailureReason(int layoutFailureReason, Object layoutFailureNodeId) {
        this.layoutFailureNodeId = layoutFailureNodeId;
        this.layoutFailureReason = layoutFailureReason;
    }

    public void startedDocument(PageContext pageContext) {
        if (pageContext == null) {
            throw new NullPointerException();
        }
        LayoutProcess layoutProcess = this.getLayoutProcess();
        OutputProcessor outputProcessor = layoutProcess.getOutputProcessor();
        outputProcessor.processDocumentMetaData(layoutProcess.getDocumentContext());
        this.pageContext = new RenderPageContext(layoutProcess, pageContext);
        PageGrid pageGrid = this.pageContext.createPageGrid(this.layoutProcess.getOutputMetaData());
        this.logicalPageBox = new LogicalPageBox(pageGrid);
        this.logicalPageBox.setPageContext(this.pageContext.getPageContext());
    }

    protected final void tryValidateOutput(Object instanceId) throws NormalizationException {
        if (this.isValidatable(instanceId)) {
            try {
                this.validateOutput();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                ModelPrinter.print(this.logicalPageBox);
            }
        }
    }

    private boolean isValidatable(Object instanceId) {
        if (this.layoutFailureReason == 2) {
            if (instanceId != this.layoutFailureNodeId) {
                return false;
            }
            this.layoutFailureReason = 0;
            this.layoutFailureNodeId = null;
        }
        return true;
    }

    protected abstract void validateOutput() throws NormalizationException;

    protected RenderBox getInsertationPoint() {
        FlowContext context = (FlowContext)this.flowContexts.peek();
        NormalFlowRenderBox currentFlow = context.getCurrentFlow();
        if (currentFlow == null) {
            throw new IllegalStateException("There is no flow active at the moment.");
        }
        return currentFlow.getInsertationPoint();
    }

    protected boolean isProcessingNormalFlow() {
        return this.flowContexts.size() <= 1;
    }

    public void startedFlow(LayoutContext context) throws NormalizationException {
        this.pageContext = this.pageContext.update(context);
        if (!this.logicalPageBox.isNormalFlowActive()) {
            this.logicalPageBox.setNormalFlowActive(true);
            DefaultRenderableTextFactory textFactory = new DefaultRenderableTextFactory(this.layoutProcess);
            textFactory.startText();
            FlowContext flowContext = new FlowContext(textFactory, this.logicalPageBox.getNormalFlow());
            this.flowContexts.push((Object)flowContext);
        } else {
            CSSFunctionValue fnvalue;
            CSSValue[] parameters;
            CSSValue value = context.getValue(PositioningStyleKeys.POSITION);
            if (value instanceof CSSFunctionValue && (parameters = (fnvalue = (CSSFunctionValue)value).getParameters()).length > 0) {
                CSSValue targetValue = parameters[0];
                this.startHeaderFlow(targetValue.getCSSText(), context);
                return;
            }
            BoxDefinition contentRoot = this.boxDefinitionFactory.createBlockBoxDefinition(context, this.layoutProcess.getOutputMetaData());
            NormalFlowRenderBox newFlow = new NormalFlowRenderBox(contentRoot);
            newFlow.appyStyle(context, this.layoutProcess.getOutputMetaData());
            newFlow.setPageContext(this.pageContext.getPageContext());
            RenderBox currentBox = this.getInsertationPoint();
            currentBox.addChild(newFlow.getPlaceHolder());
            currentBox.getNormalFlow().addFlow(newFlow);
            DefaultRenderableTextFactory textFactory = new DefaultRenderableTextFactory(this.layoutProcess);
            textFactory.startText();
            FlowContext flowContext = new FlowContext(textFactory, newFlow);
            this.flowContexts.push((Object)flowContext);
        }
    }

    private void startHeaderFlow(String target, LayoutContext context) {
        BoxDefinition contentRoot = this.boxDefinitionFactory.createBlockBoxDefinition(context, this.layoutProcess.getOutputMetaData());
        NormalFlowRenderBox newFlow = new NormalFlowRenderBox(contentRoot);
        newFlow.appyStyle(context, this.layoutProcess.getOutputMetaData());
        newFlow.setPageContext(this.pageContext.getPageContext());
        if ("header".equals(target)) {
            PageAreaRenderBox headerArea = this.logicalPageBox.getHeaderArea();
            headerArea.clear();
            headerArea.addChild(newFlow);
        } else if ("footer".equals(target)) {
            PageAreaRenderBox footerArea = this.logicalPageBox.getFooterArea();
            footerArea.clear();
            footerArea.addChild(newFlow);
        }
        DefaultRenderableTextFactory textFactory = new DefaultRenderableTextFactory(this.layoutProcess);
        textFactory.startText();
        FlowContext flowContext = new FlowContext(textFactory, newFlow);
        this.flowContexts.push((Object)flowContext);
    }

    public void startedTable(LayoutContext context) throws NormalizationException {
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(textFactory.finishText());
        textFactory.startText();
        BoxDefinition definition = this.boxDefinitionFactory.createBlockBoxDefinition(context, this.layoutProcess.getOutputMetaData());
        this.pageContext = this.pageContext.update(context);
        TableRenderBox tableRenderBox = new TableRenderBox(definition);
        tableRenderBox.appyStyle(context, this.layoutProcess.getOutputMetaData());
        tableRenderBox.setPageContext(this.pageContext.getPageContext());
        this.getInsertationPoint().addChild(tableRenderBox);
    }

    private RenderableTextFactory getCurrentTextFactory() {
        FlowContext context = (FlowContext)this.flowContexts.peek();
        return context.getTextFactory();
    }

    public void startedTableColumnGroup(LayoutContext context) throws NormalizationException {
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(textFactory.finishText());
        textFactory.startText();
        this.pageContext = this.pageContext.update(context);
        BoxDefinition definition = this.boxDefinitionFactory.createBlockBoxDefinition(context, this.layoutProcess.getOutputMetaData());
        TableColumnGroupNode columnGroupNode = new TableColumnGroupNode(definition);
        columnGroupNode.appyStyle(context, this.layoutProcess.getOutputMetaData());
        this.getInsertationPoint().addChild(columnGroupNode);
    }

    public void startedTableColumn(LayoutContext context) throws NormalizationException {
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(textFactory.finishText());
        textFactory.startText();
        this.pageContext = this.pageContext.update(context);
        BoxDefinition definition = this.boxDefinitionFactory.createBlockBoxDefinition(context, this.layoutProcess.getOutputMetaData());
        TableColumnNode columnGroupNode = new TableColumnNode(definition, context);
        this.getInsertationPoint().addChild(columnGroupNode);
    }

    public void startedTableSection(LayoutContext context) throws NormalizationException {
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(textFactory.finishText());
        textFactory.startText();
        this.pageContext = this.pageContext.update(context);
        BoxDefinition definition = this.boxDefinitionFactory.createBlockBoxDefinition(context, this.layoutProcess.getOutputMetaData());
        TableSectionRenderBox tableRenderBox = new TableSectionRenderBox(definition);
        tableRenderBox.appyStyle(context, this.layoutProcess.getOutputMetaData());
        tableRenderBox.setPageContext(this.pageContext.getPageContext());
        this.getInsertationPoint().addChild(tableRenderBox);
    }

    public void startedTableRow(LayoutContext context) throws NormalizationException {
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(textFactory.finishText());
        textFactory.startText();
        this.pageContext = this.pageContext.update(context);
        BoxDefinition definition = this.boxDefinitionFactory.createBlockBoxDefinition(context, this.layoutProcess.getOutputMetaData());
        TableRowRenderBox tableRenderBox = new TableRowRenderBox(definition, false);
        tableRenderBox.appyStyle(context, this.layoutProcess.getOutputMetaData());
        tableRenderBox.setPageContext(this.pageContext.getPageContext());
        this.getInsertationPoint().addChild(tableRenderBox);
    }

    public void startedTableCell(LayoutContext context) throws NormalizationException {
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(textFactory.finishText());
        textFactory.startText();
        this.pageContext = this.pageContext.update(context);
        BoxDefinition definition = this.boxDefinitionFactory.createBlockBoxDefinition(context, this.layoutProcess.getOutputMetaData());
        TableCellRenderBox tableRenderBox = new TableCellRenderBox(definition);
        tableRenderBox.setPageContext(this.pageContext.getPageContext());
        tableRenderBox.appyStyle(context, this.layoutProcess.getOutputMetaData());
        this.getInsertationPoint().addChild(tableRenderBox);
    }

    public void startedBlock(LayoutContext context) throws NormalizationException {
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(textFactory.finishText());
        textFactory.startText();
        this.pageContext = this.pageContext.update(context);
        BoxDefinition definition = this.boxDefinitionFactory.createBlockBoxDefinition(context, this.layoutProcess.getOutputMetaData());
        BlockRenderBox blockBox = new BlockRenderBox(definition);
        blockBox.appyStyle(context, this.layoutProcess.getOutputMetaData());
        blockBox.setPageContext(this.pageContext.getPageContext());
        this.getInsertationPoint().addChild(blockBox);
    }

    public void startedMarker(LayoutContext context) throws NormalizationException {
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(textFactory.finishText());
        textFactory.startText();
        this.pageContext = this.pageContext.update(context);
        BoxDefinition definition = this.boxDefinitionFactory.createInlineBoxDefinition(context, this.layoutProcess.getOutputMetaData());
        MarkerRenderBox markerBox = new MarkerRenderBox(definition);
        markerBox.appyStyle(context, this.layoutProcess.getOutputMetaData());
        markerBox.setPageContext(this.pageContext.getPageContext());
        this.getInsertationPoint().addChild(markerBox);
    }

    public void startedRootInline(LayoutContext context) throws NormalizationException {
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(textFactory.finishText());
        textFactory.startText();
        this.pageContext = this.pageContext.update(context);
        BoxDefinition definition = this.boxDefinitionFactory.createBlockBoxDefinition(context, this.layoutProcess.getOutputMetaData());
        ParagraphRenderBox paragraphBox = new ParagraphRenderBox(definition);
        paragraphBox.appyStyle(context, this.layoutProcess.getOutputMetaData());
        paragraphBox.setPageContext(this.pageContext.getPageContext());
        RenderBox insertationPoint = this.getInsertationPoint();
        insertationPoint.addChild(paragraphBox);
    }

    public void startedInline(LayoutContext context) throws NormalizationException {
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(textFactory.finishText());
        this.pageContext = this.pageContext.update(context);
        BoxDefinition definition = this.boxDefinitionFactory.createInlineBoxDefinition(context, this.layoutProcess.getOutputMetaData());
        InlineRenderBox inlineBox = new InlineRenderBox(definition);
        inlineBox.appyStyle(context, this.layoutProcess.getOutputMetaData());
        inlineBox.setPageContext(this.pageContext.getPageContext());
        RenderBox insertationPoint = this.getInsertationPoint();
        insertationPoint.addChild(inlineBox);
    }

    public void addContent(LayoutContext context, ContentToken content) throws NormalizationException {
        ComputedToken parent;
        ResolvedToken resolvedToken;
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        if (content instanceof GenericType) {
            RenderableReplacedContent replacedContent;
            Object raw;
            GenericType generic = (GenericType)content;
            ResourceKey source = null;
            if (content instanceof ResourceType) {
                ResourceType resourceType = (ResourceType)content;
                source = resourceType.getContent().getSource();
            }
            if ((raw = generic.getRaw()) instanceof Image) {
                replacedContent = this.createImage((Image)raw, source, context);
                if (replacedContent != null) {
                    replacedContent.appyStyle(context, this.layoutProcess.getOutputMetaData());
                    this.getInsertationPoint().addChilds(textFactory.finishText());
                    this.getInsertationPoint().addChild(replacedContent);
                    this.tryValidateOutput(null);
                    return;
                }
            } else if (raw instanceof Drawable && (replacedContent = this.createDrawable((Drawable)raw, source, context)) != null) {
                replacedContent.appyStyle(context, this.layoutProcess.getOutputMetaData());
                this.getInsertationPoint().addChilds(textFactory.finishText());
                this.getInsertationPoint().addChild(replacedContent);
                this.tryValidateOutput(null);
                return;
            }
        }
        if (content instanceof ResolvedCounterToken) {
            resolvedToken = (ResolvedCounterToken)content;
            if (!this.isProcessingNormalFlow()) {
                this.getInsertationPoint().addChilds(textFactory.finishText());
                try {
                    RenderableTextBox token = new RenderableTextBox(textFactory.saveState(), resolvedToken, context);
                    token.appyStyle(context, this.getLayoutProcess().getOutputMetaData());
                    this.getInsertationPoint().addChild(token);
                    token.close();
                    this.tryValidateOutput(null);
                    return;
                }
                catch (StateException se) {
                    throw new NormalizationException("State failed.", (Exception)((Object)se));
                }
            }
        }
        if (context instanceof ResolvedStringToken && (parent = ((ResolvedStringToken)(resolvedToken = (ResolvedStringToken)((Object)context))).getParent()) instanceof VariableToken && !this.isProcessingNormalFlow()) {
            this.getInsertationPoint().addChilds(textFactory.finishText());
            try {
                RenderableTextBox token = new RenderableTextBox(textFactory.saveState(), resolvedToken, context);
                token.appyStyle(context, this.getLayoutProcess().getOutputMetaData());
                this.getInsertationPoint().addChild(token);
                token.close();
                this.tryValidateOutput(null);
                return;
            }
            catch (StateException se) {
                throw new NormalizationException("State failed.", (Exception)((Object)se));
            }
        }
        if (content instanceof TextType) {
            TextType textRaw = (TextType)content;
            String textStr = textRaw.getText();
            RenderNode[] text = this.createText(textStr, context);
            if (text.length == 0) {
                return;
            }
            RenderBox insertationPoint = this.getInsertationPoint();
            insertationPoint.addChilds(text);
            this.tryValidateOutput(null);
        }
    }

    private RenderNode[] createText(String str, LayoutContext context) {
        if (this.buffer != null) {
            this.buffer.setCursor(0);
        }
        this.buffer = Utf16LE.getInstance().decodeString(str, this.buffer);
        int[] data = this.buffer.getBuffer();
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        return textFactory.createText(data, 0, this.buffer.getLength(), context);
    }

    private RenderableReplacedContent createImage(Image image, ResourceKey source, LayoutContext context) {
        WaitingImageObserver wobs = new WaitingImageObserver(image);
        wobs.waitImageLoaded();
        if (wobs.isError()) {
            return null;
        }
        CSSValue widthVal = context.getValue(BoxStyleKeys.WIDTH);
        RenderLength width = DefaultBoxDefinitionFactory.computeWidth(widthVal, context, this.layoutProcess.getOutputMetaData(), true, false);
        CSSValue heightVal = context.getValue(BoxStyleKeys.HEIGHT);
        RenderLength height = DefaultBoxDefinitionFactory.computeWidth(heightVal, context, this.layoutProcess.getOutputMetaData(), true, false);
        StrictDimension dims = StrictGeomUtility.createDimension(image.getWidth(null), image.getHeight(null));
        CSSValue valign = context.getValue(LineStyleKeys.VERTICAL_ALIGN);
        return new RenderableReplacedContent(image, source, dims, width, height, valign);
    }

    private RenderableReplacedContent createDrawable(Drawable image, ResourceKey source, LayoutContext context) {
        StrictDimension dims = new StrictDimension();
        if (image instanceof ExtendedDrawable) {
            ExtendedDrawable ext = (ExtendedDrawable)image;
            Dimension preferredSize = ext.getPreferredSize();
            dims.setWidth(StrictGeomUtility.toInternalValue(preferredSize.getWidth()));
            dims.setHeight(StrictGeomUtility.toInternalValue(preferredSize.getHeight()));
        }
        CSSValue widthVal = context.getValue(BoxStyleKeys.WIDTH);
        RenderLength width = DefaultBoxDefinitionFactory.computeWidth(widthVal, context, this.layoutProcess.getOutputMetaData(), true, false);
        CSSValue heightVal = context.getValue(BoxStyleKeys.HEIGHT);
        RenderLength height = DefaultBoxDefinitionFactory.computeWidth(heightVal, context, this.layoutProcess.getOutputMetaData(), true, false);
        CSSValue valign = context.getValue(LineStyleKeys.VERTICAL_ALIGN);
        return new RenderableReplacedContent(image, source, dims, width, height, valign);
    }

    public void finishedInline() throws NormalizationException {
        RenderBox insertationPoint = this.getInsertationPoint();
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        RenderNode[] nodes = textFactory.finishText();
        insertationPoint.addChilds(nodes);
        insertationPoint.close();
        this.tryValidateOutput(insertationPoint.getInstanceId());
    }

    public void finishedRootInline() throws NormalizationException {
        RenderBox insertationPoint = this.getInsertationPoint();
        if (!(insertationPoint instanceof ParagraphPoolBox)) {
            this.getInsertationPoint();
            throw new IllegalStateException("Assertation: A rootInline must call close on a pool box");
        }
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        RenderNode[] nodes = textFactory.finishText();
        insertationPoint.addChilds(nodes);
        insertationPoint.close();
        this.tryValidateOutput(insertationPoint.getInstanceId());
    }

    public void finishedMarker() throws NormalizationException {
        RenderBox insertationPoint = this.getInsertationPoint();
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        RenderNode[] nodes = textFactory.finishText();
        insertationPoint.addChilds(nodes);
        insertationPoint.close();
        this.tryValidateOutput(insertationPoint.getInstanceId());
    }

    public void finishedBlock() throws NormalizationException {
        RenderBox insertationPoint = this.getInsertationPoint();
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        insertationPoint.addChilds(textFactory.finishText());
        insertationPoint.close();
        this.tryValidateOutput(insertationPoint.getInstanceId());
    }

    public void finishedTableCell() throws NormalizationException {
        RenderBox insertationPoint = this.getInsertationPoint();
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        insertationPoint.addChilds(textFactory.finishText());
        insertationPoint.close();
        this.isValidatable(insertationPoint);
    }

    public void finishedTableRow() throws NormalizationException {
        RenderBox insertationPoint = this.getInsertationPoint();
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        insertationPoint.addChilds(textFactory.finishText());
        insertationPoint.close();
        this.tryValidateOutput(insertationPoint.getInstanceId());
    }

    public void finishedTableSection() throws NormalizationException {
        RenderBox insertationPoint = this.getInsertationPoint();
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        insertationPoint.addChilds(textFactory.finishText());
        insertationPoint.close();
        this.tryValidateOutput(insertationPoint.getInstanceId());
    }

    public void finishedTableColumnGroup() throws NormalizationException {
        RenderBox insertationPoint = this.getInsertationPoint();
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        insertationPoint.addChilds(textFactory.finishText());
        insertationPoint.close();
    }

    public void finishedTableColumn() throws NormalizationException {
        RenderBox insertationPoint = this.getInsertationPoint();
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        insertationPoint.addChilds(textFactory.finishText());
    }

    public void finishedTable() throws NormalizationException {
        RenderBox insertationPoint = this.getInsertationPoint();
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        insertationPoint.addChilds(textFactory.finishText());
        insertationPoint.close();
        this.tryValidateOutput(insertationPoint.getInstanceId());
    }

    public void finishedFlow() throws NormalizationException {
        RenderBox insertationPoint = this.getInsertationPoint();
        RenderableTextFactory textFactory = this.getCurrentTextFactory();
        insertationPoint.addChilds(textFactory.finishText());
        insertationPoint.close();
        this.flowContexts.pop();
        this.tryValidateOutput(insertationPoint.getInstanceId());
    }

    public void finishedDocument() throws NormalizationException {
        this.logicalPageBox.close();
        this.tryValidateOutput(this.logicalPageBox.getInstanceId());
    }

    public RenderPageContext getPageContext() {
        return this.pageContext;
    }

    public void handlePageBreak(PageContext pageContext) {
        if (pageContext == null) {
            throw new NullPointerException();
        }
        this.pageContext = this.pageContext.update(pageContext, this.layoutProcess.getOutputProcessor());
        PageGrid pageGrid = this.pageContext.createPageGrid(this.layoutProcess.getOutputMetaData());
        this.pendingStore = (ContentStore)this.pendingStore.derive();
        this.elementsStore = (ContentStore)this.elementsStore.derive();
        this.logicalPageBox.updatePageArea(pageGrid);
    }

    public void startedPassThrough(LayoutContext context) {
    }

    public void addPassThroughContent(LayoutContext context, ContentToken content) {
    }

    public void finishedPassThrough() {
    }

    public void startedTableCaption(LayoutContext context) throws NormalizationException {
    }

    public void finishedTableCaption() throws NormalizationException {
    }

    protected static abstract class RendererState
    implements State {
        private BoxDefinitionFactory boxDefinitionFactory;
        private State pageContext;
        private int bufferLength;
        private LogicalPageBox logicalPageBox;
        private ContentStore elementsStore;
        private ContentStore pendingStore;
        private FlowContext.FlowContextState[] flowContexts;

        protected RendererState(AbstractRenderer renderer) throws StateException {
            this.boxDefinitionFactory = renderer.boxDefinitionFactory;
            if (renderer.pageContext != null) {
                this.pageContext = renderer.pageContext.saveState();
            }
            if (renderer.buffer != null) {
                this.bufferLength = renderer.buffer.getData().length;
            }
            if (renderer.logicalPageBox != null) {
                this.logicalPageBox = (LogicalPageBox)renderer.logicalPageBox.hibernate();
                if (LibLayoutBoot.isAsserationEnabled()) {
                    CheckHibernationLayoutStep step = new CheckHibernationLayoutStep();
                    step.startProcessing(this.logicalPageBox);
                }
            }
            try {
                this.elementsStore = (ContentStore)renderer.elementsStore.clone();
                this.pendingStore = (ContentStore)renderer.pendingStore.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new StateException();
            }
            FastStack renderFlowContexts = renderer.flowContexts;
            this.flowContexts = new FlowContext.FlowContextState[renderFlowContexts.size()];
            for (int i = 0; i < renderFlowContexts.size(); ++i) {
                FlowContext context = (FlowContext)renderFlowContexts.get(i);
                this.flowContexts[i] = context.saveState();
            }
        }

        protected void fill(AbstractRenderer renderer, LayoutProcess layoutProcess) throws StateException {
            if (this.bufferLength > 0) {
                renderer.buffer = new CodePointBuffer(this.bufferLength);
            }
            try {
                renderer.elementsStore = (ContentStore)this.elementsStore.clone();
                renderer.pendingStore = (ContentStore)this.pendingStore.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new StateException();
            }
            renderer.boxDefinitionFactory = this.boxDefinitionFactory;
            if (this.pageContext != null) {
                renderer.pageContext = (RenderPageContext)this.pageContext.restore(layoutProcess);
            }
            if (this.logicalPageBox != null) {
                renderer.logicalPageBox = (LogicalPageBox)this.logicalPageBox.derive(true);
            }
            renderer.flowContexts = new FastStack();
            for (int i = 0; i < this.flowContexts.length; ++i) {
                FlowContext.FlowContextState state = this.flowContexts[i];
                Object currentFlowId = state.getCurrentFlowId();
                State textFactoryState = state.getTextFactoryState();
                RenderableTextFactory textFactory = (RenderableTextFactory)textFactoryState.restore(layoutProcess);
                NormalFlowRenderBox box = (NormalFlowRenderBox)renderer.logicalPageBox.findNodeById(currentFlowId);
                if (box == null) {
                    throw new StateException("No Such normal flow.");
                }
                renderer.flowContexts.push((Object)new FlowContext(textFactory, box));
            }
        }
    }
}

