/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.output.pageable;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.jfree.layouting.input.style.keys.border.BorderStyle;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.border.BorderCorner;
import org.jfree.layouting.renderer.border.BorderEdge;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.util.geom.StrictGeomUtility;
import org.jfree.layouting.util.geom.StrictInsets;

public class BorderShapeFactory {
    private static final int CORNER_RIGHT_TOP = 0;
    private static final int CORNER_TOP_RIGHT = 1;
    private static final int CORNER_TOP_LEFT = 2;
    private static final int CORNER_LEFT_TOP = 3;
    private static final int CORNER_LEFT_BOTTOM = 4;
    private static final int CORNER_BOTTOM_LEFT = 5;
    private static final int CORNER_BOTTOM_RIGHT = 6;
    private static final int CORNER_RIGHT_BOTTOM = 7;
    private static final byte[][] CORNER_FACTORS = new byte[][]{{1, 1}, {1, 1}, {-1, 1}, {-1, 1}, {1, -1}, {1, -1}, {-1, -1}, {-1, -1}};
    private Color color;
    private BasicStroke stroke;
    private double height;
    private double width;
    private double x;
    private double y;
    private Border border;
    private StrictInsets borderSizes;
    private ArrayList drawOps = new ArrayList();
    private ArrayList fillOps = new ArrayList();
    private CSSColorValue backgroundColor;

    public BorderShapeFactory(RenderBox box) {
        this.border = box.getBorder();
        ComputedLayoutProperties layoutProperties = box.getComputedLayoutProperties();
        StrictInsets bWidths = new StrictInsets(layoutProperties.getBorderTop(), layoutProperties.getBorderLeft(), layoutProperties.getBorderBottom(), layoutProperties.getBorderRight());
        this.x = StrictGeomUtility.toExternalValue(box.getX() + bWidths.getLeft() / 2L);
        this.y = StrictGeomUtility.toExternalValue(box.getY() + bWidths.getTop() / 2L);
        this.width = StrictGeomUtility.toExternalValue(box.getWidth() - (bWidths.getLeft() + bWidths.getRight()) / 2L);
        this.height = StrictGeomUtility.toExternalValue(box.getHeight() - (bWidths.getTop() + bWidths.getBottom()) / 2L);
        this.borderSizes = bWidths;
        this.backgroundColor = box.getBoxDefinition().getBackgroundColor();
    }

    private Arc2D generateCorner(int type, double cornerX, double cornerY, BorderCorner corner, boolean fillShape) {
        if (corner.getHeight().getValue() == 0L || corner.getWidth().getValue() == 0L) {
            return null;
        }
        byte[] cornerFactors = CORNER_FACTORS[type];
        double widthTopLeft = StrictGeomUtility.toExternalValue(corner.getWidth().getValue());
        double heightTopLeft = StrictGeomUtility.toExternalValue(corner.getHeight().getValue());
        int open = fillShape ? 2 : 0;
        return new Arc2D.Double(cornerX + widthTopLeft * (double)cornerFactors[0], cornerY + heightTopLeft * (double)cornerFactors[1], widthTopLeft, heightTopLeft, Math.PI * (double)type / 4.0, 0.7853981633974483, open);
    }

    private BasicStroke createStroke(BorderEdge edge, long internalWidth) {
        float effectiveWidth = (float)StrictGeomUtility.toExternalValue(internalWidth);
        if (BorderStyle.DASHED.equals(edge.getBorderStyle())) {
            return new BasicStroke(effectiveWidth, 2, 0, 10.0f, new float[]{6.0f * effectiveWidth, 6.0f * effectiveWidth}, 0.0f);
        }
        if (BorderStyle.DOTTED.equals(edge.getBorderStyle())) {
            return new BasicStroke(effectiveWidth, 2, 0, 5.0f, new float[]{0.0f, 2.0f * effectiveWidth}, 0.0f);
        }
        if (BorderStyle.DOT_DASH.equals(edge.getBorderStyle())) {
            return new BasicStroke(effectiveWidth, 2, 0, 10.0f, new float[]{0.0f, 2.0f * effectiveWidth, 6.0f * effectiveWidth, 2.0f * effectiveWidth}, 0.0f);
        }
        if (BorderStyle.DOT_DOT_DASH.equals(edge.getBorderStyle())) {
            return new BasicStroke(effectiveWidth, 2, 0, 10.0f, new float[]{0.0f, 2.0f * effectiveWidth, 0.0f, 2.0f * effectiveWidth, 6.0f * effectiveWidth, 2.0f * effectiveWidth}, 0.0f);
        }
        return new BasicStroke(effectiveWidth);
    }

    public void generateBorder(Graphics2D g2) {
        BorderDrawOperation operation;
        int i;
        this.generateTopEdge();
        this.generateLeftEdge();
        this.generateBottomEdge();
        this.generateRightEdge();
        for (i = 0; i < this.drawOps.size(); ++i) {
            operation = (BorderDrawOperation)this.drawOps.get(i);
            operation.draw(g2);
        }
        for (i = 0; i < this.fillOps.size(); ++i) {
            operation = (BorderDrawOperation)this.fillOps.get(i);
            operation.fill(g2);
        }
        if (this.backgroundColor == null || this.backgroundColor.getAlpha() == 0) {
            return;
        }
        Area globalArea = new Area(new Rectangle2D.Double(this.x, this.y, this.width, this.height));
        for (int i2 = 0; i2 < this.fillOps.size(); ++i2) {
            BorderDrawOperation operation2 = (BorderDrawOperation)this.fillOps.get(i2);
            Shape shape = operation2.shape;
            if (shape == null) continue;
            Area cornerArea = new Area(shape.getBounds2D());
            cornerArea.subtract(new Area(shape));
            globalArea.subtract(cornerArea);
        }
        g2.setColor(this.backgroundColor);
        g2.fill(globalArea);
    }

    private void draw(Shape s) {
        if (s == null) {
            return;
        }
        this.drawOps.add(new BorderDrawOperation(s, this.color, this.stroke));
    }

    private void fill(Shape s) {
        if (s == null) {
            return;
        }
        this.fillOps.add(new BorderDrawOperation(s, this.color, this.stroke));
    }

    private void generateRightEdge() {
        BorderEdge rightEdge = this.border.getRight();
        this.color = rightEdge.getColor();
        this.stroke = this.createStroke(rightEdge, this.borderSizes.getRight());
        BorderCorner firstCorner = this.border.getBottomRight();
        BorderCorner secondCorner = this.border.getTopRight();
        this.draw(this.generateCorner(7, this.x + this.width, this.y + this.height, firstCorner, false));
        this.draw(this.generateCorner(0, this.x + this.width, this.y, secondCorner, false));
        this.fill(this.generateCorner(7, this.x + this.width, this.y + this.height, firstCorner, true));
        this.fill(this.generateCorner(0, this.x + this.width, this.y, secondCorner, true));
        this.draw(new Line2D.Double(this.x + this.width - (double)firstCorner.getWidth().getValue(), this.y + this.height - (double)firstCorner.getHeight().getValue(), this.x + this.width - (double)secondCorner.getWidth().getValue(), this.y + (double)secondCorner.getHeight().getValue()));
    }

    private void generateBottomEdge() {
        BorderEdge bottomEdge = this.border.getBottom();
        BorderCorner firstCorner = this.border.getBottomLeft();
        BorderCorner secondCorner = this.border.getBottomRight();
        this.color = bottomEdge.getColor();
        this.stroke = this.createStroke(bottomEdge, this.borderSizes.getBottom());
        this.draw(this.generateCorner(5, this.x, this.y + this.height, firstCorner, false));
        this.draw(this.generateCorner(6, this.x + this.width, this.y + this.height, secondCorner, false));
        this.fill(this.generateCorner(5, this.x, this.y + this.height, firstCorner, true));
        this.fill(this.generateCorner(6, this.x + this.width, this.y + this.height, secondCorner, true));
        this.draw(new Line2D.Double(this.x + (double)firstCorner.getWidth().getValue(), this.y + this.height - (double)firstCorner.getHeight().getValue(), this.x + this.width - (double)secondCorner.getWidth().getValue(), this.y + this.height - (double)secondCorner.getHeight().getValue()));
    }

    private void generateLeftEdge() {
        BorderEdge leftEdge = this.border.getLeft();
        BorderCorner firstCorner = this.border.getTopLeft();
        BorderCorner secondCorner = this.border.getBottomLeft();
        this.stroke = this.createStroke(leftEdge, this.borderSizes.getLeft());
        this.color = leftEdge.getColor();
        this.draw(this.generateCorner(3, this.x, this.y, firstCorner, false));
        this.draw(this.generateCorner(4, this.x, this.y + this.height, secondCorner, false));
        this.fill(this.generateCorner(3, this.x, this.y, firstCorner, true));
        this.fill(this.generateCorner(4, this.x, this.y + this.height, secondCorner, true));
        double firstWidth = StrictGeomUtility.toInternalValue(firstCorner.getWidth().getValue());
        double firstHeight = StrictGeomUtility.toInternalValue(firstCorner.getHeight().getValue());
        double secondWidth = StrictGeomUtility.toInternalValue(secondCorner.getWidth().getValue());
        double secondHeight = StrictGeomUtility.toInternalValue(secondCorner.getHeight().getValue());
        this.draw(new Line2D.Double(this.x + firstWidth, this.y + firstHeight, this.x + secondWidth, this.y + this.height - secondHeight));
    }

    private boolean isSimpleStyle(CSSValue value) {
        if (BorderStyle.GROOVE.equals(value)) {
            return false;
        }
        return !BorderStyle.RIDGE.equals(value);
    }

    private void generateTopEdge() {
        BorderEdge topEdge = this.border.getTop();
        this.stroke = this.createStroke(topEdge, this.borderSizes.getTop());
        this.color = topEdge.getColor();
        BorderCorner firstCorner = this.border.getTopLeft();
        BorderCorner secondCorner = this.border.getBottomLeft();
        this.draw(this.generateCorner(1, this.x + this.width, this.y, this.border.getTopRight(), false));
        this.draw(this.generateCorner(2, this.x, this.y, this.border.getTopLeft(), false));
        double firstWidth = StrictGeomUtility.toInternalValue(firstCorner.getWidth().getValue());
        double firstHeight = StrictGeomUtility.toInternalValue(firstCorner.getHeight().getValue());
        double secondWidth = StrictGeomUtility.toInternalValue(secondCorner.getWidth().getValue());
        double secondHeight = StrictGeomUtility.toInternalValue(secondCorner.getHeight().getValue());
        this.draw(new Line2D.Double(this.x + firstWidth, this.y + firstHeight, this.x + this.width - secondWidth, this.y + secondHeight));
        this.fill(this.generateCorner(1, this.x + this.width, this.y, this.border.getTopRight(), true));
        this.fill(this.generateCorner(2, this.x, this.y, this.border.getTopLeft(), true));
    }

    public static class BorderDrawOperation {
        private Color color;
        private BasicStroke stroke;
        private Shape shape;

        public BorderDrawOperation(Shape shape, Color color, BasicStroke stroke) {
            this.shape = shape;
            this.color = color;
            this.stroke = stroke;
        }

        public void draw(Graphics2D g2) {
            if (this.shape == null) {
                return;
            }
            if (this.stroke.getLineWidth() == 0.0f) {
                return;
            }
            if (this.color.getAlpha() == 0) {
                return;
            }
            g2.setStroke(this.stroke);
            g2.setColor(this.color);
            g2.draw(this.shape);
        }

        public void fill(Graphics2D g2) {
            if (this.shape == null) {
                return;
            }
            if (this.stroke.getLineWidth() == 0.0f) {
                return;
            }
            if (this.color.getAlpha() == 0) {
                return;
            }
            g2.setStroke(this.stroke);
            g2.setColor(this.color);
            g2.fill(this.shape);
        }
    }
}

