/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.output;

import java.util.HashMap;
import java.util.HashSet;
import org.jfree.fonts.registry.FontContext;
import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontMetrics;
import org.jfree.fonts.registry.FontRecord;
import org.jfree.fonts.registry.FontRegistry;
import org.jfree.fonts.registry.FontStorage;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.style.keys.font.FontFamilyValues;
import org.jfree.layouting.input.style.keys.font.FontSizeConstant;
import org.jfree.layouting.input.style.keys.page.PageSize;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.output.DefaultFontContext;
import org.jfree.layouting.output.OutputProcessorFeature;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.util.ExtendedConfiguration;
import org.jfree.util.Log;

public abstract class AbstractOutputProcessorMetaData
implements OutputProcessorMetaData {
    private HashSet features;
    private HashMap fontSizes;
    private HashMap numericFeatures;
    private HashMap fontFamilies;
    private FontStorage fontStorage;
    private static final Class[] SUPPORTED_TYPES = new Class[]{class$org$jfree$ui$Drawable == null ? (class$org$jfree$ui$Drawable = AbstractOutputProcessorMetaData.class$("org.jfree.ui.Drawable")) : class$org$jfree$ui$Drawable, class$java$awt$Image == null ? (class$java$awt$Image = AbstractOutputProcessorMetaData.class$("java.awt.Image")) : class$java$awt$Image};
    static /* synthetic */ Class class$org$jfree$ui$Drawable;
    static /* synthetic */ Class class$java$awt$Image;

    protected AbstractOutputProcessorMetaData(FontStorage fontStorage) {
        if (fontStorage == null) {
            throw new NullPointerException();
        }
        this.fontStorage = fontStorage;
        this.features = new HashSet();
        this.numericFeatures = new HashMap();
        ExtendedConfiguration extendedConfig = LibLayoutBoot.getInstance().getExtendedConfig();
        double defaultFontSize = extendedConfig.getIntProperty("org.jfree.layouting.defaults.FontSize", 12);
        int xxSmall = extendedConfig.getIntProperty("org.jfree.layouting.defaults.FontSizeFactor.xx-small", 60);
        int xSmall = extendedConfig.getIntProperty("org.jfree.layouting.defaults.FontSizeFactor.x-small", 75);
        int small = extendedConfig.getIntProperty("org.jfree.layouting.defaults.FontSizeFactor.small", 89);
        int medium = extendedConfig.getIntProperty("org.jfree.layouting.defaults.FontSizeFactor.medium", 100);
        int large = extendedConfig.getIntProperty("org.jfree.layouting.defaults.FontSizeFactor.large", 120);
        int xLarge = extendedConfig.getIntProperty("org.jfree.layouting.defaults.FontSizeFactor.x-large", 150);
        int xxLarge = extendedConfig.getIntProperty("org.jfree.layouting.defaults.FontSizeFactor.xx-large", 200);
        this.fontSizes = new HashMap();
        this.fontSizes.put(FontSizeConstant.XX_SMALL, new Double(defaultFontSize * (double)xxSmall / 100.0));
        this.fontSizes.put(FontSizeConstant.X_SMALL, new Double(defaultFontSize * (double)xSmall / 100.0));
        this.fontSizes.put(FontSizeConstant.SMALL, new Double(defaultFontSize * (double)small / 100.0));
        this.fontSizes.put(FontSizeConstant.MEDIUM, new Double(defaultFontSize * (double)medium / 100.0));
        this.fontSizes.put(FontSizeConstant.LARGE, new Double(defaultFontSize * (double)large / 100.0));
        this.fontSizes.put(FontSizeConstant.X_LARGE, new Double(defaultFontSize * (double)xLarge / 100.0));
        this.fontSizes.put(FontSizeConstant.XX_LARGE, new Double(defaultFontSize * (double)xxLarge / 100.0));
        this.fontFamilies = new HashMap();
        this.setNumericFeatureValue(OutputProcessorFeature.DEFAULT_FONT_SIZE, defaultFontSize);
        double fontSmoothThreshold = extendedConfig.getIntProperty("org.jfree.layouting.defaults.FontSmoothThreshold", 8);
        this.setNumericFeatureValue(OutputProcessorFeature.FONT_SMOOTH_THRESHOLD, fontSmoothThreshold);
    }

    protected void setFamilyMapping(CSSConstant family, String name) {
        if (family == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.fontFamilies.put(family, name);
    }

    public double getFontSize(CSSConstant constant) {
        Double d = (Double)this.fontSizes.get(constant);
        if (d == null) {
            return this.getNumericFeatureValue(OutputProcessorFeature.DEFAULT_FONT_SIZE);
        }
        return d;
    }

    protected void addFeature(OutputProcessorFeature.BooleanOutputProcessorFeature feature) {
        if (feature == null) {
            throw new NullPointerException();
        }
        this.features.add(feature);
    }

    public boolean isFeatureSupported(OutputProcessorFeature.BooleanOutputProcessorFeature feature) {
        if (feature == null) {
            throw new NullPointerException();
        }
        return this.features.contains(feature);
    }

    protected void setNumericFeatureValue(OutputProcessorFeature.NumericOutputProcessorFeature feature, double value) {
        if (feature == null) {
            throw new NullPointerException();
        }
        this.numericFeatures.put(feature, new Double(value));
    }

    public double getNumericFeatureValue(OutputProcessorFeature.NumericOutputProcessorFeature feature) {
        if (feature == null) {
            throw new NullPointerException();
        }
        Double d = (Double)this.numericFeatures.get(feature);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public FontStorage getFontStorage() {
        return this.fontStorage;
    }

    public String getNormalizedFontFamilyName(String name) {
        String normalizedFontFamily = (String)this.fontFamilies.get(name);
        if (normalizedFontFamily == null) {
            return name;
        }
        return normalizedFontFamily;
    }

    public FontFamily getFontFamilyForGenericName(CSSConstant genericName) {
        if (FontFamilyValues.NONE.equals(genericName)) {
            return null;
        }
        String name = (String)this.fontFamilies.get(genericName);
        if (name == null) {
            return this.getDefaultFontFamily();
        }
        FontFamily ff = this.fontStorage.getFontRegistry().getFontFamily(name);
        if (ff != null) {
            return ff;
        }
        return this.getDefaultFontFamily();
    }

    protected FontRegistry getFontRegistry() {
        return this.fontStorage.getFontRegistry();
    }

    public PageSize getDefaultPageSize() {
        return PageSize.A4;
    }

    public int getVerticalPageSpan() {
        return 1;
    }

    public int getHorizontalPageSpan() {
        return 1;
    }

    public String getMediaType() {
        return "print";
    }

    public boolean isValid(FontSpecification spec) {
        FontRegistry registry = this.getFontRegistry();
        String fontFamily = spec.getFontFamily();
        if (fontFamily == null) {
            return false;
        }
        FontFamily family = registry.getFontFamily(fontFamily);
        return family != null;
    }

    public FontMetrics getFontMetrics(FontSpecification spec) {
        String fontFamily = spec.getFontFamily();
        if (fontFamily == null) {
            Log.warn((Object)"No font family specified.");
            return null;
        }
        FontRegistry registry = this.getFontRegistry();
        FontFamily family = registry.getFontFamily(fontFamily);
        if (family == null) {
            Log.warn((Object)"Unable to lookup the font family.");
            return null;
        }
        DefaultFontContext fontContext = new DefaultFontContext(this, spec.isAntiAliasing(), spec.getFontSize(), "UTF-8", false);
        FontRecord record = family.getFontRecord(spec.getFontWeight() > 600, spec.isItalic() || spec.isOblique());
        FontMetrics fm = this.getFontStorage().getFontMetrics(record.getIdentifier(), (FontContext)fontContext);
        if (fm == null) {
            throw new NullPointerException("FontMetrics returned from factory is null.");
        }
        return fm;
    }

    public Class[] getSupportedResourceTypes() {
        return (Class[])SUPPORTED_TYPES.clone();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

