/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.normalizer.generator;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.generator.ContentGenerator;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.util.Log;

public class PrintContentGenerator
implements ContentGenerator {
    private Renderer renderer;

    public PrintContentGenerator(LayoutProcess layoutProcess) {
        this.renderer = layoutProcess.getOutputProcessor().createRenderer(layoutProcess);
    }

    public PrintContentGenerator(Renderer renderer) {
        this.renderer = renderer;
    }

    public void startedDocument(PageContext pageContext) {
        Log.debug((Object)"<document>");
        this.renderer.startedDocument(pageContext);
    }

    public void startedFlow(LayoutContext element) throws NormalizationException {
        Log.debug((Object)("<flow tag='" + element.getTagName() + "'>"));
        this.renderer.startedFlow(element);
    }

    public void startedTable(LayoutContext element) throws NormalizationException {
        Log.debug((Object)"<table>");
        this.renderer.startedTable(element);
    }

    public void startedTableColumnGroup(LayoutContext element) throws NormalizationException {
        Log.debug((Object)"<table-col-group>");
        this.renderer.startedTableColumnGroup(element);
    }

    public void startedTableColumn(LayoutContext element) throws NormalizationException {
        Log.debug((Object)"<table-col>");
        this.renderer.startedTableColumn(element);
    }

    public void startedTableSection(LayoutContext element) throws NormalizationException {
        Log.debug((Object)"<table-section>");
        this.renderer.startedTableSection(element);
    }

    public void startedTableRow(LayoutContext element) throws NormalizationException {
        Log.debug((Object)"<table-row>");
        this.renderer.startedTableRow(element);
    }

    public void startedTableCell(LayoutContext element) throws NormalizationException {
        Log.debug((Object)"<table-cell>");
        this.renderer.startedTableCell(element);
    }

    public void startedBlock(LayoutContext element) throws NormalizationException {
        String tagName = element.getTagName();
        Log.debug((Object)("<block tag='" + tagName + "'>"));
        this.renderer.startedBlock(element);
    }

    public void startedRootInline(LayoutContext element) throws NormalizationException {
        String tagName = element.getTagName();
        Log.debug((Object)("<paragraph tag='" + tagName + "'>"));
        this.renderer.startedRootInline(element);
    }

    public void startedMarker(LayoutContext element) throws NormalizationException {
        Log.debug((Object)"<marker>");
        this.renderer.startedMarker(element);
    }

    public void startedInline(LayoutContext element) throws NormalizationException {
        String tagName = element.getTagName();
        Log.debug((Object)("<inline tag='" + tagName + "'>"));
        this.renderer.startedInline(element);
    }

    public void addContent(LayoutContext node, ContentToken token) throws NormalizationException {
        Log.debug((Object)("<content>" + token + "</content>"));
        this.renderer.addContent(node, token);
    }

    public void finishedInline() throws NormalizationException {
        Log.debug((Object)"</inline>");
        this.renderer.finishedInline();
    }

    public void finishedMarker() throws NormalizationException {
        Log.debug((Object)"</marker>");
        this.renderer.finishedMarker();
    }

    public void finishedRootInline() throws NormalizationException {
        Log.debug((Object)"</paragraph>");
        this.renderer.finishedRootInline();
    }

    public void finishedBlock() throws NormalizationException {
        Log.debug((Object)"</block>");
        this.renderer.finishedBlock();
    }

    public void finishedTableCell() throws NormalizationException {
        Log.debug((Object)"</table-cell>");
        this.renderer.finishedTableCell();
    }

    public void finishedTableRow() throws NormalizationException {
        Log.debug((Object)"</table-row>");
        this.renderer.finishedTableRow();
    }

    public void finishedTableSection() throws NormalizationException {
        Log.debug((Object)"</table-section>");
        this.renderer.finishedTableSection();
    }

    public void finishedTableColumn() throws NormalizationException {
        Log.debug((Object)"</table-col>");
        this.renderer.finishedTableColumn();
    }

    public void finishedTableColumnGroup() throws NormalizationException {
        Log.debug((Object)"</table-col-group>");
        this.renderer.finishedTableColumnGroup();
    }

    public void finishedTable() throws NormalizationException {
        Log.debug((Object)"</table>");
        this.renderer.finishedTable();
    }

    public void finishedFlow() throws NormalizationException {
        Log.debug((Object)"</flow>");
        this.renderer.finishedFlow();
    }

    public void finishedDocument() throws NormalizationException {
        Log.debug((Object)"</document>");
        this.renderer.finishedDocument();
    }

    public State saveState() throws StateException {
        return new PrintContentGeneratorState(this.renderer.saveState());
    }

    public void handlePageBreak(PageContext pageContext) {
        this.renderer.handlePageBreak(pageContext);
    }

    public void startedPassThrough(LayoutContext element) throws NormalizationException {
        Log.debug((Object)"<pass-through>");
        this.renderer.startedPassThrough(element);
    }

    public void addPassThroughContent(LayoutContext node, ContentToken token) throws NormalizationException {
        Log.debug((Object)("<pass-through-content>" + token + "</pass-through-content>"));
        this.renderer.addPassThroughContent(node, token);
    }

    public void finishedPassThrough() throws NormalizationException {
        Log.debug((Object)"</pass-through>");
        this.renderer.finishedPassThrough();
    }

    public void startedTableCaption(LayoutContext context) throws NormalizationException {
        Log.debug((Object)"<table-caption>");
        this.renderer.startedTableCaption(context);
    }

    public void finishedTableCaption() throws NormalizationException {
        Log.debug((Object)"</table-caption>");
        this.renderer.finishedTableCaption();
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private static class PrintContentGeneratorState
    implements State {
        private State renderer;

        private PrintContentGeneratorState(State renderer) {
            this.renderer = renderer;
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            Renderer renderer = (Renderer)this.renderer.restore(layoutProcess);
            return new PrintContentGenerator(renderer);
        }
    }
}

