/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.normalizer.displaymodel;

import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.util.IntList;
import org.jfree.util.FastStack;

public class FlowContext
implements Cloneable {
    public static final int STATE_OPEN = 0;
    public static final int STATE_SUSPEND = 1;
    public static final int STATE_CLOSE = 2;
    private IntList displayModels = new IntList(30);
    private IntList displayRoles = new IntList(30);
    private IntList elementState = new IntList(30);
    private FastStack layoutContexts = new FastStack();
    private int activeContext;

    public void addElement(int model, int role, LayoutContext lc) {
        this.displayModels.push(model);
        this.displayRoles.push(role);
        this.elementState.push(0);
        this.layoutContexts.push((Object)lc);
        this.activeContext = this.displayModels.size() - 1;
    }

    public int getCurrentDisplayRole() {
        if (this.displayRoles.size() == 0) {
            return 1;
        }
        return this.displayRoles.get(this.activeContext);
    }

    public int getCurrentDisplayModel() {
        if (this.displayModels.size() == 0) {
            return 1;
        }
        return this.displayModels.get(this.activeContext);
    }

    public int getActiveDisplayModel() {
        if (this.displayModels.size() == 0) {
            return 1;
        }
        int index = this.activeContext;
        while (this.elementState.get(index) == 1) {
            --index;
        }
        return this.displayModels.get(index);
    }

    public void suspend() {
        int state = this.elementState.get(this.activeContext);
        if (state != 0) {
            throw new IllegalStateException("Only open elements can be suspended.");
        }
        this.elementState.set(this.activeContext, 1);
        while (this.elementState.get(this.activeContext) == 1) {
            --this.activeContext;
        }
    }

    public int close() {
        int state = this.elementState.pop();
        this.displayRoles.pop();
        this.displayModels.pop();
        this.layoutContexts.pop();
        this.activeContext = Math.min(this.activeContext - 1, this.elementState.size());
        return state;
    }

    public LayoutContext getCurrentLayoutContext() {
        return (LayoutContext)this.layoutContexts.peek();
    }

    public int getCurrentState() {
        return this.elementState.peek();
    }

    public Object clone() throws CloneNotSupportedException {
        FlowContext c = (FlowContext)super.clone();
        c.displayModels = (IntList)this.displayModels.clone();
        c.displayRoles = (IntList)this.displayRoles.clone();
        c.elementState = (IntList)this.elementState.clone();
        c.layoutContexts = (FastStack)this.layoutContexts.clone();
        return c;
    }

    public boolean isEmpty() {
        return this.layoutContexts.isEmpty();
    }
}

