/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.normalizer.content;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.style.resolver.StyleResolver;
import org.jfree.layouting.normalizer.content.Normalizer;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.layouting.util.ChainingComponent;

public final class RecordingContentNormalizer
extends ChainingComponent
implements Normalizer {
    private static final int TYPE_START_DOCUMENT = 1;
    private static final int TYPE_START_ELEMENT = 2;
    private static final int TYPE_ADD_TEXT = 3;
    private static final int TYPE_END_ELEMENT = 4;
    private static final int TYPE_END_DOCUMENT = 5;
    private StringBuffer text = new StringBuffer();
    private int elementDepth;

    public void startDocument() {
        throw new UnsupportedOperationException("Recoding CN cannot start documents.");
    }

    public void startElement(String namespace, String tag, AttributeMap attributes) {
        this.addCall(new ChainingComponent.RecordedCall(2, new Object[]{namespace, tag, attributes}));
        ++this.elementDepth;
    }

    public void addText(String text) {
        this.addCall(new ChainingComponent.RecordedCall(3, text));
        this.text.append(text);
    }

    public void endElement() {
        --this.elementDepth;
        this.addCall(new ChainingComponent.RecordedCall(4, new Object[0]));
    }

    public void endDocument() {
        throw new UnsupportedOperationException("Recoding CN cannot start documents.");
    }

    protected void invoke(Object target, int methodId, Object params) throws Exception {
        Normalizer normalizer = (Normalizer)target;
        switch (methodId) {
            case 1: {
                normalizer.startDocument();
                break;
            }
            case 2: {
                Object[] parameters = (Object[])params;
                normalizer.startElement((String)parameters[0], (String)parameters[1], (AttributeMap)parameters[2]);
                break;
            }
            case 3: {
                normalizer.addText((String)params);
                break;
            }
            case 4: {
                Object[] parameters = (Object[])params;
                normalizer.endElement();
                break;
            }
            case 5: {
                normalizer.endDocument();
                break;
            }
            default: {
                throw new IllegalStateException("Invalid call type");
            }
        }
    }

    public void clear() {
        super.clear();
        this.elementDepth = 0;
        this.text = new StringBuffer();
    }

    public int getElementDepth() {
        return this.elementDepth;
    }

    public State saveState() {
        ChainingComponent.RecordedCall[] calls = this.retrieveRecordedCalls();
        RecodingContentNormalizerState state = new RecodingContentNormalizerState(calls, this.text.toString(), this.elementDepth);
        this.setRecordedCalls(calls);
        return state;
    }

    public String getText() {
        return this.text.toString();
    }

    public void handlePageBreak(CSSValue pageName, PseudoPage[] pseudoPages) {
    }

    public Renderer getRenderer() {
        throw new UnsupportedOperationException();
    }

    public StyleResolver getStyleResolver() {
        throw new UnsupportedOperationException();
    }

    private static class RecodingContentNormalizerState
    implements State {
        private ChainingComponent.RecordedCall[] calls;
        private String text;
        private int elementDepth;

        private RecodingContentNormalizerState(ChainingComponent.RecordedCall[] calls, String text, int elementDepth) {
            this.text = text;
            this.elementDepth = elementDepth;
            this.calls = (ChainingComponent.RecordedCall[])calls.clone();
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            RecordingContentNormalizer rcn = new RecordingContentNormalizer();
            rcn.setRecordedCalls(this.calls);
            rcn.text.append(this.text);
            rcn.elementDepth = this.elementDepth;
            return rcn;
        }
    }
}

