/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.normalizer.content;

import java.io.IOException;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.PageAreaType;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.keys.content.ContentStyleKeys;
import org.jfree.layouting.input.style.keys.content.MoveToValues;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.computed.CloseQuoteToken;
import org.jfree.layouting.layouter.content.computed.ComputedToken;
import org.jfree.layouting.layouter.content.computed.ContentsToken;
import org.jfree.layouting.layouter.content.computed.CounterToken;
import org.jfree.layouting.layouter.content.computed.CountersToken;
import org.jfree.layouting.layouter.content.computed.OpenQuoteToken;
import org.jfree.layouting.layouter.content.computed.VariableToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedCounterToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedCountersToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedStringToken;
import org.jfree.layouting.layouter.content.statics.StaticTextToken;
import org.jfree.layouting.layouter.context.ContentSpecification;
import org.jfree.layouting.layouter.context.ContextId;
import org.jfree.layouting.layouter.context.DefaultLayoutContext;
import org.jfree.layouting.layouter.context.DefaultPageContext;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.context.QuotesPair;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.StyleResolver;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.content.Normalizer;
import org.jfree.layouting.normalizer.content.RecordingContentNormalizer;
import org.jfree.layouting.normalizer.displaymodel.ModelBuilder;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.layouting.util.ChainingCallException;
import org.jfree.layouting.util.IntList;
import org.jfree.util.Log;

public class ContentNormalizer
implements Normalizer {
    private static final long NO_PARENT = -1L;
    private ModelBuilder modelBuilder;
    private LayoutElement currentElement;
    private LayoutElement currentSilbling;
    private LayoutProcess layoutProcess;
    private RecordingContentNormalizer recordingContentNormalizer;
    private long nextId;
    private int ignoreContext;
    private int quoteLevel;
    private StyleResolver styleResolver;

    public ContentNormalizer(LayoutProcess layoutProcess) {
        this(layoutProcess, true);
    }

    protected ContentNormalizer(LayoutProcess layoutProcess, boolean init) {
        if (layoutProcess == null) {
            throw new NullPointerException("LayoutProcess must not be null.");
        }
        this.layoutProcess = layoutProcess;
        this.styleResolver = layoutProcess.getStyleResolver();
        if (init) {
            this.modelBuilder = layoutProcess.getOutputProcessor().createModelBuilder(layoutProcess);
        }
    }

    public void startDocument() throws IOException, NormalizationException {
        this.styleResolver.initialize(this.layoutProcess);
        DefaultPageContext dpc = new DefaultPageContext();
        PageAreaType[] pat = PageAreaType.getPageAreas();
        for (int i = 0; i < pat.length; ++i) {
            PageAreaType pageAreaType = pat[i];
            LayoutStyle style = this.styleResolver.resolvePageStyle(CSSAutoValue.getInstance(), new PseudoPage[0], pageAreaType);
            dpc.setAreaDefinition(pageAreaType, style);
        }
        LayoutStyle areaDefinition = dpc.getAreaDefinition(PageAreaType.CONTENT);
        this.modelBuilder.startDocument(dpc);
    }

    public void startElement(String namespace, String tag, AttributeMap attributes) throws NormalizationException, IOException {
        if (this.recordingContentNormalizer != null) {
            this.recordingContentNormalizer.startElement(namespace, tag, attributes);
            return;
        }
        this.startElementInternal(namespace, tag, null, attributes);
    }

    protected void startElementInternal(String namespace, String tag, String pseudo, AttributeMap attributes) throws NormalizationException, IOException {
        LayoutElement element;
        ContextId ctxId = new ContextId(1, -1L, this.nextId);
        ++this.nextId;
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(ctxId, namespace, tag, pseudo, attributes);
        this.currentElement = element = new LayoutElement(this.currentElement, this.currentSilbling, layoutContext);
        this.currentSilbling = null;
        this.styleResolver.resolveStyle(element);
        if (this.isStringRecordingNeeded(element)) {
            this.recordingContentNormalizer = new RecordingContentNormalizer();
        } else {
            this.startCurrentElement();
        }
    }

    private void startCurrentElement() throws NormalizationException, IOException {
        LayoutContext layoutContext = this.currentElement.getLayoutContext();
        CSSValue displayRole = layoutContext.getValue(BoxStyleKeys.DISPLAY_ROLE);
        if (DisplayRole.NONE.equals(displayRole)) {
            ++this.ignoreContext;
            Log.debug((Object)("Ignoring element (and all childs) of " + layoutContext.getPseudoElement() + " as it has Display:NONE"));
        } else if (this.ignoreContext > 0) {
            ++this.ignoreContext;
        }
        if (DisplayRole.LIST_ITEM.equals(displayRole)) {
            this.currentElement.incrementCounter("list-item", 1);
        }
        if (this.ignoreContext > 0) {
            return;
        }
        ContentSpecification contentSpec = this.currentElement.getLayoutContext().getContentSpecification();
        if (!contentSpec.isAllowContentProcessing()) {
            if (contentSpec.isInhibitContent() && layoutContext.isPseudoElement()) {
                this.modelBuilder.startElement(this.currentElement.detachLayoutContext());
                ++this.ignoreContext;
                return;
            }
            this.generateOutsidePseudoElements(this.currentElement);
            this.modelBuilder.startElement(this.currentElement.detachLayoutContext());
            this.generateBeforePseudoElements(this.currentElement);
            this.generateContentBefore(this.currentElement);
            ++this.ignoreContext;
            return;
        }
        this.generateOutsidePseudoElements(this.currentElement);
        this.modelBuilder.startElement(this.currentElement.detachLayoutContext());
        this.generateBeforePseudoElements(this.currentElement);
        this.generateContentBefore(this.currentElement);
        if (!this.currentElement.isContentsConsumed() && !this.generateAlternateContent(this.currentElement)) {
            ++this.ignoreContext;
        }
    }

    protected boolean generateBeforePseudoElements(LayoutElement element) throws IOException, NormalizationException {
        LayoutContext layoutContext = element.getLayoutContext();
        CSSValue displayRole = layoutContext.getValue(BoxStyleKeys.DISPLAY_ROLE);
        if (DisplayRole.LIST_ITEM.equals(displayRole) && this.styleResolver.isPseudoElementStyleResolvable(element, "marker")) {
            this.startElementInternal(layoutContext.getNamespace(), layoutContext.getTagName(), "marker", layoutContext.getAttributes());
            this.endElement();
        }
        if (this.styleResolver.isPseudoElementStyleResolvable(element, "before")) {
            this.startElementInternal(layoutContext.getNamespace(), layoutContext.getTagName(), "before", layoutContext.getAttributes());
            this.endElement();
        }
        return false;
    }

    private boolean generateAlternateContent(LayoutElement element) throws IOException, NormalizationException {
        if (element.isContentsConsumed()) {
            return false;
        }
        if (this.styleResolver.isPseudoElementStyleResolvable(element, "alternate")) {
            LayoutContext layoutContext = element.getLayoutContext();
            this.startElementInternal(layoutContext.getNamespace(), layoutContext.getTagName(), "alternate", layoutContext.getAttributes());
            if (element.isContentsConsumed()) {
                element.openAlternate();
                return true;
            }
            this.endElement();
        }
        return false;
    }

    private boolean generateOutsidePseudoElements(LayoutElement element) throws IOException, NormalizationException {
        LayoutContext layoutContext = element.getLayoutContext();
        CSSValue value = layoutContext.getValue(ContentStyleKeys.MOVE_TO);
        if (!MoveToValues.HERE.equals(value)) {
            String target;
            if (value == null) {
                target = null;
            } else if (value instanceof CSSStringValue) {
                CSSStringValue sval = (CSSStringValue)value;
                target = sval.getValue();
            } else {
                target = value.getCSSText();
            }
            layoutContext.getContentSpecification().setMoveTarget(target);
            if (this.styleResolver.isPseudoElementStyleResolvable(element, "alternate")) {
                this.startElementInternal(layoutContext.getNamespace(), layoutContext.getTagName(), "alternate", layoutContext.getAttributes());
                if (element.isContentsConsumed()) {
                    element.openAlternate();
                } else {
                    this.endElement();
                }
            }
        }
        return false;
    }

    private boolean isStringRecordingNeeded(LayoutElement element) {
        ContentSpecification contentSpecification = element.getLayoutContext().getContentSpecification();
        ContentToken[] strings = contentSpecification.getStrings();
        LayoutContext layoutContext = element.getLayoutContext();
        CSSValue value = layoutContext.getValue(ContentStyleKeys.STRING_DEFINE);
        if (value == null) {
            return false;
        }
        if (value instanceof CSSValueList) {
            CSSValueList list = (CSSValueList)value;
            if (list.getLength() == 0) {
                return false;
            }
            for (int i = 0; i < list.getLength(); ++i) {
                CSSValue val = list.getItem(i);
                if (!(val instanceof ContentsToken)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean generateContentBefore(LayoutElement element) throws IOException, NormalizationException {
        ContentSpecification cspec = element.getLayoutContext().getContentSpecification();
        ContentToken[] tokens = cspec.getContents();
        for (int i = 0; i < tokens.length; ++i) {
            ContentToken token = tokens[i];
            if (token instanceof ContentsToken) {
                element.setContentsConsumed(true);
                return true;
            }
            if (token instanceof ComputedToken) {
                ContentToken resolved = this.computeToken(token, cspec);
                if (resolved == null) continue;
                this.addContent(resolved);
                continue;
            }
            this.addContent(token);
        }
        return false;
    }

    protected void generateContentAfter(LayoutElement element) throws IOException, NormalizationException {
        ContentToken token;
        int posContent;
        ContentSpecification cspec = element.getLayoutContext().getContentSpecification();
        ContentToken[] tokens = cspec.getContents();
        for (posContent = 0; posContent < tokens.length && !((token = tokens[posContent]) instanceof ContentsToken); ++posContent) {
        }
        ++posContent;
        while (posContent < tokens.length) {
            token = tokens[posContent];
            if (!(token instanceof ContentsToken)) {
                if (token instanceof ComputedToken) {
                    ContentToken resolved = this.computeToken(token, cspec);
                    if (resolved != null) {
                        this.addContent(resolved);
                    }
                } else {
                    this.addContent(token);
                }
            }
            ++posContent;
        }
    }

    protected void generateStrings(LayoutElement element) throws IOException, NormalizationException {
        ContentSpecification cspec = element.getLayoutContext().getContentSpecification();
        ContentToken[] tokens = cspec.getContents();
        boolean contentGiven = false;
        for (int posContent = 0; posContent < tokens.length; ++posContent) {
            ContentToken token = tokens[posContent];
            if (token instanceof ContentsToken) {
                if (contentGiven) continue;
                String text = this.recordingContentNormalizer.getText();
                this.addContent(new ResolvedStringToken((ComputedToken)token, text));
                contentGiven = true;
                continue;
            }
            if (token instanceof ComputedToken) {
                ContentToken resolved = this.computeToken(token, cspec);
                if (resolved == null) continue;
                this.addContent(resolved);
                continue;
            }
            this.addContent(token);
        }
    }

    protected void generateAfterPseudoElements(LayoutElement element) throws IOException, NormalizationException {
        LayoutContext layoutContext = element.getLayoutContext();
        if (this.styleResolver.isPseudoElementStyleResolvable(element, "after")) {
            this.startElementInternal(layoutContext.getNamespace(), layoutContext.getTagName(), "after", layoutContext.getAttributes());
            this.endElement();
        }
    }

    public void addText(String text) throws NormalizationException, IOException {
        if (this.ignoreContext > 0) {
            if (this.recordingContentNormalizer != null) {
                this.recordingContentNormalizer.addText(text);
            }
            return;
        }
        this.modelBuilder.addContent(new StaticTextToken(text));
    }

    private void addContent(ContentToken token) throws NormalizationException {
        if (token instanceof ComputedToken) {
            throw new NormalizationException("ComputedContent cannot be added.");
        }
        if (this.ignoreContext == 0) {
            this.modelBuilder.addContent(token);
        }
    }

    private ContentToken computeToken(ContentToken token, ContentSpecification contentSpecs) {
        if (token instanceof CloseQuoteToken) {
            CloseQuoteToken closeQuoteToken = (CloseQuoteToken)token;
            if (closeQuoteToken.isSurpressQuoteText()) {
                --this.quoteLevel;
                return null;
            }
            --this.quoteLevel;
            QuotesPair currentQuote = this.getQuotesPair();
            if (currentQuote != null) {
                return new ResolvedStringToken(closeQuoteToken, currentQuote.getCloseQuote());
            }
        } else if (token instanceof OpenQuoteToken) {
            OpenQuoteToken openQuoteToken = (OpenQuoteToken)token;
            if (openQuoteToken.isSurpressQuoteText()) {
                ++this.quoteLevel;
                return null;
            }
            QuotesPair currentQuote = this.getQuotesPair();
            ++this.quoteLevel;
            if (currentQuote != null) {
                return new ResolvedStringToken(openQuoteToken, currentQuote.getOpenQuote());
            }
        } else {
            if (token instanceof VariableToken) {
                VariableToken variableToken = (VariableToken)token;
                String resolvedText = this.currentElement.getString(variableToken.getVariable());
                return new ResolvedStringToken(variableToken, resolvedText);
            }
            if (token instanceof CounterToken) {
                CounterToken counterToken = (CounterToken)token;
                String name = counterToken.getName();
                int counterValue = this.currentElement.getCounterValue(name);
                return new ResolvedCounterToken(counterToken, counterValue);
            }
            if (token instanceof CountersToken) {
                CountersToken counterToken = (CountersToken)token;
                String name = counterToken.getName();
                IntList counterValues = new IntList(10);
                while (this.currentElement != null) {
                    if (this.currentElement.isCounterDefined(name)) {
                        counterValues.add(this.currentElement.getCounterValue(name));
                    }
                    this.currentElement = this.currentElement.getParent();
                }
                int counterCount = counterValues.size();
                int[] ints = new int[counterCount];
                for (int i = 0; i < counterCount; ++i) {
                    ints[i] = counterValues.get(counterCount - i - 1);
                }
                return new ResolvedCountersToken(counterToken, ints);
            }
        }
        return null;
    }

    private QuotesPair getQuotesPair() {
        ContentSpecification cspec = this.currentElement.getLayoutContext().getContentSpecification();
        QuotesPair[] qps = cspec.getQuotes();
        int maxQuote = Math.min(qps.length - 1, this.quoteLevel);
        if (maxQuote == -1) {
            return null;
        }
        return qps[maxQuote];
    }

    public void endElement() throws NormalizationException, IOException {
        LayoutContext layoutContext;
        CSSValue displayRole;
        if (this.currentElement == null) {
            throw new NullPointerException("This is unexpected: I dont have a current element.");
        }
        if (this.ignoreContext > 1) {
            --this.ignoreContext;
            if (this.recordingContentNormalizer != null) {
                this.recordingContentNormalizer.endElement();
            }
            this.currentSilbling = this.currentElement;
            this.currentElement = this.currentElement.getParent();
            return;
        }
        if (this.ignoreContext == 1 && DisplayRole.NONE.equals(displayRole = (layoutContext = this.currentElement.getLayoutContext()).getValue(BoxStyleKeys.DISPLAY_ROLE))) {
            this.currentSilbling = this.currentElement;
            this.currentElement = this.currentElement.getParent();
            this.ignoreContext = 0;
            this.recordingContentNormalizer = null;
            return;
        }
        if (this.currentElement.isAlternateOpen()) {
            this.endElement();
        }
        if (this.ignoreContext == 1) {
            layoutContext = this.currentElement.getLayoutContext();
            ContentSpecification contentSpec = layoutContext.getContentSpecification();
            this.generateStrings(this.currentElement);
            if (!contentSpec.isAllowContentProcessing()) {
                if (!contentSpec.isInhibitContent() || !layoutContext.isPseudoElement()) {
                    this.generateAfterPseudoElements(this.currentElement);
                }
            } else {
                this.generateContentAfter(this.currentElement);
                this.generateAfterPseudoElements(this.currentElement);
            }
            this.ignoreContext = 0;
            if (this.recordingContentNormalizer != null) {
                try {
                    this.recordingContentNormalizer.replay(this);
                    this.recordingContentNormalizer = null;
                }
                catch (ChainingCallException chainingCallException) {}
            }
        } else {
            this.generateContentAfter(this.currentElement);
            this.generateAfterPseudoElements(this.currentElement);
        }
        this.modelBuilder.endElement();
        if (this.currentElement.isAlternateOpen()) {
            this.endElement();
        }
        this.currentSilbling = this.currentElement;
        this.currentElement = this.currentElement.getParent();
    }

    public void endDocument() throws IOException, NormalizationException {
        this.modelBuilder.endDocument();
    }

    public void handlePageBreak(CSSValue pageName, PseudoPage[] pseudoPages) {
        DefaultPageContext dpc = new DefaultPageContext();
        PageAreaType[] pat = PageAreaType.getPageAreas();
        for (int i = 0; i < pat.length; ++i) {
            PageAreaType pageAreaType = pat[i];
            if (this.styleResolver == null) {
                throw new IllegalStateException();
            }
            LayoutStyle style = this.styleResolver.resolvePageStyle(pageName, pseudoPages, pageAreaType);
            dpc.setAreaDefinition(pageAreaType, style);
        }
        try {
            this.modelBuilder.handlePageBreak(dpc);
        }
        catch (NormalizationException e) {
            throw new IllegalStateException();
        }
    }

    protected ContentNormalizerState createSaveState() {
        return new ContentNormalizerState();
    }

    protected void fillState(ContentNormalizerState state) throws StateException {
        state.setNextId(this.nextId);
        state.setCurrentElement(this.currentElement);
        state.setCurrentSilbling(this.currentSilbling);
        state.setModelBuilderState(this.modelBuilder.saveState());
        if (this.recordingContentNormalizer != null) {
            state.setRecordingContentNormalizerState(this.recordingContentNormalizer.saveState());
        }
    }

    public State saveState() throws StateException {
        ContentNormalizerState state = this.createSaveState();
        this.fillState(state);
        return state;
    }

    protected void restore(ContentNormalizerState state) throws StateException {
        this.currentElement = state.getCurrentElement();
        this.currentSilbling = state.getCurrentSilbling();
        this.nextId = state.getNextId();
        this.modelBuilder = (ModelBuilder)state.getModelBuilderState().restore(this.layoutProcess);
        if (state.getRecordingContentNormalizerState() != null) {
            this.recordingContentNormalizer = (RecordingContentNormalizer)state.getRecordingContentNormalizerState().restore(this.layoutProcess);
        }
    }

    public Renderer getRenderer() {
        return this.modelBuilder.getRenderer();
    }

    public StyleResolver getStyleResolver() {
        if (this.styleResolver == null) {
            throw new IllegalStateException("Document has not yet been initialized?");
        }
        return this.styleResolver;
    }

    protected static class ContentNormalizerState
    implements State {
        private State modelBuilderState;
        private LayoutElement currentElement;
        private LayoutElement currentSilbling;
        private long nextId;
        private State recordingContentNormalizerState;

        protected ContentNormalizerState() {
        }

        public State getRecordingContentNormalizerState() {
            return this.recordingContentNormalizerState;
        }

        public void setRecordingContentNormalizerState(State recordingContentNormalizerState) {
            this.recordingContentNormalizerState = recordingContentNormalizerState;
        }

        public State getModelBuilderState() {
            return this.modelBuilderState;
        }

        public void setModelBuilderState(State modelBuilderState) {
            this.modelBuilderState = modelBuilderState;
        }

        public LayoutElement getCurrentElement() {
            return this.currentElement;
        }

        public void setCurrentElement(LayoutElement currentElement) {
            this.currentElement = currentElement;
        }

        public LayoutElement getCurrentSilbling() {
            return this.currentSilbling;
        }

        public void setCurrentSilbling(LayoutElement currentSilbling) {
            this.currentSilbling = currentSilbling;
        }

        public long getNextId() {
            return this.nextId;
        }

        public void setNextId(long nextId) {
            this.nextId = nextId;
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            ContentNormalizer contentNormalizer = new ContentNormalizer(layoutProcess, false);
            contentNormalizer.restore(this);
            return contentNormalizer;
        }
    }
}

