/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.normalizer;

import java.io.IOException;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.content.Normalizer;
import org.jfree.layouting.renderer.ChainingRenderer;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.layouting.util.ChainingCallException;

public class ChainingNormalizer
implements Normalizer {
    private Normalizer chainedNormalizer;

    public ChainingNormalizer(Normalizer normalizer) {
        if (normalizer == null) {
            throw new NullPointerException();
        }
        this.chainedNormalizer = normalizer;
    }

    public void startDocument() throws NormalizationException, IOException {
        this.chainedNormalizer.startDocument();
        this.commitCalls();
    }

    public synchronized void commitCalls() throws NormalizationException {
        ChainingRenderer renderer = (ChainingRenderer)this.chainedNormalizer.getRenderer();
        if (renderer != null) {
            try {
                renderer.replay(renderer.getRenderer());
            }
            catch (ChainingCallException e) {
                throw new NormalizationException("Failed to dispatch calls", (Exception)((Object)e));
            }
        }
    }

    public void startElement(String namespace, String tag, AttributeMap attributes) throws NormalizationException, IOException {
        this.chainedNormalizer.startElement(namespace, tag, attributes);
        this.commitCalls();
    }

    public void addText(String text) throws NormalizationException, IOException {
        this.chainedNormalizer.addText(text);
        this.commitCalls();
    }

    public void endElement() throws NormalizationException, IOException {
        this.chainedNormalizer.endElement();
        this.commitCalls();
    }

    public void endDocument() throws NormalizationException, IOException {
        this.chainedNormalizer.endDocument();
        this.commitCalls();
    }

    public void handlePageBreak(CSSValue pageName, PseudoPage[] pseudoPages) throws NormalizationException {
        this.chainedNormalizer.handlePageBreak(pageName, pseudoPages);
        this.commitCalls();
    }

    public State saveState() throws StateException {
        ChainingNormalizerState state = new ChainingNormalizerState();
        state.setChainedNormalizerState(this.chainedNormalizer.saveState());
        return state;
    }

    public Renderer getRenderer() {
        return this.chainedNormalizer.getRenderer();
    }

    private static class ChainingNormalizerState
    implements State {
        private State chainedNormalizerState;

        private ChainingNormalizerState() {
        }

        public State getChainedNormalizerState() {
            return this.chainedNormalizerState;
        }

        public void setChainedNormalizerState(State chainedNormalizerState) {
            this.chainedNormalizerState = chainedNormalizerState;
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            Normalizer normalizer = (Normalizer)this.chainedNormalizerState.restore(layoutProcess);
            return new ChainingNormalizer(normalizer);
        }
    }
}

