/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.namespace;

import java.util.StringTokenizer;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.resourceloader.ResourceKey;

public class DefaultNamespaceDefinition
implements NamespaceDefinition {
    private String uri;
    private String[] classAttribute;
    private String[] styleAttribute;
    private ResourceKey defaultStyleSheet;
    private String preferredPrefix;

    public DefaultNamespaceDefinition(String uri, ResourceKey defaultStyleSheet, String classAttribute, String styleAttribute, String preferredPrefix) {
        if (uri == null) {
            throw new NullPointerException();
        }
        this.uri = uri;
        this.defaultStyleSheet = defaultStyleSheet;
        this.classAttribute = this.buildArray(classAttribute);
        this.styleAttribute = this.buildArray(styleAttribute);
        this.preferredPrefix = preferredPrefix;
    }

    private String[] buildArray(String attr) {
        if (attr == null) {
            return new String[0];
        }
        StringTokenizer strtok = new StringTokenizer(attr);
        int size = strtok.countTokens();
        String[] retval = new String[size];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = strtok.nextToken();
        }
        return retval;
    }

    public String getURI() {
        return this.uri;
    }

    public String[] getClassAttribute(String element) {
        return (String[])this.classAttribute.clone();
    }

    public String[] getStyleAttribute(String element) {
        return (String[])this.styleAttribute.clone();
    }

    public ResourceKey getDefaultStyleSheetLocation() {
        return this.defaultStyleSheet;
    }

    public String getPreferredPrefix() {
        return this.preferredPrefix;
    }
}

