/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.html;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.StringUtils;

public class StyleBuilder {
    private static final String INDENT = "    ";
    private boolean compact;
    private Map backend;
    private Map parentBackend;

    public StyleBuilder(boolean compact, StyleBuilder parent) {
        this(compact);
        if (parent != null) {
            this.parentBackend = new TreeMap();
            if (parent.parentBackend != null) {
                this.parentBackend.putAll(parent.parentBackend);
            }
            this.parentBackend.putAll(parent.backend);
        }
    }

    public StyleBuilder(boolean compact) {
        this.compact = compact;
        this.backend = new TreeMap();
        this.parentBackend = null;
    }

    public void append(StyleKey key, CSSValue value) {
        if (value == null) {
            return;
        }
        String cssText = value.getCSSText();
        String name = key.getName();
        if (this.parentBackend == null || !key.isInherited()) {
            this.backend.put(name, cssText);
            return;
        }
        if (!this.parentContains(name, cssText)) {
            this.backend.put(name, cssText);
        }
    }

    public void append(String key, boolean inheritable, String value) {
        if (this.parentBackend == null || !inheritable) {
            this.backend.put(key, value);
            return;
        }
        if (!this.parentContains(key, value)) {
            this.backend.put(key, value);
        }
    }

    public void append(StyleKey key, String value, String unit) {
        if (value == null) {
            return;
        }
        String textvalue = value + unit;
        String name = key.getName();
        if (this.parentBackend == null || !key.isInherited()) {
            this.backend.put(name, textvalue);
            return;
        }
        if (!this.parentContains(name, textvalue)) {
            this.backend.put(name, textvalue);
        }
    }

    public void append(StyleKey key, String text) {
        String name = key.getName();
        if (this.parentBackend == null || !key.isInherited()) {
            this.backend.put(name, text);
            return;
        }
        if (!this.parentContains(name, text)) {
            this.backend.put(name, text);
        }
    }

    public boolean parentContains(String key, String value) {
        if (this.parentBackend == null) {
            return false;
        }
        Object o1 = this.parentBackend.get(key);
        return ObjectUtilities.equal(o1, (Object)value);
    }

    public String toString() {
        StringBuffer style = new StringBuffer();
        if (!this.compact) {
            Iterator it = this.backend.entrySet().iterator();
            while (it.hasNext()) {
                if (style.length() != 0) {
                    style.append(StringUtils.getLineSeparator());
                }
                style.append(INDENT);
                Map.Entry entry = it.next();
                style.append(entry.getKey());
                style.append(": ");
                style.append(entry.getValue());
                style.append(';');
            }
        } else {
            Iterator it = this.backend.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                style.append(entry.getKey());
                style.append(": ");
                style.append(entry.getValue());
                style.append("; ");
            }
        }
        return style.toString();
    }

    public static void main(String[] args) {
        StyleBuilder level1 = new StyleBuilder(false);
        level1.append(BoxStyleKeys.PADDING_TOP, "red");
        StyleBuilder level2 = new StyleBuilder(false, level1);
        level2.append(BoxStyleKeys.PADDING_TOP, "red");
        StyleBuilder level3 = new StyleBuilder(false, level2);
        level3.append(BoxStyleKeys.PADDING_TOP, "red");
    }

    public boolean isEmpty() {
        return this.backend.isEmpty();
    }
}

