/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.html;

import org.jfree.fonts.awt.AWTFontRegistry;
import org.jfree.fonts.registry.DefaultFontStorage;
import org.jfree.fonts.registry.FontRegistry;
import org.jfree.fonts.registry.FontStorage;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.modules.output.html.HtmlOutputProcessor;
import org.jfree.layouting.modules.output.html.HtmlOutputProcessorMetaData;
import org.jfree.layouting.modules.output.html.HtmlPrinter;
import org.jfree.layouting.output.AbstractOutputProcessor;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.output.pageable.LogicalPageKey;
import org.jfree.layouting.renderer.PrototypeBuildingRenderer;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.renderer.StreamingRenderer;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.repository.ContentLocation;
import org.jfree.repository.DefaultNameGenerator;
import org.jfree.repository.NameGenerator;
import org.jfree.repository.dummy.DummyRepository;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public class StreamingHtmlOutputProcessor
extends AbstractOutputProcessor
implements HtmlOutputProcessor {
    private HtmlOutputProcessorMetaData metaData;
    private PrototypeBuildingRenderer prototypeBuilder;
    private HtmlPrinter printer;

    public StreamingHtmlOutputProcessor(Configuration configuration) {
        super(configuration);
        AWTFontRegistry fontRegistry = new AWTFontRegistry();
        DefaultFontStorage fontStorage = new DefaultFontStorage((FontRegistry)fontRegistry);
        this.metaData = new HtmlOutputProcessorMetaData((FontStorage)fontStorage, 0);
        ContentLocation contentLocation = new DummyRepository().getRoot();
        DefaultNameGenerator contentNameGenerator = new DefaultNameGenerator(contentLocation);
        ContentLocation dataLocation = new DummyRepository().getRoot();
        DefaultNameGenerator dataNameGenerator = new DefaultNameGenerator(dataLocation);
        this.printer = new HtmlPrinter();
        this.printer.setContentWriter(contentLocation, (NameGenerator)contentNameGenerator);
        this.printer.setDataWriter(dataLocation, (NameGenerator)dataNameGenerator);
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    public Renderer createRenderer(LayoutProcess layoutProcess) {
        if (!this.isGlobalStateComputed()) {
            this.prototypeBuilder = new PrototypeBuildingRenderer(layoutProcess);
            return this.prototypeBuilder;
        }
        return new StreamingRenderer(layoutProcess);
    }

    protected void processPageContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage) {
        try {
            this.printer.generate(logicalPage, this.getDocumentContext());
        }
        catch (Exception e) {
            Log.error((Object)"Failed to generate content.", (Exception)e);
        }
    }

    public HtmlPrinter getPrinter() {
        return this.printer;
    }

    public void setPrinter(HtmlPrinter printer) {
        this.printer = printer;
    }
}

