/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.html;

import org.jfree.fonts.awt.AWTFontRegistry;
import org.jfree.fonts.registry.DefaultFontStorage;
import org.jfree.fonts.registry.FontRegistry;
import org.jfree.fonts.registry.FontStorage;
import org.jfree.layouting.modules.output.html.HtmlOutputProcessor;
import org.jfree.layouting.modules.output.html.HtmlOutputProcessorMetaData;
import org.jfree.layouting.modules.output.html.HtmlPrinter;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.output.pageable.AbstractPageableProcessor;
import org.jfree.layouting.output.pageable.AllPageFlowSelector;
import org.jfree.layouting.output.pageable.LogicalPageKey;
import org.jfree.layouting.output.pageable.PageFlowSelector;
import org.jfree.layouting.output.pageable.PhysicalPageKey;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.jfree.repository.ContentLocation;
import org.jfree.repository.DefaultNameGenerator;
import org.jfree.repository.NameGenerator;
import org.jfree.repository.dummy.DummyRepository;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public class PageableHtmlOutputProcessor
extends AbstractPageableProcessor
implements HtmlOutputProcessor {
    private HtmlOutputProcessorMetaData metaData;
    private PageFlowSelector flowSelector = new AllPageFlowSelector(true);
    private HtmlPrinter printer;

    public PageableHtmlOutputProcessor(Configuration configuration) {
        super(configuration);
        AWTFontRegistry fontRegistry = new AWTFontRegistry();
        DefaultFontStorage fontStorage = new DefaultFontStorage((FontRegistry)fontRegistry);
        this.metaData = new HtmlOutputProcessorMetaData((FontStorage)fontStorage, 2);
        ContentLocation contentLocation = new DummyRepository().getRoot();
        DefaultNameGenerator contentNameGenerator = new DefaultNameGenerator(contentLocation);
        ContentLocation dataLocation = new DummyRepository().getRoot();
        DefaultNameGenerator dataNameGenerator = new DefaultNameGenerator(dataLocation);
        this.printer = new HtmlPrinter();
        this.printer.setContentWriter(contentLocation, (NameGenerator)contentNameGenerator);
        this.printer.setDataWriter(dataLocation, (NameGenerator)dataNameGenerator);
    }

    public HtmlPrinter getPrinter() {
        return this.printer;
    }

    public void setPrinter(HtmlPrinter printer) {
        this.printer = printer;
    }

    protected void processPhysicalPage(PageGrid pageGrid, LogicalPageBox logicalPage, int row, int col, PhysicalPageKey pageKey) {
    }

    protected void processLogicalPage(LogicalPageKey key, LogicalPageBox logicalPage) {
        try {
            this.printer.generate(logicalPage, this.getDocumentContext());
        }
        catch (Exception e) {
            Log.error((Object)"Failed to generate content.", (Exception)e);
        }
    }

    public PageFlowSelector getFlowSelector() {
        return this.flowSelector;
    }

    public void setFlowSelector(PageFlowSelector flowSelector) {
        this.flowSelector = flowSelector;
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }
}

