/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.html;

import com.keypoint.PngEncoder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.jfree.io.IOUtils;
import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.keys.border.BorderStyle;
import org.jfree.layouting.input.style.keys.border.BorderStyleKeys;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.keys.color.ColorStyleKeys;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.modules.output.html.FileSystemURLRewriter;
import org.jfree.layouting.modules.output.html.StyleBuilder;
import org.jfree.layouting.modules.output.html.URLRewriteException;
import org.jfree.layouting.modules.output.html.URLRewriter;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.MarkerRenderBox;
import org.jfree.layouting.renderer.model.NodeLayoutProperties;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableReplacedContent;
import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.model.SpacerRenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.model.table.cols.TableColumn;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;
import org.jfree.layouting.renderer.process.IterateStructuralProcessStep;
import org.jfree.layouting.util.ImageUtils;
import org.jfree.layouting.util.geom.StrictGeomUtility;
import org.jfree.repository.ContentEntity;
import org.jfree.repository.ContentIOException;
import org.jfree.repository.ContentItem;
import org.jfree.repository.ContentLocation;
import org.jfree.repository.NameGenerator;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.ui.Drawable;
import org.jfree.util.FastStack;
import org.jfree.util.Log;
import org.jfree.util.StackableRuntimeException;
import org.jfree.util.WaitingImageObserver;
import org.jfree.xmlns.common.AttributeList;
import org.jfree.xmlns.writer.DefaultTagDescription;
import org.jfree.xmlns.writer.HtmlCharacterEntities;
import org.jfree.xmlns.writer.TagDescription;
import org.jfree.xmlns.writer.XmlWriter;

public class HtmlPrinter
extends IterateStructuralProcessStep {
    private static final String[] XHTML_HEADER = new String[]{"<!DOCTYPE html", "     PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"", "     \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">"};
    public static final String TAG_DEF_PREFIX = "org.jfree.layouting.modules.output.html.";
    public static final float CORRECTION_FACTOR_PX_TO_POINT = 0.75f;
    public static final float CORRECTION_FACTOR_POINT_TO_PX = 1.3333334f;
    private XmlWriter xmlWriter;
    private FastStack contexts;
    private DecimalFormat pointConverter;
    private NumberFormat pointIntConverter;
    private boolean assumeZeroMargins;
    private boolean assumeZeroBorders;
    private boolean assumeZeroPaddings;
    private ContentLocation contentLocation;
    private NameGenerator contentNameGenerator;
    private ContentLocation dataLocation;
    private NameGenerator dataNameGenerator;
    private ResourceManager resourceManager;
    private HashMap knownResources = new HashMap();
    private HashSet validRawTypes = new HashSet();
    private String encoding = "ASCII";
    private URLRewriter urlRewriter;
    private ContentItem documentContentItem;
    private boolean generateFragment;
    static /* synthetic */ Class class$org$jfree$layouting$input$style$keys$color$HtmlColors;

    public HtmlPrinter() {
        this.validRawTypes.add("image/gif");
        this.validRawTypes.add("image/x-xbitmap");
        this.validRawTypes.add("image/gi_");
        this.validRawTypes.add("image/jpeg");
        this.validRawTypes.add("image/jpg");
        this.validRawTypes.add("image/jp_");
        this.validRawTypes.add("application/jpg");
        this.validRawTypes.add("application/x-jpg");
        this.validRawTypes.add("image/pjpeg");
        this.validRawTypes.add("image/pipeg");
        this.validRawTypes.add("image/vnd.swiftview-jpeg");
        this.validRawTypes.add("image/x-xbitmap");
        this.validRawTypes.add("image/png");
        this.validRawTypes.add("application/png");
        this.validRawTypes.add("application/x-png");
        this.contexts = new FastStack();
        this.pointConverter = new DecimalFormat("0.####", new DecimalFormatSymbols(Locale.US));
        this.pointIntConverter = new DecimalFormat("0", new DecimalFormatSymbols(Locale.US));
        this.assumeZeroMargins = true;
        this.assumeZeroBorders = true;
        this.assumeZeroPaddings = true;
        this.urlRewriter = new FileSystemURLRewriter();
        this.generateFragment = false;
    }

    public URLRewriter getUrlRewriter() {
        return this.urlRewriter;
    }

    public void setUrlRewriter(URLRewriter urlRewriter) {
        this.urlRewriter = urlRewriter;
    }

    public NameGenerator getDataNameGenerator() {
        return this.dataNameGenerator;
    }

    public ContentLocation getDataLocation() {
        return this.dataLocation;
    }

    public NameGenerator getContentNameGenerator() {
        return this.contentNameGenerator;
    }

    public ContentLocation getContentLocation() {
        return this.contentLocation;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void generate(LogicalPageBox box, DocumentContext documentContext) throws IOException, ContentIOException {
        this.resourceManager = documentContext.getResourceManager();
        DefaultTagDescription tagDescription = new DefaultTagDescription();
        tagDescription.configure(LibLayoutBoot.getInstance().getGlobalConfig(), TAG_DEF_PREFIX);
        this.documentContentItem = this.contentLocation.createItem(this.contentNameGenerator.generateName(null, "text/html"));
        OutputStream out = this.documentContentItem.getOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out, this.encoding);
        this.xmlWriter = new XmlWriter((Writer)writer, (TagDescription)tagDescription);
        this.xmlWriter.setAlwaysAddNamespace(false);
        this.xmlWriter.setAssumeDefaultNamespace(true);
        if (!this.generateFragment) {
            this.xmlWriter.writeXmlDeclaration(this.encoding);
            for (int i = 0; i < XHTML_HEADER.length; ++i) {
                this.xmlWriter.writeText(XHTML_HEADER[i]);
                this.xmlWriter.writeNewLine();
            }
            AttributeList htmlAttList = new AttributeList();
            htmlAttList.addNamespaceDeclaration("", "http://www.w3.org/1999/xhtml");
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "html", false);
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "head", false);
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "title", false);
            this.xmlWriter.writeText("Yeah, sure, I *should* grab a sensible title from somewhere");
            this.xmlWriter.writeCloseTag();
            this.xmlWriter.writeCloseTag();
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "body", false);
        } else {
            this.xmlWriter.addImpliedNamespace("http://www.w3.org/1999/xhtml", "");
        }
        this.contexts.clear();
        LayoutStyle initialStyle = DocumentContextUtility.getInitialStyle(documentContext);
        StyleBuilder inialBuilder = new StyleBuilder(false);
        StyleKey[] keys = StyleKeyRegistry.getRegistry().getKeys();
        for (int i = 0; i < keys.length; ++i) {
            StyleKey key = keys[i];
            if (!key.isInherited()) continue;
            inialBuilder.append(key, initialStyle.getValue(key));
        }
        this.contexts.push((Object)new ContextElement(inialBuilder));
        this.startBlockBox(box);
        this.processBoxChilds(box);
        this.finishBlockBox(box);
        if (!this.generateFragment) {
            this.xmlWriter.writeCloseTag();
            this.xmlWriter.writeCloseTag();
        }
        this.xmlWriter.close();
        this.xmlWriter = null;
    }

    public boolean isGenerateFragment() {
        return this.generateFragment;
    }

    public void setGenerateFragment(boolean generateFragment) {
        this.generateFragment = generateFragment;
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        try {
            StyleBuilder builder = this.createStyleBuilder();
            ContextElement context = new ContextElement(builder);
            this.contexts.push((Object)context);
            this.buildStyle(box, builder);
            AttributeList attList = new AttributeList();
            if (!builder.isEmpty()) {
                attList.setAttribute("http://www.w3.org/1999/xhtml", "style", builder.toString());
            }
            if (!attList.isEmpty()) {
                this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "span", attList, false);
            } else {
                context.setOmitted(true);
            }
            return true;
        }
        catch (IOException e) {
            throw new StackableRuntimeException("Failed", (Exception)e);
        }
    }

    private void buildStyle(RenderBox box, StyleBuilder builder) {
        String fgColor;
        String bgColor;
        LayoutContext layoutContext = box.getLayoutContext();
        if (layoutContext == null) {
            return;
        }
        FontSpecification fs = layoutContext.getFontSpecification();
        double fontSize = fs.getFontSize();
        builder.append(FontStyleKeys.FONT_SIZE, this.toPointString(fontSize), "pt");
        builder.append(FontStyleKeys.FONT_FAMILY, fs.getFontFamily());
        builder.append(FontStyleKeys.FONT_WEIGHT, layoutContext.getValue(FontStyleKeys.FONT_WEIGHT));
        builder.append(FontStyleKeys.FONT_STYLE, layoutContext.getValue(FontStyleKeys.FONT_STYLE));
        builder.append(TextStyleKeys.TEXT_ALIGN, layoutContext.getValue(TextStyleKeys.TEXT_ALIGN));
        builder.append(TextStyleKeys.TEXT_ALIGN_LAST, layoutContext.getValue(TextStyleKeys.TEXT_ALIGN_LAST));
        NodeLayoutProperties nlp = box.getNodeLayoutProperties();
        ComputedLayoutProperties sblp = box.getComputedLayoutProperties();
        builder.append(LineStyleKeys.VERTICAL_ALIGN, nlp.getVerticalAlignment());
        if (sblp.getPaddingTop() > 0L || sblp.getPaddingLeft() > 0L || sblp.getPaddingBottom() > 0L || sblp.getPaddingRight() > 0L) {
            if (sblp.getPaddingTop() > 0L || !this.assumeZeroPaddings) {
                builder.append(BoxStyleKeys.PADDING_TOP, this.toPointString(sblp.getPaddingTop()), "pt");
            }
            if (sblp.getPaddingLeft() > 0L || !this.assumeZeroPaddings) {
                builder.append(BoxStyleKeys.PADDING_LEFT, this.toPointString(sblp.getPaddingLeft()), "pt");
            }
            if (sblp.getPaddingBottom() > 0L || !this.assumeZeroPaddings) {
                builder.append(BoxStyleKeys.PADDING_BOTTOM, this.toPointString(sblp.getPaddingBottom()), "pt");
            }
            if (sblp.getPaddingRight() > 0L || !this.assumeZeroPaddings) {
                builder.append(BoxStyleKeys.PADDING_RIGHT, this.toPointString(sblp.getPaddingRight()), "pt");
            }
        } else if (!this.assumeZeroPaddings) {
            builder.append("padding", false, "0");
        }
        if (sblp.getMarginLeft() != 0L || sblp.getMarginRight() != 0L || sblp.getMarginTop() != 0L || sblp.getMarginBottom() != 0L) {
            if (sblp.getMarginLeft() > 0L || !this.assumeZeroMargins) {
                builder.append(BoxStyleKeys.MARGIN_LEFT, this.toPointString(sblp.getMarginLeft()), "pt");
            }
            if (sblp.getMarginRight() > 0L || !this.assumeZeroMargins) {
                builder.append(BoxStyleKeys.MARGIN_RIGHT, this.toPointString(sblp.getMarginRight()), "pt");
            }
            if (sblp.getMarginTop() > 0L || !this.assumeZeroMargins) {
                builder.append(BoxStyleKeys.MARGIN_TOP, this.toPointString(sblp.getMarginTop()), "pt");
            }
            if (sblp.getMarginBottom() > 0L || !this.assumeZeroMargins) {
                builder.append(BoxStyleKeys.MARGIN_BOTTOM, this.toPointString(sblp.getMarginBottom()), "pt");
            }
        } else if (!this.assumeZeroMargins) {
            builder.append("margin", false, "0");
        }
        if ((bgColor = this.toColorString(layoutContext.getValue(BorderStyleKeys.BACKGROUND_COLOR))) != null) {
            builder.append(BorderStyleKeys.BACKGROUND_COLOR, bgColor);
        }
        if ((fgColor = this.toColorString(layoutContext.getValue(ColorStyleKeys.COLOR))) != null) {
            builder.append(ColorStyleKeys.COLOR, fgColor);
        }
        if (sblp.getBorderTop() > 0L || sblp.getBorderLeft() > 0L || sblp.getBorderBottom() > 0L || sblp.getBorderRight() > 0L) {
            if (sblp.getBorderTop() > 0L) {
                builder.append(BorderStyleKeys.BORDER_TOP_COLOR, layoutContext.getValue(BorderStyleKeys.BORDER_TOP_COLOR));
                builder.append(BorderStyleKeys.BORDER_TOP_STYLE, layoutContext.getValue(BorderStyleKeys.BORDER_TOP_STYLE));
                builder.append(BorderStyleKeys.BORDER_TOP_WIDTH, this.toPointString(sblp.getBorderTop()), "pt");
            } else if (!this.assumeZeroBorders) {
                builder.append(BorderStyleKeys.BORDER_TOP_STYLE, BorderStyle.NONE);
            }
            if (sblp.getBorderLeft() > 0L) {
                builder.append(BorderStyleKeys.BORDER_LEFT_COLOR, layoutContext.getValue(BorderStyleKeys.BORDER_LEFT_COLOR));
                builder.append(BorderStyleKeys.BORDER_LEFT_STYLE, layoutContext.getValue(BorderStyleKeys.BORDER_LEFT_STYLE));
                builder.append(BorderStyleKeys.BORDER_LEFT_WIDTH, this.toPointString(sblp.getBorderLeft()), "pt");
            } else if (!this.assumeZeroBorders) {
                builder.append(BorderStyleKeys.BORDER_LEFT_STYLE, BorderStyle.NONE);
            }
            if (sblp.getBorderBottom() > 0L) {
                builder.append(BorderStyleKeys.BORDER_BOTTOM_COLOR, layoutContext.getValue(BorderStyleKeys.BORDER_BOTTOM_COLOR));
                builder.append(BorderStyleKeys.BORDER_BOTTOM_STYLE, layoutContext.getValue(BorderStyleKeys.BORDER_BOTTOM_STYLE));
                builder.append(BorderStyleKeys.BORDER_BOTTOM_WIDTH, this.toPointString(sblp.getBorderBottom()), "pt");
            } else if (!this.assumeZeroBorders) {
                builder.append(BorderStyleKeys.BORDER_BOTTOM_STYLE, BorderStyle.NONE);
            }
            if (sblp.getBorderRight() > 0L) {
                builder.append(BorderStyleKeys.BORDER_RIGHT_COLOR, layoutContext.getValue(BorderStyleKeys.BORDER_RIGHT_COLOR));
                builder.append(BorderStyleKeys.BORDER_RIGHT_STYLE, layoutContext.getValue(BorderStyleKeys.BORDER_RIGHT_STYLE));
                builder.append(BorderStyleKeys.BORDER_RIGHT_WIDTH, this.toPointString(sblp.getBorderRight()), "pt");
            } else if (!this.assumeZeroBorders) {
                builder.append(BorderStyleKeys.BORDER_RIGHT_STYLE, BorderStyle.NONE);
            }
        } else if (!this.assumeZeroBorders) {
            builder.append("border-style", true, "none");
        }
    }

    private StyleBuilder createStyleBuilder() {
        StyleBuilder builder;
        if (this.contexts.isEmpty()) {
            builder = new StyleBuilder(true);
        } else {
            ContextElement contextElement = (ContextElement)this.contexts.peek();
            builder = new StyleBuilder(true, contextElement.getBuilder());
        }
        return builder;
    }

    private String toColorString(CSSValue color) {
        if (color == null) {
            return null;
        }
        if (!(color instanceof CSSColorValue)) {
            return color.getCSSText();
        }
        CSSColorValue colorValue = (CSSColorValue)color;
        if (colorValue.getAlpha() == 0) {
            return null;
        }
        try {
            Field[] fields = (class$org$jfree$layouting$input$style$keys$color$HtmlColors == null ? (class$org$jfree$layouting$input$style$keys$color$HtmlColors = HtmlPrinter.class$("org.jfree.layouting.input.style.keys.color.HtmlColors")) : class$org$jfree$layouting$input$style$keys$color$HtmlColors).getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                if (!Modifier.isPublic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !Modifier.isStatic(f.getModifiers())) continue;
                String name = f.getName();
                Object oColor = f.get(null);
                if (!(oColor instanceof Color) || !color.equals(oColor)) continue;
                return name.toLowerCase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return colorValue.getCSSText();
    }

    private String toPointString(double value) {
        if (Math.floor(value) == value) {
            return this.pointIntConverter.format(value);
        }
        return this.pointConverter.format(value);
    }

    private String toPointString(long value) {
        int remainder = (int)value % 1000;
        if (remainder == 0) {
            double d = StrictGeomUtility.toExternalValue(value);
            return this.pointIntConverter.format(d);
        }
        double d = StrictGeomUtility.toExternalValue(value);
        return this.pointConverter.format(d);
    }

    protected void finishInlineBox(InlineRenderBox box) {
        try {
            ContextElement element = (ContextElement)this.contexts.pop();
            if (!element.isOmitted()) {
                this.xmlWriter.writeCloseTag();
            }
        }
        catch (IOException e) {
            throw new StackableRuntimeException("Failed", (Exception)e);
        }
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        try {
            StyleBuilder builder = this.createStyleBuilder();
            this.contexts.push((Object)new ContextElement(builder));
            if (box instanceof TableRenderBox) {
                return this.startTable((TableRenderBox)box, builder);
            }
            if (box instanceof TableSectionRenderBox) {
                TableSectionRenderBox section = (TableSectionRenderBox)box;
                CSSValue displayRole = section.getDisplayRole();
                if (DisplayRole.TABLE_HEADER_GROUP.equals(displayRole)) {
                    return this.startTableHeader((TableSectionRenderBox)box, builder);
                }
                if (DisplayRole.TABLE_FOOTER_GROUP.equals(displayRole)) {
                    return this.startTableFooter((TableSectionRenderBox)box, builder);
                }
                return this.startTableBody((TableSectionRenderBox)box, builder);
            }
            if (box instanceof TableRowRenderBox) {
                return this.startTableRow((TableRowRenderBox)box, builder);
            }
            if (box instanceof TableCellRenderBox) {
                return this.startTableCell((TableCellRenderBox)box, builder);
            }
            if (box instanceof ParagraphRenderBox) {
                return this.startParagraph((ParagraphRenderBox)box, builder);
            }
            if (box instanceof LogicalPageBox) {
                return this.startPageBox(box, builder);
            }
            if (box instanceof MarkerRenderBox) {
                return this.startMarkerContents(box, builder);
            }
            return this.startOtherBlockBox(box, builder);
        }
        catch (IOException e) {
            throw new StackableRuntimeException("Failed", (Exception)e);
        }
    }

    protected void finishBlockBox(BlockRenderBox box) {
        try {
            if (box instanceof TableRenderBox) {
                this.finishTable((TableRenderBox)box);
            } else if (box instanceof TableSectionRenderBox) {
                TableSectionRenderBox section = (TableSectionRenderBox)box;
                CSSValue displayRole = section.getDisplayRole();
                if (DisplayRole.TABLE_HEADER_GROUP.equals(displayRole)) {
                    this.finishTableHeader((TableSectionRenderBox)box);
                } else if (DisplayRole.TABLE_FOOTER_GROUP.equals(displayRole)) {
                    this.finishTableFooter((TableSectionRenderBox)box);
                } else {
                    this.finishTableBody((TableSectionRenderBox)box);
                }
            } else if (box instanceof TableRowRenderBox) {
                this.finishTableRow((TableRowRenderBox)box);
            } else if (box instanceof TableCellRenderBox) {
                this.finishTableCell((TableCellRenderBox)box);
            } else if (box instanceof ParagraphRenderBox) {
                this.finishParagraph((ParagraphRenderBox)box);
            } else if (box instanceof LogicalPageBox) {
                this.finishPageBox(box);
            } else if (box instanceof MarkerRenderBox) {
                this.finishMarkerBox(box);
            } else {
                this.finishOtherBlockBox(box);
            }
            this.contexts.pop();
        }
        catch (IOException e) {
            throw new StackableRuntimeException("Failed", (Exception)e);
        }
    }

    private void finishMarkerBox(RenderBox box) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startMarkerContents(RenderBox box, StyleBuilder builder) throws IOException {
        this.buildStyle(box, builder);
        builder.append("white-space", false, "nowrap");
        AttributeList attList = new AttributeList();
        if (!builder.isEmpty()) {
            attList.setAttribute("http://www.w3.org/1999/xhtml", "style", builder.toString());
        }
        this.xmlWriter.writeComment("Marker-Box");
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "span", attList, false);
        RenderNode node = box.getFirstChild();
        while (node != null) {
            if (node instanceof ParagraphRenderBox) {
                this.processParagraphChilds((ParagraphRenderBox)node);
            } else if (node instanceof RenderBox) {
                this.processBoxChilds((RenderBox)node);
            } else {
                this.startProcessing(node);
            }
            RenderNode next = node.getNext();
            if (next == null) break;
            if (!next.isIgnorableForRendering()) {
                this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "br", true);
            }
            node = next;
        }
        return false;
    }

    protected boolean startPageBox(RenderBox box, StyleBuilder builder) throws IOException {
        this.buildStyle(box, builder);
        builder.append(BoxStyleKeys.WIDTH, this.toPointString(box.getWidth()), "pt");
        AttributeList attList = new AttributeList();
        attList.setAttribute("http://www.w3.org/1999/xhtml", "style", builder.toString());
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "div", attList, false);
        return true;
    }

    protected void finishPageBox(RenderBox box) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startOtherBlockBox(BlockRenderBox box, StyleBuilder builder) throws IOException {
        this.buildStyle(box, builder);
        AttributeList attList = new AttributeList();
        if (!builder.isEmpty()) {
            attList.setAttribute("http://www.w3.org/1999/xhtml", "style", builder.toString());
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "div", attList, false);
        return true;
    }

    protected void finishOtherBlockBox(BlockRenderBox tableRenderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startParagraph(ParagraphRenderBox box, StyleBuilder builder) throws IOException {
        this.buildStyle(box, builder);
        AttributeList attList = new AttributeList();
        if (!builder.isEmpty()) {
            attList.setAttribute("http://www.w3.org/1999/xhtml", "style", builder.toString());
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "div", attList, false);
        return true;
    }

    protected void finishParagraph(ParagraphRenderBox tableRenderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startTableCell(TableCellRenderBox box, StyleBuilder builder) throws IOException {
        int colSpan = box.getColSpan();
        int rowSpan = box.getRowSpan();
        AttributeList attrList = new AttributeList();
        if (colSpan != 0) {
            attrList.setAttribute("http://www.w3.org/1999/xhtml", "colspan", String.valueOf(colSpan));
        }
        if (rowSpan != 0) {
            attrList.setAttribute("http://www.w3.org/1999/xhtml", "rowspan", String.valueOf(rowSpan));
        }
        this.buildStyle(box, builder);
        if (!builder.isEmpty()) {
            attrList.setAttribute("http://www.w3.org/1999/xhtml", "style", builder.toString());
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "td", attrList, false);
        return true;
    }

    protected void finishTableCell(TableCellRenderBox tableRenderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startTableRow(TableRowRenderBox box, StyleBuilder builder) throws IOException {
        this.buildStyle(box, builder);
        AttributeList attList = new AttributeList();
        if (!builder.isEmpty()) {
            attList.setAttribute("http://www.w3.org/1999/xhtml", "style", builder.toString());
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "tr", attList, false);
        return true;
    }

    protected void finishTableRow(TableRowRenderBox tableRenderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startTableHeader(TableSectionRenderBox box, StyleBuilder builder) throws IOException {
        this.buildStyle(box, builder);
        AttributeList attList = new AttributeList();
        if (!builder.isEmpty()) {
            attList.setAttribute("http://www.w3.org/1999/xhtml", "style", builder.toString());
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "thead", attList, false);
        return true;
    }

    protected void finishTableHeader(TableSectionRenderBox tableRenderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startTableBody(TableSectionRenderBox box, StyleBuilder builder) throws IOException {
        this.buildStyle(box, builder);
        AttributeList attList = new AttributeList();
        if (!builder.isEmpty()) {
            attList.setAttribute("http://www.w3.org/1999/xhtml", "style", builder.toString());
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "tbody", attList, false);
        return true;
    }

    protected void finishTableBody(TableSectionRenderBox tableRenderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startTableFooter(TableSectionRenderBox box, StyleBuilder builder) throws IOException {
        this.buildStyle(box, builder);
        AttributeList attList = new AttributeList();
        if (!builder.isEmpty()) {
            attList.setAttribute("http://www.w3.org/1999/xhtml", "style", builder.toString());
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "tfoot", attList, false);
        return true;
    }

    protected void finishTableFooter(TableSectionRenderBox tableRenderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected boolean startTable(TableRenderBox box, StyleBuilder builder) throws IOException {
        this.buildStyle(box, builder);
        AttributeList attList = new AttributeList();
        attList.setAttribute("http://www.w3.org/1999/xhtml", "cellspacing", "0");
        attList.setAttribute("http://www.w3.org/1999/xhtml", "cellpadding", "0");
        if (!builder.isEmpty()) {
            attList.setAttribute("http://www.w3.org/1999/xhtml", "style", builder.toString());
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "table", attList, false);
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "colgroup", false);
        TableColumnModel columnModel = box.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = columnModel.getColumn(i);
            long effectiveSize = column.getEffectiveSize();
            StyleBuilder colbuilder = new StyleBuilder(true);
            colbuilder.append(BoxStyleKeys.WIDTH, this.toPointString(effectiveSize), "pt");
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "col", "style", colbuilder.toString(), true);
        }
        this.xmlWriter.writeCloseTag();
        return true;
    }

    protected void finishTable(TableRenderBox tableRenderBox) throws IOException {
        this.xmlWriter.writeCloseTag();
    }

    protected void startOtherNode(RenderNode node) {
        try {
            if (node instanceof RenderableText) {
                RenderableText text = (RenderableText)node;
                String rawText = text.getRawText();
                String encodedText = HtmlCharacterEntities.getEntityParser().encodeEntities(rawText);
                this.xmlWriter.writeText(encodedText);
            } else if (node instanceof SpacerRenderNode) {
                this.xmlWriter.writeText(" ");
            } else if (node instanceof RenderableReplacedContent) {
                String name;
                RenderableReplacedContent rc = (RenderableReplacedContent)node;
                ResourceKey source = rc.getSource();
                if (source != null && !this.knownResources.containsKey(source) && (name = this.writeRaw(source)) != null) {
                    AttributeList attrList = new AttributeList();
                    attrList.setAttribute("http://www.w3.org/1999/xhtml", "src", name);
                    this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "img", attrList, true);
                    this.knownResources.put(source, name);
                    return;
                }
                Object rawObject = rc.getRawObject();
                if (rawObject instanceof Image) {
                    this.xmlWriter.writeComment("Image content:" + source);
                    String name2 = this.writeImage((Image)rawObject);
                    if (name2 != null) {
                        AttributeList attrList = new AttributeList();
                        attrList.setAttribute("http://www.w3.org/1999/xhtml", "src", name2);
                        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "img", attrList, true);
                    }
                } else if (rawObject instanceof Drawable) {
                    this.xmlWriter.writeComment("Drawable content:" + source);
                    Image image = this.generateImage(node, (Drawable)rawObject);
                    String name3 = this.writeImage(image);
                    if (name3 != null) {
                        AttributeList attrList = new AttributeList();
                        attrList.setAttribute("http://www.w3.org/1999/xhtml", "src", name3);
                        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "img", attrList, true);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new StackableRuntimeException("Failed", (Exception)e);
        }
        catch (ContentIOException e) {
            throw new StackableRuntimeException("Failed", (Exception)((Object)e));
        }
        catch (URLRewriteException e) {
            Log.warn((Object)"Rewriting the URL failed.", (Exception)((Object)e));
            throw new StackableRuntimeException("Failed", (Exception)((Object)e));
        }
    }

    private String writeRaw(ResourceKey source) throws IOException {
        try {
            ContentItem item;
            ResourceData resourceData = this.resourceManager.load(source);
            String mimeType = this.queryMimeType(resourceData);
            if (this.isValidImage(mimeType) && (item = this.dataLocation.createItem(this.dataNameGenerator.generateName(this.extractFilename(resourceData), mimeType))).isWriteable()) {
                item.setAttribute("org.jfree.repository", "content-type", (Object)mimeType);
                InputStream stream = resourceData.getResourceAsStream(this.resourceManager);
                OutputStream outputStream = item.getOutputStream();
                IOUtils.getInstance().copyStreams(stream, outputStream);
                outputStream.close();
                stream.close();
                return this.urlRewriter.rewrite((ContentEntity)this.documentContentItem, (ContentEntity)item);
            }
        }
        catch (ResourceLoadingException e) {
        }
        catch (ContentIOException e) {
        }
        catch (URLRewriteException e) {
            Log.warn((Object)"Rewriting the URL failed.", (Exception)((Object)e));
            throw new StackableRuntimeException("Failed", (Exception)((Object)e));
        }
        return null;
    }

    private String writeImage(Image image) throws ContentIOException, IOException, URLRewriteException {
        WaitingImageObserver obs = new WaitingImageObserver(image);
        obs.waitImageLoaded();
        PngEncoder encoder = new PngEncoder(image, true, 0, 5);
        byte[] data = encoder.pngEncode();
        ContentItem dataFile = this.dataLocation.createItem(this.dataNameGenerator.generateName("picture", "image/png"));
        BufferedOutputStream out = new BufferedOutputStream(dataFile.getOutputStream());
        ((OutputStream)out).write(data);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        return this.urlRewriter.rewrite((ContentEntity)this.documentContentItem, (ContentEntity)dataFile);
    }

    private Image generateImage(RenderNode node, Drawable drawable) {
        int imageWidthPt = (int)StrictGeomUtility.toExternalValue(node.getWidth());
        int imageHeightPt = (int)StrictGeomUtility.toExternalValue(node.getHeight());
        boolean iResMapActive = false;
        if (imageWidthPt == 0 || imageHeightPt == 0) {
            return null;
        }
        double scale = 1.3333333730697632;
        BufferedImage image = ImageUtils.createTransparentImage((int)((double)imageWidthPt * 1.3333333730697632), (int)((double)imageHeightPt * 1.3333333730697632));
        Graphics2D g2 = (Graphics2D)((Image)image).getGraphics();
        g2.scale(1.3333333730697632, 1.3333333730697632);
        Rectangle2D.Double drawBounds = new Rectangle2D.Double(0.0, 0.0, imageWidthPt, imageHeightPt);
        g2.clip(drawBounds);
        drawable.draw(g2, (Rectangle2D)drawBounds);
        g2.dispose();
        return image;
    }

    private String extractFilename(ResourceData resourceData) {
        String filename = (String)resourceData.getAttribute("filename");
        if (filename == null) {
            return "image";
        }
        return IOUtils.getInstance().stripFileExtension(filename);
    }

    private String queryMimeType(ResourceData resourceData) throws ResourceLoadingException, IOException {
        Object contentType = resourceData.getAttribute("content-type");
        if (contentType instanceof String) {
            return (String)contentType;
        }
        byte[] data = new byte[12];
        resourceData.getResource(this.resourceManager, data, 0, data.length);
        if (this.isGIF(new ByteArrayInputStream(data))) {
            return "image/gif";
        }
        if (this.isJPEG(new ByteArrayInputStream(data))) {
            return "image/jpeg";
        }
        if (this.isPNG(new ByteArrayInputStream(data))) {
            return "image/png";
        }
        return null;
    }

    private boolean isPNG(ByteArrayInputStream data) {
        int[] PNF_FINGERPRINT = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
        for (int i = 0; i < PNF_FINGERPRINT.length; ++i) {
            if (PNF_FINGERPRINT[i] == data.read()) continue;
            return false;
        }
        return true;
    }

    private boolean isJPEG(InputStream data) throws IOException {
        int[] JPG_FINGERPRINT_1 = new int[]{255, 216, 255, 224};
        for (int i = 0; i < JPG_FINGERPRINT_1.length; ++i) {
            if (JPG_FINGERPRINT_1[i] == data.read()) continue;
            return false;
        }
        if (data.read() == -1) {
            return false;
        }
        if (data.read() == -1) {
            return false;
        }
        int[] JPG_FINGERPRINT_2 = new int[]{74, 70, 73, 70, 0};
        for (int i = 0; i < JPG_FINGERPRINT_2.length; ++i) {
            if (JPG_FINGERPRINT_2[i] == data.read()) continue;
            return false;
        }
        return true;
    }

    private boolean isGIF(InputStream data) throws IOException {
        int[] GIF_FINGERPRINT = new int[]{71, 73, 70, 56};
        for (int i = 0; i < GIF_FINGERPRINT.length; ++i) {
            if (GIF_FINGERPRINT[i] == data.read()) continue;
            return false;
        }
        return true;
    }

    private boolean isValidImage(String data) {
        return this.validRawTypes.contains(data);
    }

    protected boolean startOtherBox(RenderBox box) {
        return true;
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
            this.processBoxChilds((RenderBox)node);
            RenderNode next = node.getNext();
            if (next == null) break;
            try {
                this.xmlWriter.writeText(" ");
                continue;
            }
            catch (IOException e) {
                throw new StackableRuntimeException("Failed", (Exception)e);
            }
        }
    }

    public void setDataWriter(ContentLocation dataLocation, NameGenerator dataNameGenerator) {
        this.dataNameGenerator = dataNameGenerator;
        this.dataLocation = dataLocation;
    }

    public void setContentWriter(ContentLocation contentLocation, NameGenerator contentNameGenerator) {
        this.contentNameGenerator = contentNameGenerator;
        this.contentLocation = contentLocation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ContextElement {
        private StyleBuilder builder;
        private boolean omitted;

        protected ContextElement(StyleBuilder builder) {
            this.builder = builder;
        }

        public StyleBuilder getBuilder() {
            return this.builder;
        }

        public boolean isOmitted() {
            return this.omitted;
        }

        public void setOmitted(boolean omitted) {
            this.omitted = omitted;
        }
    }
}

