/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.html;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.jfree.io.IOUtils;
import org.jfree.layouting.modules.output.html.URLRewriteException;
import org.jfree.layouting.modules.output.html.URLRewriter;
import org.jfree.repository.ContentEntity;
import org.jfree.repository.ContentLocation;
import org.jfree.repository.Repository;
import org.jfree.repository.UrlRepository;

public class FileSystemURLRewriter
implements URLRewriter {
    public String rewrite(ContentEntity sourceDocument, ContentEntity dataEntity) throws URLRewriteException {
        URL dataItemUrl;
        Repository dataRepository = dataEntity.getRepository();
        if (!(dataRepository instanceof UrlRepository)) {
            throw new URLRewriteException("DataRepository is no URL-Repository.");
        }
        UrlRepository dataUrlRepo = (UrlRepository)dataRepository;
        String dataPath = this.buildPath(dataEntity);
        try {
            dataItemUrl = new URL(dataUrlRepo.getURL(), dataPath);
        }
        catch (MalformedURLException e) {
            throw new URLRewriteException("DataEntity has no valid URL.");
        }
        Repository documentRepository = sourceDocument.getRepository();
        if (!(documentRepository instanceof UrlRepository)) {
            return dataItemUrl.toExternalForm();
        }
        try {
            UrlRepository documentUrlRepo = (UrlRepository)documentRepository;
            String documentPath = this.buildPath(sourceDocument);
            URL documentUrl = new URL(documentUrlRepo.getURL(), documentPath);
            return IOUtils.getInstance().createRelativeURL(dataItemUrl, documentUrl);
        }
        catch (MalformedURLException e) {
            return dataItemUrl.toExternalForm();
        }
    }

    private String buildPath(ContentEntity entity) {
        ArrayList<String> entityNames = new ArrayList<String>();
        entityNames.add(entity.getName());
        for (ContentLocation location = entity.getParent(); location != null; location = location.getParent()) {
            entityNames.add(location.getName());
        }
        StringBuffer b = new StringBuffer();
        for (int i = entityNames.size() - 1; i >= 0; --i) {
            String name = (String)entityNames.get(i);
            b.append(name);
            if (i == 0) continue;
            b.append('/');
        }
        return b.toString();
    }
}

