/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.graphics;

import org.jfree.fonts.awt.AWTFontRegistry;
import org.jfree.fonts.registry.DefaultFontStorage;
import org.jfree.fonts.registry.FontRegistry;
import org.jfree.fonts.registry.FontStorage;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.modules.output.graphics.GraphicsContentInterceptor;
import org.jfree.layouting.modules.output.graphics.GraphicsOutputProcessorMetaData;
import org.jfree.layouting.modules.output.graphics.LogicalPageDrawable;
import org.jfree.layouting.output.AbstractOutputProcessor;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.output.pageable.LogicalPageKey;
import org.jfree.layouting.renderer.PaginatingRenderer;
import org.jfree.layouting.renderer.PrototypeBuildingRenderer;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.util.Configuration;

public class FlowGraphicsOutputProcessor
extends AbstractOutputProcessor {
    private OutputProcessorMetaData metaData;
    private GraphicsContentInterceptor interceptor;
    private PrototypeBuildingRenderer prototypeBuilder;

    public FlowGraphicsOutputProcessor(Configuration configuration) {
        super(configuration);
        DefaultFontStorage fontStorage = new DefaultFontStorage((FontRegistry)new AWTFontRegistry());
        this.metaData = new GraphicsOutputProcessorMetaData((FontStorage)fontStorage, true);
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    public GraphicsContentInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(GraphicsContentInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    protected void processPageContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage) {
        if (this.interceptor != null) {
            LogicalPageDrawable page = new LogicalPageDrawable(logicalPage);
            this.interceptor.processLogicalPage(logicalPageKey, page);
        }
    }

    public PrototypeBuildingRenderer getPrototypeBuilder() {
        return this.prototypeBuilder;
    }

    public Renderer createRenderer(LayoutProcess layoutProcess) {
        if (!this.isGlobalStateComputed()) {
            this.prototypeBuilder = new PrototypeBuildingRenderer(layoutProcess);
            return this.prototypeBuilder;
        }
        return new PaginatingRenderer(layoutProcess);
    }
}

