/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.percentages.fonts;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class MaxMinFontSizeResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_SIZE};
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        LayoutContext layoutContext = currentNode.getLayoutContext();
        CSSValue value = layoutContext.getValue(key);
        if (!(value instanceof CSSNumericValue)) {
            return;
        }
        CSSNumericValue size = CSSValueResolverUtility.convertLength(value, layoutContext, process.getOutputMetaData());
        layoutContext.setValue(key, size);
    }
}

