/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.percentages.fonts;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class FontSizeResolveHandler
implements ResolveHandler {
    private double baseFontSize = this.parseDouble("org.jfree.layouting.defaults.FontSize", 12.0);

    private double parseDouble(String configKey, double defaultValue) {
        LibLayoutBoot boot = LibLayoutBoot.getInstance();
        String value = boot.getGlobalConfig().getConfigProperty(configKey);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        LayoutContext layoutContext = currentNode.getLayoutContext();
        CSSValue value = layoutContext.getValue(key);
        LayoutElement parent = currentNode.getParent();
        FontSpecification fontSpecification = currentNode.getLayoutContext().getFontSpecification();
        if (!(value instanceof CSSNumericValue)) {
            if (parent == null) {
                fontSpecification.setFontSize(this.baseFontSize);
                layoutContext.setValue(key, CSSNumericValue.createValue(CSSNumericType.PT, this.baseFontSize));
            } else {
                LayoutContext parentContext = parent.getLayoutContext();
                FontSpecification parentFont = parentContext.getFontSpecification();
                double fontSize = parentFont.getFontSize();
                fontSpecification.setFontSize(fontSize);
                layoutContext.setValue(key, CSSNumericValue.createValue(CSSNumericType.PT, fontSize));
            }
            return;
        }
        CSSNumericValue nval = (CSSNumericValue)value;
        if (CSSValueResolverUtility.isAbsoluteValue(nval)) {
            CSSNumericValue fsize = CSSValueResolverUtility.convertLength(nval, currentNode.getLayoutContext(), process.getOutputMetaData());
            double fontSize = fsize.getValue();
            fontSpecification.setFontSize(fontSize);
            layoutContext.setValue(key, CSSNumericValue.createValue(CSSNumericType.PT, fontSize));
        } else if (CSSNumericType.EM.equals(nval.getType())) {
            double parentSize;
            if (parent == null) {
                parentSize = this.baseFontSize;
            } else {
                LayoutContext parentContext = parent.getLayoutContext();
                FontSpecification parentFont = parentContext.getFontSpecification();
                parentSize = parentFont.getFontSize();
            }
            double fontSize = parentSize * nval.getValue();
            fontSpecification.setFontSize(fontSize);
            layoutContext.setValue(key, CSSNumericValue.createValue(CSSNumericType.PT, fontSize));
        } else if (CSSNumericType.EX.equals(nval.getType())) {
            double parentSize;
            if (parent == null) {
                parentSize = this.baseFontSize * 0.5 / 0.7;
            } else {
                LayoutContext parentContext = parent.getLayoutContext();
                FontSpecification parentFont = parentContext.getFontSpecification();
                parentSize = parentFont.getFontSize();
            }
            double fontSize = parentSize * nval.getValue();
            layoutContext.setValue(key, CSSNumericValue.createValue(CSSNumericType.PT, fontSize));
            fontSpecification.setFontSize(fontSize);
        } else if (CSSNumericType.PERCENTAGE.equals(nval.getType())) {
            double parentSize;
            if (parent == null) {
                parentSize = this.baseFontSize;
            } else {
                LayoutContext parentContext = parent.getLayoutContext();
                FontSpecification parentFont = parentContext.getFontSpecification();
                parentSize = parentFont.getFontSize();
            }
            double fontSize = parentSize * nval.getValue() / 100.0;
            fontSpecification.setFontSize(fontSize);
            layoutContext.setValue(key, CSSNumericValue.createValue(CSSNumericType.PT, fontSize));
        } else {
            fontSpecification.setFontSize(this.baseFontSize);
            layoutContext.setValue(key, CSSNumericValue.createValue(CSSNumericType.PT, this.baseFontSize));
        }
    }
}

